#
# TABLE STRUCTURE FOR: activities
#

DROP TABLE IF EXISTS `activities`;

CREATE TABLE `activities` (
  `activitiesID` int(11) NOT NULL AUTO_INCREMENT,
  `activitiescategoryID` int(11) NOT NULL,
  `description` text NOT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `time_to` varchar(40) DEFAULT NULL,
  `time_from` varchar(40) DEFAULT NULL,
  `time_at` varchar(40) DEFAULT NULL,
  `usertypeID` int(11) NOT NULL,
  `userID` int(11) NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  PRIMARY KEY (`activitiesID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `activities` (`activitiesID`, `activitiescategoryID`, `description`, `create_date`, `modify_date`, `time_to`, `time_from`, `time_at`, `usertypeID`, `userID`, `schoolyearID`) VALUES (1, 1, 'CREATIE', '2023-07-08 12:06:11', '2023-07-08 12:06:11', '15:05:00', '15:05:00', '15:05:00', 1, 1, 3);


#
# TABLE STRUCTURE FOR: activitiescategory
#

DROP TABLE IF EXISTS `activitiescategory`;

CREATE TABLE `activitiescategory` (
  `activitiescategoryID` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `fa_icon` varchar(40) DEFAULT NULL,
  `schoolyearID` int(11) NOT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `userID` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`activitiescategoryID`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

INSERT INTO `activitiescategory` (`activitiescategoryID`, `title`, `fa_icon`, `schoolyearID`, `create_date`, `modify_date`, `userID`, `usertypeID`) VALUES (1, 'Photos', 'fa-picture-o', 19, '2017-04-30 09:04:15', '2017-08-01 05:15:23', 1, 1);
INSERT INTO `activitiescategory` (`activitiescategoryID`, `title`, `fa_icon`, `schoolyearID`, `create_date`, `modify_date`, `userID`, `usertypeID`) VALUES (2, 'Food', 'fa-cutlery', 19, '2017-04-30 02:28:09', '2017-04-30 02:28:09', 1, 1);
INSERT INTO `activitiescategory` (`activitiescategoryID`, `title`, `fa_icon`, `schoolyearID`, `create_date`, `modify_date`, `userID`, `usertypeID`) VALUES (3, 'Sleep', 'fa-bed', 19, '2017-04-30 02:51:08', '2017-04-30 02:51:08', 1, 1);
INSERT INTO `activitiescategory` (`activitiescategoryID`, `title`, `fa_icon`, `schoolyearID`, `create_date`, `modify_date`, `userID`, `usertypeID`) VALUES (4, 'Sports', 'fa-trophy', 19, '2017-04-30 02:52:04', '2017-04-30 02:52:04', 1, 1);
INSERT INTO `activitiescategory` (`activitiescategoryID`, `title`, `fa_icon`, `schoolyearID`, `create_date`, `modify_date`, `userID`, `usertypeID`) VALUES (5, 'Activities', 'fa-puzzle-piece', 19, '2017-04-30 02:52:36', '2017-04-30 02:56:41', 1, 1);
INSERT INTO `activitiescategory` (`activitiescategoryID`, `title`, `fa_icon`, `schoolyearID`, `create_date`, `modify_date`, `userID`, `usertypeID`) VALUES (6, 'Note', 'fa-edit', 19, '2017-04-30 02:55:08', '2017-04-30 02:55:08', 1, 1);
INSERT INTO `activitiescategory` (`activitiescategoryID`, `title`, `fa_icon`, `schoolyearID`, `create_date`, `modify_date`, `userID`, `usertypeID`) VALUES (7, 'Incident', 'fa-times', 19, '2017-04-30 03:00:54', '2017-04-30 03:02:37', 1, 1);
INSERT INTO `activitiescategory` (`activitiescategoryID`, `title`, `fa_icon`, `schoolyearID`, `create_date`, `modify_date`, `userID`, `usertypeID`) VALUES (8, 'Meds', 'fa-medkit', 19, '2017-04-30 03:02:47', '2017-04-30 03:02:47', 1, 1);
INSERT INTO `activitiescategory` (`activitiescategoryID`, `title`, `fa_icon`, `schoolyearID`, `create_date`, `modify_date`, `userID`, `usertypeID`) VALUES (9, 'Art', 'fa-paint-brush', 19, '2017-04-30 03:06:07', '2017-04-30 03:06:07', 1, 1);


#
# TABLE STRUCTURE FOR: activitiescomment
#

DROP TABLE IF EXISTS `activitiescomment`;

CREATE TABLE `activitiescomment` (
  `activitiescommentID` int(11) NOT NULL AUTO_INCREMENT,
  `activitiesID` int(11) NOT NULL,
  `comment` text NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  `userID` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `create_date` datetime NOT NULL,
  PRIMARY KEY (`activitiescommentID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: activitiesmedia
#

DROP TABLE IF EXISTS `activitiesmedia`;

CREATE TABLE `activitiesmedia` (
  `activitiesmediaID` int(11) NOT NULL AUTO_INCREMENT,
  `activitiesID` int(11) NOT NULL,
  `attachment` text NOT NULL,
  `create_date` datetime NOT NULL,
  PRIMARY KEY (`activitiesmediaID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: activitiesstudent
#

DROP TABLE IF EXISTS `activitiesstudent`;

CREATE TABLE `activitiesstudent` (
  `activitiesstudentID` int(11) NOT NULL AUTO_INCREMENT,
  `activitiesID` int(11) NOT NULL,
  `studentID` int(11) NOT NULL,
  `classesID` int(11) NOT NULL,
  PRIMARY KEY (`activitiesstudentID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: addons
#

DROP TABLE IF EXISTS `addons`;

CREATE TABLE `addons` (
  `addonsID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `package_name` varchar(180) DEFAULT NULL,
  `slug` varchar(180) DEFAULT NULL,
  `description` longtext,
  `version` varchar(11) DEFAULT NULL,
  `author` varchar(100) DEFAULT NULL,
  `init` longtext,
  `files` longtext,
  `preview_image` varchar(180) DEFAULT NULL,
  `date` datetime NOT NULL,
  `userID` int(11) NOT NULL,
  `usertypeID` varchar(100) NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`addonsID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: alert
#

DROP TABLE IF EXISTS `alert`;

CREATE TABLE `alert` (
  `alertID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `itemID` int(11) NOT NULL,
  `userID` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `itemname` varchar(128) NOT NULL,
  PRIMARY KEY (`alertID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: asset
#

DROP TABLE IF EXISTS `asset`;

CREATE TABLE `asset` (
  `assetID` int(11) NOT NULL AUTO_INCREMENT,
  `serial` varchar(255) DEFAULT NULL,
  `description` text COMMENT 'Title',
  `manufacturer` varchar(255) DEFAULT NULL,
  `brand` varchar(255) DEFAULT NULL,
  `asset_number` varchar(255) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `asset_condition` int(11) DEFAULT NULL,
  `attachment` text,
  `originalfile` text,
  `asset_categoryID` int(11) DEFAULT NULL,
  `asset_locationID` int(11) DEFAULT NULL,
  `create_date` date NOT NULL,
  `modify_date` date NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`assetID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: asset_assignment
#

DROP TABLE IF EXISTS `asset_assignment`;

CREATE TABLE `asset_assignment` (
  `asset_assignmentID` int(11) NOT NULL AUTO_INCREMENT,
  `assetID` int(11) NOT NULL COMMENT 'Description and title',
  `usertypeID` int(11) DEFAULT NULL,
  `check_out_to` int(11) NOT NULL,
  `due_date` date DEFAULT NULL,
  `note` text,
  `assigned_quantity` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `asset_locationID` int(11) DEFAULT NULL,
  `check_out_date` date DEFAULT NULL,
  `check_in_date` date DEFAULT NULL,
  `create_date` date NOT NULL,
  `modify_date` date NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`asset_assignmentID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: asset_category
#

DROP TABLE IF EXISTS `asset_category`;

CREATE TABLE `asset_category` (
  `asset_categoryID` int(11) NOT NULL AUTO_INCREMENT,
  `category` varchar(255) NOT NULL,
  `create_date` date NOT NULL,
  `modify_date` date NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  `active` int(11) NOT NULL,
  PRIMARY KEY (`asset_categoryID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: assignment
#

DROP TABLE IF EXISTS `assignment`;

CREATE TABLE `assignment` (
  `assignmentID` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(128) NOT NULL,
  `description` text NOT NULL,
  `deadlinedate` date NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `userID` int(11) NOT NULL,
  `originalfile` text NOT NULL,
  `file` text NOT NULL,
  `classesID` longtext NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  `sectionID` longtext,
  `subjectID` longtext,
  `assignusertypeID` int(11) DEFAULT NULL,
  `assignuserID` int(11) DEFAULT NULL,
  PRIMARY KEY (`assignmentID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: assignmentanswer
#

DROP TABLE IF EXISTS `assignmentanswer`;

CREATE TABLE `assignmentanswer` (
  `assignmentanswerID` int(11) NOT NULL AUTO_INCREMENT,
  `assignmentID` int(11) NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  `uploaderID` int(11) NOT NULL,
  `uploadertypeID` int(11) NOT NULL,
  `answerfile` text NOT NULL,
  `answerfileoriginal` text NOT NULL,
  `answerdate` date NOT NULL,
  PRIMARY KEY (`assignmentanswerID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: attendance
#

DROP TABLE IF EXISTS `attendance`;

CREATE TABLE `attendance` (
  `attendanceID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `schoolyearID` int(11) NOT NULL,
  `studentID` int(11) NOT NULL,
  `classesID` int(11) NOT NULL,
  `sectionID` int(11) NOT NULL,
  `userID` int(11) NOT NULL,
  `usertype` varchar(60) NOT NULL,
  `monthyear` varchar(10) NOT NULL,
  `a1` varchar(3) DEFAULT NULL,
  `a2` varchar(3) DEFAULT NULL,
  `a3` varchar(3) DEFAULT NULL,
  `a4` varchar(3) DEFAULT NULL,
  `a5` varchar(3) DEFAULT NULL,
  `a6` varchar(3) DEFAULT NULL,
  `a7` varchar(3) DEFAULT NULL,
  `a8` varchar(3) DEFAULT NULL,
  `a9` varchar(3) DEFAULT NULL,
  `a10` varchar(3) DEFAULT NULL,
  `a11` varchar(3) DEFAULT NULL,
  `a12` varchar(3) DEFAULT NULL,
  `a13` varchar(3) DEFAULT NULL,
  `a14` varchar(3) DEFAULT NULL,
  `a15` varchar(3) DEFAULT NULL,
  `a16` varchar(3) DEFAULT NULL,
  `a17` varchar(3) DEFAULT NULL,
  `a18` varchar(3) DEFAULT NULL,
  `a19` varchar(3) DEFAULT NULL,
  `a20` varchar(3) DEFAULT NULL,
  `a21` varchar(3) DEFAULT NULL,
  `a22` varchar(3) DEFAULT NULL,
  `a23` varchar(3) DEFAULT NULL,
  `a24` varchar(3) DEFAULT NULL,
  `a25` varchar(3) DEFAULT NULL,
  `a26` varchar(3) DEFAULT NULL,
  `a27` varchar(3) DEFAULT NULL,
  `a28` varchar(3) DEFAULT NULL,
  `a29` varchar(3) DEFAULT NULL,
  `a30` varchar(3) DEFAULT NULL,
  `a31` varchar(3) DEFAULT NULL,
  PRIMARY KEY (`attendanceID`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

INSERT INTO `attendance` (`attendanceID`, `schoolyearID`, `studentID`, `classesID`, `sectionID`, `userID`, `usertype`, `monthyear`, `a1`, `a2`, `a3`, `a4`, `a5`, `a6`, `a7`, `a8`, `a9`, `a10`, `a11`, `a12`, `a13`, `a14`, `a15`, `a16`, `a17`, `a18`, `a19`, `a20`, `a21`, `a22`, `a23`, `a24`, `a25`, `a26`, `a27`, `a28`, `a29`, `a30`, `a31`) VALUES (1, 4, 1, 10, 10, 1, 'Admin', '03-2024', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL);
INSERT INTO `attendance` (`attendanceID`, `schoolyearID`, `studentID`, `classesID`, `sectionID`, `userID`, `usertype`, `monthyear`, `a1`, `a2`, `a3`, `a4`, `a5`, `a6`, `a7`, `a8`, `a9`, `a10`, `a11`, `a12`, `a13`, `a14`, `a15`, `a16`, `a17`, `a18`, `a19`, `a20`, `a21`, `a22`, `a23`, `a24`, `a25`, `a26`, `a27`, `a28`, `a29`, `a30`, `a31`) VALUES (2, 4, 1, 10, 10, 1, 'Admin', '04-2024', NULL, 'P', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `attendance` (`attendanceID`, `schoolyearID`, `studentID`, `classesID`, `sectionID`, `userID`, `usertype`, `monthyear`, `a1`, `a2`, `a3`, `a4`, `a5`, `a6`, `a7`, `a8`, `a9`, `a10`, `a11`, `a12`, `a13`, `a14`, `a15`, `a16`, `a17`, `a18`, `a19`, `a20`, `a21`, `a22`, `a23`, `a24`, `a25`, `a26`, `a27`, `a28`, `a29`, `a30`, `a31`) VALUES (3, 4, 1, 10, 10, 1, 'Admin', '05-2024', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `attendance` (`attendanceID`, `schoolyearID`, `studentID`, `classesID`, `sectionID`, `userID`, `usertype`, `monthyear`, `a1`, `a2`, `a3`, `a4`, `a5`, `a6`, `a7`, `a8`, `a9`, `a10`, `a11`, `a12`, `a13`, `a14`, `a15`, `a16`, `a17`, `a18`, `a19`, `a20`, `a21`, `a22`, `a23`, `a24`, `a25`, `a26`, `a27`, `a28`, `a29`, `a30`, `a31`) VALUES (4, 4, 18, 10, 10, 1, 'Admin', '06-2024', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `attendance` (`attendanceID`, `schoolyearID`, `studentID`, `classesID`, `sectionID`, `userID`, `usertype`, `monthyear`, `a1`, `a2`, `a3`, `a4`, `a5`, `a6`, `a7`, `a8`, `a9`, `a10`, `a11`, `a12`, `a13`, `a14`, `a15`, `a16`, `a17`, `a18`, `a19`, `a20`, `a21`, `a22`, `a23`, `a24`, `a25`, `a26`, `a27`, `a28`, `a29`, `a30`, `a31`) VALUES (5, 4, 1, 10, 10, 1, 'Admin', '06-2024', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `attendance` (`attendanceID`, `schoolyearID`, `studentID`, `classesID`, `sectionID`, `userID`, `usertype`, `monthyear`, `a1`, `a2`, `a3`, `a4`, `a5`, `a6`, `a7`, `a8`, `a9`, `a10`, `a11`, `a12`, `a13`, `a14`, `a15`, `a16`, `a17`, `a18`, `a19`, `a20`, `a21`, `a22`, `a23`, `a24`, `a25`, `a26`, `a27`, `a28`, `a29`, `a30`, `a31`) VALUES (6, 4, 2, 9, 23, 1, 'Admin', '06-2024', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `attendance` (`attendanceID`, `schoolyearID`, `studentID`, `classesID`, `sectionID`, `userID`, `usertype`, `monthyear`, `a1`, `a2`, `a3`, `a4`, `a5`, `a6`, `a7`, `a8`, `a9`, `a10`, `a11`, `a12`, `a13`, `a14`, `a15`, `a16`, `a17`, `a18`, `a19`, `a20`, `a21`, `a22`, `a23`, `a24`, `a25`, `a26`, `a27`, `a28`, `a29`, `a30`, `a31`) VALUES (7, 4, 11, 10, 10, 1, 'Admin', '06-2024', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `attendance` (`attendanceID`, `schoolyearID`, `studentID`, `classesID`, `sectionID`, `userID`, `usertype`, `monthyear`, `a1`, `a2`, `a3`, `a4`, `a5`, `a6`, `a7`, `a8`, `a9`, `a10`, `a11`, `a12`, `a13`, `a14`, `a15`, `a16`, `a17`, `a18`, `a19`, `a20`, `a21`, `a22`, `a23`, `a24`, `a25`, `a26`, `a27`, `a28`, `a29`, `a30`, `a31`) VALUES (8, 4, 54, 9, 9, 1, 'Admin', '06-2024', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);


#
# TABLE STRUCTURE FOR: automation_rec
#

DROP TABLE IF EXISTS `automation_rec`;

CREATE TABLE `automation_rec` (
  `automation_recID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `studentID` int(11) NOT NULL,
  `date` date NOT NULL,
  `day` varchar(3) NOT NULL,
  `month` varchar(3) NOT NULL,
  `year` year(4) NOT NULL,
  `nofmodule` int(11) NOT NULL,
  PRIMARY KEY (`automation_recID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: automation_shudulu
#

DROP TABLE IF EXISTS `automation_shudulu`;

CREATE TABLE `automation_shudulu` (
  `automation_shuduluID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `day` varchar(3) NOT NULL,
  `month` varchar(3) NOT NULL,
  `year` year(4) NOT NULL,
  PRIMARY KEY (`automation_shuduluID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: book
#

DROP TABLE IF EXISTS `book`;

CREATE TABLE `book` (
  `bookID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `book` varchar(60) NOT NULL,
  `subject_code` tinytext NOT NULL,
  `author` varchar(100) NOT NULL,
  `price` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  `due_quantity` int(11) NOT NULL,
  `rack` tinytext NOT NULL,
  PRIMARY KEY (`bookID`)
) ENGINE=InnoDB AUTO_INCREMENT=68 DEFAULT CHARSET=utf8;

INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (1, 'KLB TOP SCHOLAR -IRE7', '605', 'MWANAIDI LYANI', 0, 15, 8, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (2, 'OXFORD HEADSTART-ENGLISH', '601', 'ANGELINA KIOKO', 0, 20, 8, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (4, 'STORY MOJA SPARK -AGRICULTURE', '604', 'JANE MUINDE', 0, 20, 0, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (5, 'MORAN -SOCIAL STUDIES', '605', 'FERDINANDA GACHANG\'I', 0, 18, 8, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (6, 'KLB TOP-SCHOLAR-IRE8', '605', 'IDRIS MATSUKHU', 0, 10, 2, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (7, 'MTP HOMESCIENCE 7', '604', 'MTP', 0, 20, 18, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (8, 'KLB TOP- SCHOLAR-PRE-TECHNICAL 8', '606', 'OMUKAGA .O.PANYAKO', 0, 20, 10, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (9, 'OXFORD BUSINESS TODAY', '605', 'KENNETH MBUVI', 0, 20, 7, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (10, 'KLB TOP SCHOLAR PRE-TECHINICAL 7', '606', 'OMUKAGA .O.PANYAKO', 0, 25, 19, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (11, 'SPOTLIGHT- MATHEMATICS', '603', 'BONIFACE TINEGA', 0, 20, 9, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (13, 'MORAN SKILLS IN ENGLISH 7', '601', 'DIANE OMONDI', 0, 25, 24, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (14, 'SPOTLIGHT- MATHEMATICS G7', '603', 'BONIFACE TINEGA', 0, 25, 23, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (15, 'KLB TOP-SCHOLAR COMPUTER SCIENCE 7', '606', 'DOROTHY OCHIENG', 0, 25, 25, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (16, 'KLB TOP-SCHOLAR-PHYSICAL EDUCATION AND SPORTS', '604', 'RUTH KAHIGA', 0, 10, 8, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (17, 'OXFORD - KISWAHILI FASAHA G8', '602', 'AHMED SHIKUKU', 0, 20, 9, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (19, 'KLB TOP SCHOLAR COMPUTER SCIENCE 8', '606', 'DOROTHY ALOUCH', 0, 20, 0, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (20, 'OXFORD INTERGRATED SCIENCE', '604', 'JACOB ODHIAMBO', 0, 25, 0, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (21, 'MENTOR HOMESCIENCE', '604', 'ESTHER KARANJA', 0, 10, 3, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (24, 'KLB TOP-SCHOLAR KISWAHILI 7', '602', 'MUTAHI MIRICHO', 0, 25, 20, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (25, 'MTP BUSINESS STUDIES 7.', '606', 'MTP', 0, 25, 24, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (26, 'MENTOR INTERGRATED SCIENCE 8.', '606', 'C KOGI', 0, 20, 8, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (27, 'STORY MOJA -SPARK AGRICULTURE', '604', 'STORY MOJA', 0, 25, 0, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (28, 'STORY MOJA -SPARK AGRICULTURE 7.', '604', 'STORY MOJA', 0, 25, 25, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (29, 'MORAN PUBLISHERS-THRIVING LIFE SKILLS EDUCATION 7', '605', 'MORAN', 0, 20, 0, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (32, 'KLB TOP-SCHOLAR  CRE 8.', '605', 'JANE NTAARI', 0, 20, 5, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (33, 'ACTIVE INTERGRATED SCIENCE-TEACHER\'S GUIDE 7', '603', 'OXFORD-JACOB ODHIAMBO', 0, 2, 0, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (34, 'MORAN PRE-TECHNICAL STUDIES -TEACHER\'S GUIDE 7', '606', 'ABRAHAM KIRUGO', 0, 1, 0, 'GARDE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (35, 'CHOICE MATHEMATICS TEACHER\'S GUIDE 8', '601', 'NICKSON OSHOME', 0, 1, 0, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (36, 'STADI ZA KISWAHILI KITABU CHA MWALIMU 7', '602', 'MARY NDUNG\'U', 0, 1, 0, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (37, 'THRIVING LIFE SKILLS TEACHER\'S GUIDE 7', '605', 'RHODAH MUTENDE', 0, 1, 0, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (38, 'TOLEO LA 4 KAMUSI YA  KISWAHILI SANIFU-TUKI', '602', 'OXFORD UN.', 0, 1, 0, 'GARDE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (39, 'MORAN SKILLS IN ENGLISH -TEACHER\'S GUIDE 8', '601', 'DIANE OMONDI', 0, 1, 0, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (40, 'OXFORD HEADSTART ENGLISH -TEACHER\'S GUIDE 7', '601', 'ANGELINA KIOKO', 0, 1, 0, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (41, 'MORAN AGRICULTURE-TEACHER\'S GUIDE', '604', 'FRANCIS MSUNGU', 0, 1, 0, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (42, 'MORAN AGRICULTURE-TEACHER\'S GUIDE 8', '605', 'FRANCIS MUSUNGU', 0, 1, 0, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (43, 'STORY MOJA-SPARK AGRICULTURE TEACHER\'S GUIDE 7', '605', 'JANE MUINDE', 0, 1, 0, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (44, 'MORAN SOCIAL STUDIES TEACHER\'S GUIDE 8', '605', 'FERDINANDA GACHANG\'I', 0, 1, 0, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (45, 'MORAN PRE-TECHNICAL STUDIES -TEACHER\'S GUIDE 8', '605', 'ABRAHAM KIRUGO', 0, 1, 0, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (46, 'SPOTLIGHT MATHEMATICS-TEACHER\'S GUIDE 7', '601', 'BONIFACE TINEGA', 0, 1, 0, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (47, 'SPOTLIGHT SOCIAL STUDIES', '605', 'SALOME WANGUI', 0, 1, 0, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (48, 'LOVE THY NEIGHBOUR-C.R.E TEACHER\'S GUIDE BOOK 7', '605', 'LINA KIGET', 0, 1, 0, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (49, 'LOVE THY NEIGHBOUR-C.R.E TEACHER\'S GUIDE BOOK 8', '605', 'LINET KIGET', 0, 1, 0, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (50, 'MORAN SOCIAL STUDIES TEACHER\'S GUIDE 7', '605', 'FERDINANDA GACHANG\'I', 0, 1, 0, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (51, 'JUNIOR SCHOOL CURRICULUM DESIGN MATHS 8', '601', 'KICD', 0, 1, 0, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (52, 'JUNIOR CURRICULUM DESIGN ENGLISH 8', '601', 'KICD', 0, 1, 0, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (53, 'JUNIOR CURRICULUM HEALTH EDUCATION 7', '604', 'KICD', 0, 1, 0, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (54, 'JUNIOR SCHOOL CURRICULUM DESIGN AGRICULTURE7', '605', 'KICD', 0, 1, 0, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (55, 'JUNIOR SCHOOL CURRICULUM DESIGN IRE 8', '605', 'KICD', 0, 1, 0, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (56, 'MTAALA WA DARAJA AWALI SHULE ZA UPILI KISW 7', '602', 'KICD', 0, 1, 1, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (57, 'MTAALA WA DARAJA YA AWALI YA SHULE ZA UPILI KISW 8', '602', 'KICD', 0, 1, 0, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (58, 'CBC INSTRUCTION AND CLASS ROOM ASSESSMENT', '0', 'ONE PLANET BOSIRE MONARI', 0, 2, 0, '0');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (59, 'CBC PARENTAL EMPOWERMENT AND ENGAGEMENT IN CBC', '0', 'ONE PLANET -AGUMBA NDALOH', 0, 2, 0, '0');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (60, 'COMBINED ENCYCLOPEDIA GRADE 8', '0', 'TARGETER EDUCATION PUBLISHER LTD', 0, 2, 0, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (61, 'TARGETER COMBINED ENCYCLOPEDIA GRADE 8', '0', 'TARGETER EDUCATION PUBLISHER LTD', 0, 2, 0, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (62, 'TARGETER COMBINED ENCYCLOPEDIA GRADE 8', '0', 'TARGETER EDUCATION PUBLISHER LTD', 0, 2, 0, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (63, 'TARGETER COMBINED ENCYCLOPEDIA GRADE 8', '0', 'TARGETER EDUCATION PUBLISHER LTD', 0, 2, 0, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (64, 'JUNIOR CURRICULUM DESIGN SOCIAL STUDIES 8', '0', 'KICD', 0, 1, 0, 'GRADE 8');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (65, 'JUIOR SCHOOL CURRICULUM DESIGN MATHS 7', '601', 'KICD', 0, 1, 0, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (66, 'SMART MINDS SOCIAL STUDIES 7.', '605', 'MOSES ONYANCHA', 0, 40, 20, 'GRADE 7');
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES (67, 'KLB TOP-SCHOLAR - CRE.7', '605', 'PHILOMENA.N.MWAURA', 0, 35, 22, 'GRADE 7');


#
# TABLE STRUCTURE FOR: candidate
#

DROP TABLE IF EXISTS `candidate`;

CREATE TABLE `candidate` (
  `candidateID` int(11) NOT NULL AUTO_INCREMENT,
  `studentID` int(11) NOT NULL,
  `verified_by` varchar(100) NOT NULL,
  `date_verification` date DEFAULT NULL,
  `schoolyearID` int(11) NOT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`candidateID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: category
#

DROP TABLE IF EXISTS `category`;

CREATE TABLE `category` (
  `categoryID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hostelID` int(11) NOT NULL,
  `class_type` varchar(60) NOT NULL,
  `hbalance` varchar(20) NOT NULL,
  `note` text,
  PRIMARY KEY (`categoryID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: certificate_template
#

DROP TABLE IF EXISTS `certificate_template`;

CREATE TABLE `certificate_template` (
  `certificate_templateID` int(11) NOT NULL AUTO_INCREMENT,
  `usertypeID` int(11) NOT NULL,
  `name` varchar(60) NOT NULL,
  `theme` int(11) NOT NULL,
  `top_heading_title` text,
  `top_heading_left` text,
  `top_heading_right` text,
  `top_heading_middle` text,
  `main_middle_text` text NOT NULL,
  `template` text NOT NULL,
  `footer_left_text` text,
  `footer_right_text` text,
  `footer_middle_text` text,
  `background_image` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`certificate_templateID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: childcare
#

DROP TABLE IF EXISTS `childcare`;

CREATE TABLE `childcare` (
  `childcareID` int(11) NOT NULL AUTO_INCREMENT,
  `dropped_at` datetime DEFAULT NULL,
  `received_at` datetime DEFAULT NULL,
  `usertypeID` int(11) NOT NULL,
  `userID` int(11) NOT NULL,
  `parentID` int(11) NOT NULL,
  `signature` text,
  `classesID` int(11) NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  `comment` text,
  `received_status` int(11) NOT NULL DEFAULT '0',
  `receiver_name` varchar(40) NOT NULL,
  `phone` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`childcareID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: classes
#

DROP TABLE IF EXISTS `classes`;

CREATE TABLE `classes` (
  `classesID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `classes` varchar(60) NOT NULL,
  `classes_numeric` int(11) NOT NULL,
  `teacherID` int(11) NOT NULL,
  `studentmaxID` int(11) DEFAULT NULL,
  `note` text,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_username` varchar(60) NOT NULL,
  `create_usertype` varchar(60) NOT NULL,
  `start_time` time DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  PRIMARY KEY (`classesID`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

INSERT INTO `classes` (`classesID`, `classes`, `classes_numeric`, `teacherID`, `studentmaxID`, `note`, `create_date`, `modify_date`, `create_userID`, `create_username`, `create_usertype`, `start_time`, `end_time`) VALUES (9, 'GRADE 7', 1, 28, 999999999, '', '2021-09-18 07:11:27', '2024-02-28 08:53:33', 1, 'skooly', 'Admin', '06:00:00', '03:00:00');
INSERT INTO `classes` (`classesID`, `classes`, `classes_numeric`, `teacherID`, `studentmaxID`, `note`, `create_date`, `modify_date`, `create_userID`, `create_username`, `create_usertype`, `start_time`, `end_time`) VALUES (10, 'GRADE 8', 2, 28, 999999999, '', '2021-09-18 07:11:53', '2024-02-28 08:53:41', 1, 'skooly', 'Admin', '03:00:00', '03:00:00');


#
# TABLE STRUCTURE FOR: clock_in_out
#

DROP TABLE IF EXISTS `clock_in_out`;

CREATE TABLE `clock_in_out` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attendanceID` int(11) NOT NULL,
  `userID` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `check_date` date NOT NULL,
  `clock_in` time DEFAULT NULL,
  `clock_out` time DEFAULT NULL,
  `last_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=72 DEFAULT CHARSET=utf8mb4;

INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (1, 1, 1, 3, '2024-03-28', '08:18:13', '08:18:28', '2024-03-28 05:18:28');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (2, 1, 4, 11, '2024-03-28', '08:24:30', NULL, '2024-03-28 05:24:30');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (3, 2, 1, 3, '2024-04-02', '10:46:03', NULL, '2024-04-02 07:46:03');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (4, 3, 1, 3, '2024-05-09', '13:30:05', '13:30:21', '2024-05-09 10:30:21');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (5, 1, 31, 2, '2024-05-18', '11:18:29', '11:18:42', '2024-05-18 08:18:42');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (6, 2, 10, 7, '2024-05-18', '11:25:55', '11:25:51', '2024-05-18 08:25:55');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (7, 2, 10, 7, '2024-05-27', '11:27:44', NULL, '2024-05-27 08:27:44');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (8, 2, 33, 2, '2024-06-04', '17:13:00', NULL, '2024-06-04 14:13:00');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (9, 3, 10, 7, '2024-06-04', '06:54:00', NULL, '2024-06-04 03:54:00');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (10, 3, 32, 2, '2024-06-04', '17:03:31', NULL, '2024-06-04 14:03:31');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (11, 4, 34, 2, '2024-06-04', '06:53:09', NULL, '2024-06-04 03:53:09');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (12, 5, 31, 2, '2024-06-04', '17:03:37', NULL, '2024-06-04 14:03:37');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (13, 4, 2, 9, '2024-06-04', '06:58:48', NULL, '2024-06-04 03:58:48');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (14, 5, 4, 11, '2024-06-04', '07:17:29', NULL, '2024-06-04 04:17:29');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (15, 6, 28, 2, '2024-06-04', '17:14:27', NULL, '2024-06-04 14:14:27');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (16, 6, 6, 11, '2024-06-04', '09:21:26', NULL, '2024-06-04 06:21:26');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (17, 7, 1, 5, '2024-06-04', '17:03:23', NULL, '2024-06-04 14:03:23');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (18, 5, 4, 11, '2024-06-05', '06:48:49', '18:04:42', '2024-06-05 15:04:42');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (19, 8, 8, 11, '2024-06-05', '06:48:57', NULL, '2024-06-05 03:48:57');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (20, 4, 34, 2, '2024-06-05', '06:49:04', NULL, '2024-06-05 03:49:04');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (21, 9, 9, 11, '2024-06-05', '15:43:29', '15:43:34', '2024-06-05 12:43:34');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (22, 2, 33, 2, '2024-06-05', '17:13:52', '17:14:30', '2024-06-05 14:14:30');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (23, 5, 31, 2, '2024-06-05', '06:49:25', '17:16:20', '2024-06-05 14:16:20');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (24, 3, 10, 7, '2024-06-05', '06:49:46', NULL, '2024-06-05 03:49:46');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (25, 3, 32, 2, '2024-06-05', '06:49:51', NULL, '2024-06-05 03:49:51');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (26, 4, 2, 9, '2024-06-05', '07:00:54', NULL, '2024-06-05 04:00:54');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (27, 6, 6, 11, '2024-06-05', '07:04:40', NULL, '2024-06-05 04:04:40');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (28, 6, 28, 2, '2024-06-05', '07:44:57', '17:19:00', '2024-06-05 14:19:00');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (29, 7, 1, 5, '2024-06-05', '11:41:58', '17:15:18', '2024-06-05 14:15:18');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (30, 2, 33, 2, '2024-06-06', '06:54:27', NULL, '2024-06-06 03:54:27');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (31, 8, 8, 11, '2024-06-06', '06:54:34', '17:23:41', '2024-06-06 14:23:41');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (32, 9, 9, 11, '2024-06-06', '06:54:42', NULL, '2024-06-06 03:54:42');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (33, 4, 34, 2, '2024-06-06', '06:54:55', '08:24:44', '2024-06-06 05:24:44');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (34, 5, 31, 2, '2024-06-06', '06:55:18', '17:00:43', '2024-06-06 14:00:43');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (35, 3, 32, 2, '2024-06-06', '06:55:35', '17:01:04', '2024-06-06 14:01:04');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (36, 3, 10, 7, '2024-06-06', '06:57:13', '17:01:49', '2024-06-06 14:01:49');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (37, 6, 28, 2, '2024-06-06', '07:00:07', NULL, '2024-06-06 04:00:07');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (38, 4, 2, 9, '2024-06-06', '07:00:11', NULL, '2024-06-06 04:00:11');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (39, 7, 1, 5, '2024-06-06', '08:12:18', '17:00:55', '2024-06-06 14:00:55');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (40, 6, 28, 2, '2024-06-07', '07:30:18', '17:14:28', '2024-06-07 14:14:28');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (41, 7, 1, 5, '2024-06-07', '09:20:50', '17:02:19', '2024-06-07 14:02:19');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (42, 10, 7, 11, '2024-06-07', '11:49:50', NULL, '2024-06-07 08:49:50');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (43, 6, 6, 11, '2024-06-07', '14:04:12', NULL, '2024-06-07 11:04:12');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (44, 8, 8, 11, '2024-06-07', '17:09:50', '17:09:56', '2024-06-07 14:09:56');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (45, 5, 31, 2, '2024-06-08', '08:22:13', NULL, '2024-06-08 05:22:13');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (46, 3, 32, 2, '2024-06-08', '08:22:07', NULL, '2024-06-08 05:22:07');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (47, 3, 10, 7, '2024-06-08', '08:22:21', NULL, '2024-06-08 05:22:21');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (48, 7, 1, 5, '2024-06-08', '08:22:39', NULL, '2024-06-08 05:22:39');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (49, 2, 33, 2, '2024-06-08', '08:25:25', NULL, '2024-06-08 05:25:25');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (50, 4, 34, 2, '2024-06-08', '08:48:35', NULL, '2024-06-08 05:48:35');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (51, 10, 7, 11, '2024-06-08', '08:58:26', NULL, '2024-06-08 05:58:26');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (52, 6, 28, 2, '2024-06-08', '08:58:57', NULL, '2024-06-08 05:58:57');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (53, 4, 2, 9, '2024-06-08', '10:10:14', NULL, '2024-06-08 07:10:14');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (54, 8, 8, 11, '2024-06-08', '12:57:21', '12:57:38', '2024-06-08 09:57:38');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (55, 4, 18, 3, '2024-06-10', '09:38:15', '09:38:27', '2024-06-10 06:38:27');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (56, 5, 1, 3, '2024-06-12', '20:29:16', '20:29:30', '2024-06-12 17:29:30');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (57, 6, 2, 3, '2024-06-12', '20:34:28', '20:35:54', '2024-06-12 17:35:54');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (58, 4, 2, 9, '2024-06-12', '20:38:13', '20:57:37', '2024-06-12 17:57:37');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (59, 5, 31, 2, '2024-06-12', '20:47:54', '20:51:05', '2024-06-12 17:51:05');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (60, 6, 28, 2, '2024-06-12', '20:49:07', '20:51:24', '2024-06-12 17:51:24');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (61, 2, 33, 2, '2024-06-12', '21:04:36', '21:04:01', '2024-06-12 18:04:36');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (62, 3, 32, 2, '2024-06-12', '21:06:24', '21:06:38', '2024-06-12 18:06:38');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (63, 7, 1, 5, '2024-06-12', '21:07:35', '21:09:03', '2024-06-12 18:09:03');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (64, 5, 4, 11, '2024-06-12', '21:14:02', '21:14:13', '2024-06-12 18:14:13');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (65, 3, 10, 7, '2024-06-12', '21:14:52', '21:15:00', '2024-06-12 18:15:00');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (66, 7, 11, 3, '2024-06-12', '21:15:41', '21:15:29', '2024-06-12 18:15:41');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (67, 7, 29, 2, '2024-06-12', '21:16:15', '21:16:26', '2024-06-12 18:16:26');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (68, 8, 30, 2, '2024-06-12', '21:17:15', '21:17:23', '2024-06-12 18:17:23');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (69, 9, 9, 11, '2024-06-12', '21:18:47', '21:20:10', '2024-06-12 18:20:10');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (70, 11, 11, 12, '2024-06-12', '21:19:12', '21:19:21', '2024-06-12 18:19:21');
INSERT INTO `clock_in_out` (`id`, `attendanceID`, `userID`, `usertypeID`, `check_date`, `clock_in`, `clock_out`, `last_modified`) VALUES (71, 8, 54, 3, '2024-06-16', '15:24:54', NULL, '2024-06-16 12:24:54');


#
# TABLE STRUCTURE FOR: complain
#

DROP TABLE IF EXISTS `complain`;

CREATE TABLE `complain` (
  `complainID` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `userID` int(11) DEFAULT NULL,
  `schoolyearID` int(11) DEFAULT NULL,
  `description` text,
  `attachment` text,
  `originalfile` text,
  `create_userID` int(11) NOT NULL DEFAULT '0',
  `create_usertypeID` int(11) NOT NULL DEFAULT '0',
  `create_date` datetime DEFAULT NULL,
  `modify_date` datetime DEFAULT NULL,
  PRIMARY KEY (`complainID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: conversation_message_info
#

DROP TABLE IF EXISTS `conversation_message_info`;

CREATE TABLE `conversation_message_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `status` int(11) DEFAULT '0',
  `draft` int(11) DEFAULT '0',
  `fav_status` int(11) DEFAULT '0',
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: conversation_msg
#

DROP TABLE IF EXISTS `conversation_msg`;

CREATE TABLE `conversation_msg` (
  `msg_id` int(11) NOT NULL AUTO_INCREMENT,
  `conversation_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `msg` text NOT NULL,
  `attach` text,
  `attach_file_name` text,
  `usertypeID` int(11) NOT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `start` int(11) DEFAULT NULL,
  PRIMARY KEY (`msg_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: conversation_user
#

DROP TABLE IF EXISTS `conversation_user`;

CREATE TABLE `conversation_user` (
  `conversation_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `is_sender` int(11) DEFAULT '0',
  `trash` int(11) DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: document
#

DROP TABLE IF EXISTS `document`;

CREATE TABLE `document` (
  `documentID` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(128) CHARACTER SET utf8 NOT NULL,
  `file` varchar(200) CHARACTER SET utf8 NOT NULL,
  `userID` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `create_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`documentID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: eattendance
#

DROP TABLE IF EXISTS `eattendance`;

CREATE TABLE `eattendance` (
  `eattendanceID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `schoolyearID` int(11) NOT NULL,
  `examID` int(11) NOT NULL,
  `classesID` int(11) NOT NULL,
  `sectionID` int(11) NOT NULL,
  `subjectID` int(11) NOT NULL,
  `date` date NOT NULL,
  `studentID` int(11) DEFAULT NULL,
  `s_name` varchar(60) DEFAULT NULL,
  `eattendance` varchar(20) DEFAULT NULL,
  `year` year(4) NOT NULL,
  `eextra` varchar(60) DEFAULT NULL,
  PRIMARY KEY (`eattendanceID`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

INSERT INTO `eattendance` (`eattendanceID`, `schoolyearID`, `examID`, `classesID`, `sectionID`, `subjectID`, `date`, `studentID`, `s_name`, `eattendance`, `year`, `eextra`) VALUES (1, 4, 1, 10, 10, 121, '2024-03-23', 1, 'JULIE SAGA HANS', NULL, '2024', NULL);
INSERT INTO `eattendance` (`eattendanceID`, `schoolyearID`, `examID`, `classesID`, `sectionID`, `subjectID`, `date`, `studentID`, `s_name`, `eattendance`, `year`, `eextra`) VALUES (2, 4, 1, 10, 10, 121, '2024-03-23', 4, 'BLESSING LUYAI', NULL, '2024', NULL);
INSERT INTO `eattendance` (`eattendanceID`, `schoolyearID`, `examID`, `classesID`, `sectionID`, `subjectID`, `date`, `studentID`, `s_name`, `eattendance`, `year`, `eextra`) VALUES (3, 4, 1, 10, 10, 121, '2024-03-23', 9, 'MICHAEL FREDRICK', NULL, '2024', NULL);
INSERT INTO `eattendance` (`eattendanceID`, `schoolyearID`, `examID`, `classesID`, `sectionID`, `subjectID`, `date`, `studentID`, `s_name`, `eattendance`, `year`, `eextra`) VALUES (4, 4, 1, 10, 10, 121, '2024-03-23', 11, 'N’NJEMA ISABEL', NULL, '2024', NULL);
INSERT INTO `eattendance` (`eattendanceID`, `schoolyearID`, `examID`, `classesID`, `sectionID`, `subjectID`, `date`, `studentID`, `s_name`, `eattendance`, `year`, `eextra`) VALUES (5, 4, 1, 10, 10, 121, '2024-03-23', 13, 'ALI WASILWA PAKIA', NULL, '2024', NULL);
INSERT INTO `eattendance` (`eattendanceID`, `schoolyearID`, `examID`, `classesID`, `sectionID`, `subjectID`, `date`, `studentID`, `s_name`, `eattendance`, `year`, `eextra`) VALUES (6, 4, 1, 10, 10, 121, '2024-03-23', 15, 'ISSA HAMAD', NULL, '2024', NULL);
INSERT INTO `eattendance` (`eattendanceID`, `schoolyearID`, `examID`, `classesID`, `sectionID`, `subjectID`, `date`, `studentID`, `s_name`, `eattendance`, `year`, `eextra`) VALUES (7, 4, 1, 10, 10, 121, '2024-03-23', 18, 'ALMASI MALAU', NULL, '2024', NULL);
INSERT INTO `eattendance` (`eattendanceID`, `schoolyearID`, `examID`, `classesID`, `sectionID`, `subjectID`, `date`, `studentID`, `s_name`, `eattendance`, `year`, `eextra`) VALUES (8, 4, 1, 10, 10, 121, '2024-03-23', 19, 'BRIAN KIOKO', NULL, '2024', NULL);
INSERT INTO `eattendance` (`eattendanceID`, `schoolyearID`, `examID`, `classesID`, `sectionID`, `subjectID`, `date`, `studentID`, `s_name`, `eattendance`, `year`, `eextra`) VALUES (9, 4, 1, 10, 10, 121, '2024-03-23', 46, 'LINDA MAUA', NULL, '2024', NULL);


#
# TABLE STRUCTURE FOR: ebooks
#

DROP TABLE IF EXISTS `ebooks`;

CREATE TABLE `ebooks` (
  `ebooksID` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `author` varchar(255) NOT NULL,
  `classesID` int(11) NOT NULL,
  `authority` tinyint(4) NOT NULL DEFAULT '0',
  `cover_photo` varchar(200) NOT NULL,
  `file` varchar(200) NOT NULL,
  PRIMARY KEY (`ebooksID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: emailsetting
#

DROP TABLE IF EXISTS `emailsetting`;

CREATE TABLE `emailsetting` (
  `fieldoption` varchar(100) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`fieldoption`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `emailsetting` (`fieldoption`, `value`) VALUES ('email_engine', 'sendmail');
INSERT INTO `emailsetting` (`fieldoption`, `value`) VALUES ('smtp_password', '');
INSERT INTO `emailsetting` (`fieldoption`, `value`) VALUES ('smtp_port', '');
INSERT INTO `emailsetting` (`fieldoption`, `value`) VALUES ('smtp_security', '');
INSERT INTO `emailsetting` (`fieldoption`, `value`) VALUES ('smtp_server', '');
INSERT INTO `emailsetting` (`fieldoption`, `value`) VALUES ('smtp_username', ' ');


#
# TABLE STRUCTURE FOR: event
#

DROP TABLE IF EXISTS `event`;

CREATE TABLE `event` (
  `eventID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fdate` date NOT NULL,
  `ftime` time NOT NULL,
  `tdate` date NOT NULL,
  `ttime` time NOT NULL,
  `title` varchar(128) NOT NULL,
  `details` text NOT NULL,
  `photo` varchar(200) DEFAULT NULL,
  `create_date` datetime NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  `create_userID` int(11) NOT NULL DEFAULT '0',
  `create_usertypeID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`eventID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: eventcounter
#

DROP TABLE IF EXISTS `eventcounter`;

CREATE TABLE `eventcounter` (
  `eventcounterID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `eventID` int(11) NOT NULL,
  `username` varchar(40) NOT NULL,
  `type` varchar(20) NOT NULL,
  `name` varchar(128) NOT NULL,
  `photo` varchar(200) DEFAULT NULL,
  `status` int(11) NOT NULL,
  `create_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`eventcounterID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: exam
#

DROP TABLE IF EXISTS `exam`;

CREATE TABLE `exam` (
  `examID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `exam` varchar(60) NOT NULL,
  `date` date NOT NULL,
  `note` text,
  PRIMARY KEY (`examID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `exam` (`examID`, `exam`, `date`, `note`) VALUES (1, 'FIRST TERM 2024', '2024-02-29', '');


#
# TABLE STRUCTURE FOR: examschedule
#

DROP TABLE IF EXISTS `examschedule`;

CREATE TABLE `examschedule` (
  `examscheduleID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `examID` int(11) NOT NULL,
  `classesID` int(11) NOT NULL,
  `sectionID` int(11) NOT NULL,
  `subjectID` int(11) NOT NULL,
  `edate` date NOT NULL,
  `examfrom` varchar(10) NOT NULL,
  `examto` varchar(10) NOT NULL,
  `room` tinytext,
  `schoolyearID` int(11) NOT NULL,
  PRIMARY KEY (`examscheduleID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `examschedule` (`examscheduleID`, `examID`, `classesID`, `sectionID`, `subjectID`, `edate`, `examfrom`, `examto`, `room`, `schoolyearID`) VALUES (1, 1, 10, 10, 121, '2024-03-29', '7:45 PM', '7:45 PM', '', 4);
INSERT INTO `examschedule` (`examscheduleID`, `examID`, `classesID`, `sectionID`, `subjectID`, `edate`, `examfrom`, `examto`, `room`, `schoolyearID`) VALUES (2, 1, 10, 10, 122, '2024-03-25', '7:15 PM', '7:15 PM', '', 4);


#
# TABLE STRUCTURE FOR: expense
#

DROP TABLE IF EXISTS `expense`;

CREATE TABLE `expense` (
  `expenseID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `create_date` date NOT NULL,
  `date` date NOT NULL,
  `expenseday` varchar(11) NOT NULL,
  `expensemonth` varchar(11) NOT NULL,
  `expenseyear` year(4) NOT NULL,
  `expense` varchar(128) NOT NULL,
  `amount` double NOT NULL,
  `file` varchar(200) DEFAULT NULL,
  `userID` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `uname` varchar(60) NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  `note` text,
  PRIMARY KEY (`expenseID`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

INSERT INTO `expense` (`expenseID`, `create_date`, `date`, `expenseday`, `expensemonth`, `expenseyear`, `expense`, `amount`, `file`, `userID`, `usertypeID`, `uname`, `schoolyearID`, `note`) VALUES (1, '2024-05-02', '2024-04-29', '29', '04', '2024', 'STAFF UNIFORM', '5800', '', 1, 5, 'JOSEPH WAMBUA', 4, '');
INSERT INTO `expense` (`expenseID`, `create_date`, `date`, `expenseday`, `expensemonth`, `expenseyear`, `expense`, `amount`, `file`, `userID`, `usertypeID`, `uname`, `schoolyearID`, `note`) VALUES (2, '2024-05-02', '2024-04-25', '25', '04', '2024', 'STATIONARY', '23180', '', 1, 5, 'JOSEPH WAMBUA', 4, '');
INSERT INTO `expense` (`expenseID`, `create_date`, `date`, `expenseday`, `expensemonth`, `expenseyear`, `expense`, `amount`, `file`, `userID`, `usertypeID`, `uname`, `schoolyearID`, `note`) VALUES (3, '2024-05-02', '2024-04-30', '30', '04', '2024', 'MEAT', '4300', '', 1, 5, 'JOSEPH WAMBUA', 4, '');
INSERT INTO `expense` (`expenseID`, `create_date`, `date`, `expenseday`, `expensemonth`, `expenseyear`, `expense`, `amount`, `file`, `userID`, `usertypeID`, `uname`, `schoolyearID`, `note`) VALUES (4, '2024-05-02', '2024-04-29', '29', '04', '2024', 'COOKING GAS', '34600', '', 1, 5, 'JOSEPH WAMBUA', 4, '');
INSERT INTO `expense` (`expenseID`, `create_date`, `date`, `expenseday`, `expensemonth`, `expenseyear`, `expense`, `amount`, `file`, `userID`, `usertypeID`, `uname`, `schoolyearID`, `note`) VALUES (5, '2024-05-02', '2024-04-29', '29', '04', '2024', 'FOOD STUFF', '35487', '', 1, 5, 'JOSEPH WAMBUA', 4, '');
INSERT INTO `expense` (`expenseID`, `create_date`, `date`, `expenseday`, `expensemonth`, `expenseyear`, `expense`, `amount`, `file`, `userID`, `usertypeID`, `uname`, `schoolyearID`, `note`) VALUES (6, '2024-05-02', '2024-04-29', '29', '04', '2024', 'FUEL', '1500', '', 1, 5, 'JOSEPH WAMBUA', 4, '');
INSERT INTO `expense` (`expenseID`, `create_date`, `date`, `expenseday`, `expensemonth`, `expenseyear`, `expense`, `amount`, `file`, `userID`, `usertypeID`, `uname`, `schoolyearID`, `note`) VALUES (7, '2024-05-02', '2024-04-29', '29', '04', '2024', 'KITCHEN UTENSILS', '9050', '', 1, 5, 'JOSEPH WAMBUA', 4, '');
INSERT INTO `expense` (`expenseID`, `create_date`, `date`, `expenseday`, `expensemonth`, `expenseyear`, `expense`, `amount`, `file`, `userID`, `usertypeID`, `uname`, `schoolyearID`, `note`) VALUES (8, '2024-05-02', '2024-04-29', '29', '04', '2024', 'GARBAGE DRUMS', '4450', '', 1, 5, 'JOSEPH WAMBUA', 4, '');
INSERT INTO `expense` (`expenseID`, `create_date`, `date`, `expenseday`, `expensemonth`, `expenseyear`, `expense`, `amount`, `file`, `userID`, `usertypeID`, `uname`, `schoolyearID`, `note`) VALUES (9, '2024-05-02', '2024-04-30', '30', '04', '2024', 'WIFI ACCESORIES', '3300', '', 1, 5, 'JOSEPH WAMBUA', 4, '');


#
# TABLE STRUCTURE FOR: feetypes
#

DROP TABLE IF EXISTS `feetypes`;

CREATE TABLE `feetypes` (
  `feetypesID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `feetypes` varchar(60) NOT NULL,
  `note` text,
  PRIMARY KEY (`feetypesID`)
) ENGINE=InnoDB AUTO_INCREMENT=63 DEFAULT CHARSET=utf8;

INSERT INTO `feetypes` (`feetypesID`, `feetypes`, `note`) VALUES (1, 'TUITION FEES', '');
INSERT INTO `feetypes` (`feetypesID`, `feetypes`, `note`) VALUES (2, 'ADMISSION FEES', '');
INSERT INTO `feetypes` (`feetypesID`, `feetypes`, `note`) VALUES (3, 'BOARDING', '');
INSERT INTO `feetypes` (`feetypesID`, `feetypes`, `note`) VALUES (4, 'TRANSPORT', '');
INSERT INTO `feetypes` (`feetypesID`, `feetypes`, `note`) VALUES (5, 'TEXTBOOK FUND', '');
INSERT INTO `feetypes` (`feetypesID`, `feetypes`, `note`) VALUES (6, 'UNIFORMS', '');
INSERT INTO `feetypes` (`feetypesID`, `feetypes`, `note`) VALUES (7, 'LAUNDRY', '');
INSERT INTO `feetypes` (`feetypesID`, `feetypes`, `note`) VALUES (8, 'OTHER CHARGES', '');
INSERT INTO `feetypes` (`feetypesID`, `feetypes`, `note`) VALUES (60, 'PREVIOUS BALANCE', '');
INSERT INTO `feetypes` (`feetypesID`, `feetypes`, `note`) VALUES (61, 'CLUBS', '');
INSERT INTO `feetypes` (`feetypesID`, `feetypes`, `note`) VALUES (62, 'ADVANCE PAYMENT', '');


#
# TABLE STRUCTURE FOR: fmenu
#

DROP TABLE IF EXISTS `fmenu`;

CREATE TABLE `fmenu` (
  `fmenuID` int(11) NOT NULL AUTO_INCREMENT,
  `menu_name` varchar(128) NOT NULL,
  `status` int(11) NOT NULL COMMENT 'Only for active',
  `topbar` int(11) NOT NULL,
  `social` int(11) NOT NULL,
  PRIMARY KEY (`fmenuID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: fmenu_relation
#

DROP TABLE IF EXISTS `fmenu_relation`;

CREATE TABLE `fmenu_relation` (
  `fmenu_relationID` int(11) NOT NULL AUTO_INCREMENT,
  `fmenuID` int(11) DEFAULT NULL,
  `menu_typeID` int(11) DEFAULT NULL COMMENT '1 => Pages, 2 => Post, 3 => Links',
  `menu_parentID` varchar(128) DEFAULT NULL,
  `menu_orderID` int(11) DEFAULT NULL,
  `menu_pagesID` int(11) DEFAULT NULL,
  `menu_label` varchar(254) DEFAULT NULL,
  `menu_link` text NOT NULL,
  `menu_rand` varchar(128) DEFAULT NULL,
  `menu_rand_parentID` varchar(128) DEFAULT NULL,
  `menu_status` int(11) DEFAULT NULL,
  PRIMARY KEY (`fmenu_relationID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: frontend_setting
#

DROP TABLE IF EXISTS `frontend_setting`;

CREATE TABLE `frontend_setting` (
  `fieldoption` varchar(100) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`fieldoption`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `frontend_setting` (`fieldoption`, `value`) VALUES ('break', '30');
INSERT INTO `frontend_setting` (`fieldoption`, `value`) VALUES ('description', '');
INSERT INTO `frontend_setting` (`fieldoption`, `value`) VALUES ('facebook', '');
INSERT INTO `frontend_setting` (`fieldoption`, `value`) VALUES ('google', '');
INSERT INTO `frontend_setting` (`fieldoption`, `value`) VALUES ('linkedin', '');
INSERT INTO `frontend_setting` (`fieldoption`, `value`) VALUES ('login_menu_status', '1');
INSERT INTO `frontend_setting` (`fieldoption`, `value`) VALUES ('lunch', '60');
INSERT INTO `frontend_setting` (`fieldoption`, `value`) VALUES ('online_admission_status', '0');
INSERT INTO `frontend_setting` (`fieldoption`, `value`) VALUES ('teacher_email_status', '0');
INSERT INTO `frontend_setting` (`fieldoption`, `value`) VALUES ('teacher_phone_status', '0');
INSERT INTO `frontend_setting` (`fieldoption`, `value`) VALUES ('twitter', '');
INSERT INTO `frontend_setting` (`fieldoption`, `value`) VALUES ('youtube', '');


#
# TABLE STRUCTURE FOR: frontend_template
#

DROP TABLE IF EXISTS `frontend_template`;

CREATE TABLE `frontend_template` (
  `frontend_templateID` int(11) NOT NULL AUTO_INCREMENT,
  `template_name` varchar(128) NOT NULL,
  PRIMARY KEY (`frontend_templateID`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

INSERT INTO `frontend_template` (`frontend_templateID`, `template_name`) VALUES (1, 'home');
INSERT INTO `frontend_template` (`frontend_templateID`, `template_name`) VALUES (2, 'about');
INSERT INTO `frontend_template` (`frontend_templateID`, `template_name`) VALUES (3, 'event');
INSERT INTO `frontend_template` (`frontend_templateID`, `template_name`) VALUES (4, 'teacher');
INSERT INTO `frontend_template` (`frontend_templateID`, `template_name`) VALUES (5, 'gallery');
INSERT INTO `frontend_template` (`frontend_templateID`, `template_name`) VALUES (6, 'notice');
INSERT INTO `frontend_template` (`frontend_templateID`, `template_name`) VALUES (7, 'blog');
INSERT INTO `frontend_template` (`frontend_templateID`, `template_name`) VALUES (8, 'contact');
INSERT INTO `frontend_template` (`frontend_templateID`, `template_name`) VALUES (9, 'admission');


#
# TABLE STRUCTURE FOR: globalpayment
#

DROP TABLE IF EXISTS `globalpayment`;

CREATE TABLE `globalpayment` (
  `globalpaymentID` int(11) NOT NULL AUTO_INCREMENT,
  `classesID` int(11) DEFAULT NULL,
  `sectionID` int(11) NOT NULL,
  `studentID` int(11) NOT NULL,
  `clearancetype` varchar(40) NOT NULL,
  `invoicename` varchar(128) NOT NULL,
  `invoicedescription` varchar(128) NOT NULL,
  `paymentyear` varchar(5) NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  `schooltermID` int(11) DEFAULT NULL,
  PRIMARY KEY (`globalpaymentID`)
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=utf8;

INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (1, 9, 23, 2, 'partial', '002-SALIM. N. MWAKIKOI', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (2, 9, 23, 10, 'partial', '010-EVANS MUTUA', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (3, 9, 23, 24, 'paid', '024-TYRESE KITHUNGA', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (4, 9, 21, 47, 'partial', '0047-LATIFFA BRIGIT MATASA', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (5, 9, 21, 3, 'paid', '003-EMMANUEL MWANGI', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (6, 10, 10, 9, 'paid', '009-MICHAEL FREDRICK', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (7, 10, 10, 9, 'paid', '009-MICHAEL FREDRICK', '', '2024', 4, 3);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (8, 9, 21, 3, 'paid', '003-EMMANUEL MWANGI', '', '2024', 4, 3);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (9, 9, 23, 2, 'partial', '002-SALIM. N. MWAKIKOI', '', '2024', 4, 1);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (10, 9, 21, 30, 'partial', '030-VANESSA WANGU', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (11, 9, 23, 6, 'partial', '006-ESTHER MUENI', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (12, 9, 23, 39, 'partial', '039-SASHA PEARL', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (13, 9, 21, 7, 'partial', '007-JUMA SWALEH', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (14, 9, 23, 2, 'partial', '002-SALIM. N. MWAKIKOI', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (15, 9, 21, 33, 'paid', '033-LIONELL KADIEDA', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (16, 9, 21, 12, 'partial', '012-YUSUF MWINYI', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (17, 9, 21, 8, 'paid', '008-MARYLNE NJOKI', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (18, 9, 21, 12, 'partial', '012-YUSUF MWINYI', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (19, 9, 21, 14, 'partial', '014-RICHARD MSOMI', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (20, 9, 21, 17, 'partial', '017-RANDANI KASSIM', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (21, 9, 21, 21, 'partial', '021-DELPHINE KHALAI', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (22, 9, 21, 22, 'partial', '022-ISAACK MULEI', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (23, 9, 21, 23, 'paid', '023-YOHANN’S MUGO', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (24, 9, 21, 26, 'paid', '026-WENDY NDUKU', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (25, 9, 21, 27, 'paid', '027-CHELSEA JULIA', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (26, 9, 21, 30, 'paid', '030-VANESSA WANGU', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (27, 9, 21, 34, 'partial', '034-SANDRA NASIKE', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (28, 9, 21, 36, 'partial', '036-FORTUNE KAITHYA', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (29, 9, 21, 37, 'partial', '037-KHADIJA JUMA', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (30, 9, 21, 47, 'partial', '047-LATIFFA BRIGIT MATASA', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (31, 9, 23, 20, 'partial', '020-ZAINAB SALIM', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (32, 9, 23, 25, 'partial', '025-YVONNE KAMENE', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (33, 9, 23, 29, 'partial', '029-ASHLEY NELIMA', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (34, 9, 23, 31, 'partial', '031-OPRAH WANGARE', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (35, 9, 23, 32, 'partial', '032-ROBIN  BAYA EDWIN MISTANZE', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (36, 9, 23, 35, 'partial', '035-LOUIS KITSAO', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (37, 9, 23, 38, 'partial', '038-ADELIGHT FURAHA', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (38, 9, 23, 40, 'partial', '040-SEMIGIL KOOME', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (39, 9, 23, 41, 'partial', '041-SULEIMANABDALLAH', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (40, 9, 23, 43, 'partial', '043-KHERI MWANGAZA', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (41, 9, 23, 45, 'partial', '045-LISSY IVY', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (42, 10, 10, 13, 'partial', '013-ALI WASILWA PAKIA', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (43, 10, 10, 15, 'partial', '015-ISSA HAMAD', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (44, 10, 10, 19, 'partial', '019-BRIAN KIOKO', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (45, 10, 10, 18, 'partial', '018-ALMASI MALAU', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (46, 10, 10, 1, 'paid', '001-JULIE SAGA HANS', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (47, 10, 10, 11, 'partial', '011-N’NJEMA ISABEL', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (48, 9, 23, 42, 'partial', '042-BENJAMIN\nMUTHOMI', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (49, 9, 23, 6, 'paid', '006-ESTHER MUENI', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (51, 9, 21, 7, 'paid', '007-JUMA SWALEH', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (52, 9, 21, 22, 'partial', '022-ISAACK MULEI', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (53, 9, 21, 28, 'partial', '028-SHAUN MATHEKA', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (54, 10, 10, 4, 'partial', '004-BLESSING LUYAI', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (55, 10, 10, 46, 'partial', '046-LINDA MAUA', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (56, 9, 23, 35, 'paid', '035-LOUIS KITSAO', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (57, 10, 10, 13, 'partial', '013-ALI WASILWA PAKIA', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (58, 9, 23, 5, 'partial', '005-LIAM KIRUHI KAMWERU', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (59, 9, 21, 48, 'partial', '048-RAINER KIMILU', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (60, 9, 23, 29, 'partial', '029-ASHLEY NELIMA', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (61, 9, 21, 16, 'paid', '016-ALI SAID', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (62, 9, 23, 20, 'paid', '020-ZAINAB SALIM', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (63, 10, 10, 15, 'paid', '015-ISSA HAMAD', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (64, 10, 10, 19, 'paid', '019-BRIAN KIOKO', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (65, 9, 23, 42, 'partial', '042-BENJAMIN\nMUTHOMI', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (66, 9, 23, 43, 'partial', '043-KHERI MWANGAZA', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (67, 9, 23, 41, 'partial', '041-SULEIMANABDALLAH', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (69, 9, 23, 5, 'paid', '005-LIAM KIRUHI KAMWERU', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (70, 10, 10, 4, 'paid', '004-BLESSING LUYAI', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (71, 9, 9, 52, 'partial', '050-MATHEW KIMANI JUNIOR', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (72, 9, 21, 53, 'paid', '051-Scholastica Isama', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (73, 9, 23, 2, 'paid', '002-SALIM. N. MWAKIKOI', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (74, 10, 10, 11, 'paid', '011-N’NJEMA ISABEL', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (75, 9, 21, 14, 'paid', '014-RICHARD MSOMI', '', '2024', 4, NULL);
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`, `schooltermID`) VALUES (76, 9, 9, 54, 'partial', '052-JONES KIPCHIRCHIR', '', '2024', 4, NULL);


#
# TABLE STRUCTURE FOR: grade
#

DROP TABLE IF EXISTS `grade`;

CREATE TABLE `grade` (
  `gradeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `grade` varchar(60) NOT NULL,
  `point` varchar(11) NOT NULL,
  `gradefrom` int(11) NOT NULL,
  `gradeupto` int(11) NOT NULL,
  `note` text,
  PRIMARY KEY (`gradeID`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `grade` (`gradeID`, `grade`, `point`, `gradefrom`, `gradeupto`, `note`) VALUES (1, 'EE', '4', 80, 100, 'EXCEEDING EXPECTATION');
INSERT INTO `grade` (`gradeID`, `grade`, `point`, `gradefrom`, `gradeupto`, `note`) VALUES (2, 'ME', '3', 60, 79, 'MEETING EXPECTATION');
INSERT INTO `grade` (`gradeID`, `grade`, `point`, `gradefrom`, `gradeupto`, `note`) VALUES (3, 'AE', '2', 40, 59, 'APPROACHING EXPECTATION');
INSERT INTO `grade` (`gradeID`, `grade`, `point`, `gradefrom`, `gradeupto`, `note`) VALUES (4, 'BE', '1', 0, 39, 'BELOW EXPECTATION');


#
# TABLE STRUCTURE FOR: hmember
#

DROP TABLE IF EXISTS `hmember`;

CREATE TABLE `hmember` (
  `hmemberID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hostelID` int(11) NOT NULL,
  `categoryID` int(11) NOT NULL,
  `studentID` int(11) NOT NULL,
  `hbalance` varchar(20) DEFAULT NULL,
  `hjoindate` date NOT NULL,
  PRIMARY KEY (`hmemberID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: holiday
#

DROP TABLE IF EXISTS `holiday`;

CREATE TABLE `holiday` (
  `holidayID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `schoolyearID` int(11) NOT NULL,
  `fdate` date NOT NULL,
  `tdate` date NOT NULL,
  `title` varchar(128) NOT NULL,
  `details` text NOT NULL,
  `photo` varchar(200) DEFAULT NULL,
  `create_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL DEFAULT '0',
  `create_usertypeID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`holidayID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: hostel
#

DROP TABLE IF EXISTS `hostel`;

CREATE TABLE `hostel` (
  `hostelID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `htype` varchar(11) NOT NULL,
  `address` varchar(200) NOT NULL,
  `note` text,
  PRIMARY KEY (`hostelID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: hourly_template
#

DROP TABLE IF EXISTS `hourly_template`;

CREATE TABLE `hourly_template` (
  `hourly_templateID` int(11) NOT NULL AUTO_INCREMENT,
  `hourly_grades` varchar(128) NOT NULL,
  `hourly_rate` int(11) NOT NULL,
  PRIMARY KEY (`hourly_templateID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: income
#

DROP TABLE IF EXISTS `income`;

CREATE TABLE `income` (
  `incomeID` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `date` date NOT NULL,
  `incomeday` varchar(11) NOT NULL,
  `incomemonth` varchar(11) NOT NULL,
  `incomeyear` year(4) NOT NULL,
  `amount` double NOT NULL,
  `file` varchar(200) NOT NULL,
  `note` text NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  `create_date` date NOT NULL,
  `userID` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`incomeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: ini_config
#

DROP TABLE IF EXISTS `ini_config`;

CREATE TABLE `ini_config` (
  `configID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL,
  `config_key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`configID`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8;

INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (1, 'paypal', 'paypal_api_username', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (2, 'paypal', 'paypal_api_password', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (3, 'paypal', 'paypal_api_signature', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (4, 'paypal', 'paypal_email', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (5, 'paypal', 'paypal_demo', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (6, 'stripe', 'stripe_secret', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (7, 'stripe', 'stripe_key', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (8, 'stripe', 'stripe_demo', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (9, 'payumoney', 'payumoney_key', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (10, 'payumoney', 'payumoney_salt', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (11, 'payumoney', 'payumoney_demo', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (12, 'paypal', 'paypal_status', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (13, 'stripe', 'stripe_status', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (14, 'payumoney', 'payumoney_status', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (15, 'voguepay', 'voguepay_merchant_id', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (16, 'voguepay', 'voguepay_merchant_ref', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (17, 'voguepay', 'voguepay_developer_code', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (18, 'voguepay', 'voguepay_demo', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (19, 'voguepay', 'voguepay_status', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (20, 'mpesa', 'mpesa_key', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (21, 'mpesa', 'mpesa_secret', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (22, 'mpesa', 'mpesa_password', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (23, 'mpesa', 'mpesa_status', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (24, 'mpesa', 'mpesa_demo', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (25, 'mpesa', 'mpesa_shortcode', '');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (26, 'settings', 'footer_message', '<b>Powered By Skooly<b>');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (27, 'settings', 'top_message', '<strong>PAYBILL:</strong> 247247 <br>\r\n<strong>ACC:</strong> 833822# Class ADM NO.<br>\r\n<strong>EQUITY:</strong> 0440284742769');
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES (28, 'stripe', 'stripe_key', '');


#
# TABLE STRUCTURE FOR: instruction
#

DROP TABLE IF EXISTS `instruction`;

CREATE TABLE `instruction` (
  `instructionID` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(512) NOT NULL,
  `content` text NOT NULL,
  PRIMARY KEY (`instructionID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: invoice
#

DROP TABLE IF EXISTS `invoice`;

CREATE TABLE `invoice` (
  `invoiceID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `schoolyearID` int(11) NOT NULL,
  `schooltermID` int(11) DEFAULT NULL,
  `classesID` int(11) NOT NULL,
  `studentID` int(11) NOT NULL,
  `feetypeID` int(11) DEFAULT NULL,
  `feetype` varchar(128) NOT NULL,
  `amount` double NOT NULL,
  `discount` double NOT NULL DEFAULT '0',
  `userID` int(11) DEFAULT NULL,
  `usertypeID` int(11) DEFAULT NULL,
  `uname` varchar(60) DEFAULT NULL,
  `date` date NOT NULL,
  `create_date` date NOT NULL,
  `day` varchar(20) DEFAULT NULL,
  `month` varchar(20) DEFAULT NULL,
  `year` year(4) NOT NULL,
  `paidstatus` int(11) DEFAULT NULL,
  `deleted_at` int(11) NOT NULL DEFAULT '1',
  `maininvoiceID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`invoiceID`)
) ENGINE=InnoDB AUTO_INCREMENT=273 DEFAULT CHARSET=utf8;

INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (1, 4, 2, 9, 3, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 1);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (2, 4, 2, 9, 3, 4, 'TRANSPORT', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 1);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (3, 4, 2, 9, 3, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 1);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (4, 4, 2, 9, 5, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 2);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (5, 4, 2, 9, 5, 4, 'TRANSPORT', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 2);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (6, 4, 2, 9, 5, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 2);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (7, 4, 2, 9, 6, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 3);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (8, 4, 2, 9, 6, 4, 'TRANSPORT', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 3);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (9, 4, 2, 9, 6, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 3);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (10, 4, 2, 9, 7, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 4);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (11, 4, 2, 9, 7, 4, 'TRANSPORT', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 4);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (12, 4, 2, 9, 7, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 4);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (13, 4, 2, 9, 26, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 5);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (14, 4, 2, 9, 26, 4, 'TRANSPORT', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 5);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (15, 4, 2, 9, 26, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 5);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (16, 4, 2, 9, 22, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 1, 1, 6);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (17, 4, 2, 9, 22, 4, 'TRANSPORT', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 6);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (18, 4, 2, 9, 22, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 6);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (19, 4, 2, 9, 27, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 7);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (20, 4, 2, 9, 27, 4, 'TRANSPORT', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 7);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (21, 4, 2, 9, 27, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 7);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (22, 4, 2, 9, 31, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 1, 1, 8);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (23, 4, 2, 9, 31, 4, 'TRANSPORT', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 8);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (24, 4, 2, 9, 31, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 8);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (28, 4, 2, 9, 35, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 10);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (29, 4, 2, 9, 35, 4, 'TRANSPORT', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 10);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (30, 4, 2, 9, 35, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 10);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (31, 4, 2, 9, 38, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 1, 1, 11);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (32, 4, 2, 9, 38, 4, 'TRANSPORT', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 11);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (33, 4, 2, 9, 38, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 11);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (37, 4, 2, 9, 48, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 1, 1, 13);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (38, 4, 2, 9, 48, 4, 'TRANSPORT', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 13);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (39, 4, 2, 9, 48, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 13);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (40, 4, 2, 10, 13, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 1, 1, 14);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (41, 4, 2, 10, 13, 4, 'TRANSPORT', '6000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 14);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (42, 4, 2, 10, 13, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 14);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (51, 4, 2, 10, 15, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 17);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (52, 4, 2, 10, 15, 4, 'TRANSPORT', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 17);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (53, 4, 2, 10, 15, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 17);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (54, 4, 2, 10, 19, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 18);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (55, 4, 2, 10, 19, 4, 'TRANSPORT', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 18);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (56, 4, 2, 10, 19, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 18);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (57, 4, 2, 10, 13, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 0, 19);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (58, 4, 2, 10, 13, 4, 'TRANSPORT', '6000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 0, 19);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (59, 4, 2, 10, 13, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 0, 19);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (60, 4, 2, 9, 10, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 1, 1, 20);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (61, 4, 2, 9, 10, 4, 'TRANSPORT', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 1, 1, 20);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (62, 4, 2, 9, 10, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 20);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (63, 4, 2, 9, 16, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 21);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (64, 4, 2, 9, 16, 4, 'TRANSPORT', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 21);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (65, 4, 2, 9, 16, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 21);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (72, 4, 2, 9, 8, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 24);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (73, 4, 2, 9, 8, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 24);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (74, 4, 2, 9, 8, 7, 'LAUNDRY', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 24);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (75, 4, 2, 9, 8, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 24);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (76, 4, 2, 9, 14, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 25);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (77, 4, 2, 9, 14, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 25);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (78, 4, 2, 9, 14, 7, 'LAUNDRY', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 25);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (79, 4, 2, 9, 14, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 25);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (80, 4, 2, 9, 23, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 26);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (81, 4, 2, 9, 23, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 26);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (82, 4, 2, 9, 23, 7, 'LAUNDRY', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 26);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (83, 4, 2, 9, 23, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 26);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (84, 4, 2, 9, 24, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 27);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (85, 4, 2, 9, 24, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 27);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (86, 4, 2, 9, 24, 7, 'LAUNDRY', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 27);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (87, 4, 2, 9, 24, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 27);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (88, 4, 2, 9, 36, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 1, 1, 28);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (89, 4, 2, 9, 36, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 28);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (90, 4, 2, 9, 36, 7, 'LAUNDRY', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 28);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (91, 4, 2, 9, 36, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 28);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (92, 4, 2, 9, 2, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 29);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (93, 4, 2, 9, 2, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 29);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (94, 4, 2, 9, 2, 7, 'LAUNDRY', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 29);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (95, 4, 2, 9, 2, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 29);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (100, 4, 2, 9, 40, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 1, 1, 31);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (101, 4, 2, 9, 40, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 1, 1, 31);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (102, 4, 2, 9, 40, 7, 'LAUNDRY', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 31);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (103, 4, 2, 9, 40, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 31);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (104, 4, 2, 10, 9, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 32);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (105, 4, 2, 10, 9, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 32);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (106, 4, 2, 10, 9, 7, 'LAUNDRY', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 32);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (107, 4, 2, 10, 9, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 32);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (112, 4, 2, 9, 44, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 34);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (113, 4, 2, 9, 44, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 34);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (114, 4, 2, 9, 44, 7, 'LAUNDRY', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 34);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (115, 4, 2, 9, 44, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1, 34);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (116, 4, 2, 9, 45, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 1, 1, 35);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (117, 4, 2, 9, 45, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 1, 1, 35);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (118, 4, 2, 9, 45, 7, 'LAUNDRY', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 35);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (119, 4, 2, 9, 45, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1, 35);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (122, 4, 2, 9, 20, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 37);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (123, 4, 2, 9, 20, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 37);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (124, 4, 2, 9, 34, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 1, 1, 38);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (125, 4, 2, 9, 34, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 38);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (126, 4, 2, 10, 4, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 39);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (127, 4, 2, 10, 4, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 39);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (128, 4, 2, 10, 4, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 39);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (135, 4, 2, 9, 47, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 1, 1, 42);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (136, 4, 2, 9, 47, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 42);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (137, 4, 2, 9, 47, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 42);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (138, 4, 2, 9, 30, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 43);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (139, 4, 2, 9, 30, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 43);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (140, 4, 2, 9, 30, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 43);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (144, 4, 2, 9, 21, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 1, 1, 45);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (145, 4, 2, 9, 21, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 45);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (146, 4, 2, 9, 21, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 45);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (150, 4, 2, 9, 29, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 1, 1, 47);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (151, 4, 2, 9, 29, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 47);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (152, 4, 2, 9, 29, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 47);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (159, 4, 2, 9, 25, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 1, 1, 46);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (160, 4, 2, 9, 25, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 1, 1, 46);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (161, 4, 2, 9, 25, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 46);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (162, 4, 2, 9, 25, 60, 'PREVIOUS BALANCE', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 46);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (163, 4, 2, 9, 32, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 1, 1, 9);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (164, 4, 2, 9, 32, 4, 'TRANSPORT', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 9);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (165, 4, 2, 9, 32, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 9);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (166, 4, 2, 9, 32, 60, 'PREVIOUS BALANCE', '6500', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 9);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (167, 4, 2, 9, 41, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 1, 1, 12);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (168, 4, 2, 9, 41, 4, 'TRANSPORT', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 1, 1, 12);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (169, 4, 2, 9, 41, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 1, 1, 12);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (170, 4, 2, 9, 41, 60, 'PREVIOUS BALANCE', '20900', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 1, 1, 12);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (175, 4, 2, 9, 43, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 1, 1, 49);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (176, 4, 2, 9, 43, 4, 'TRANSPORT', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 1, 1, 49);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (177, 4, 2, 9, 43, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 49);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (178, 4, 2, 9, 43, 60, 'PREVIOUS BALANCE', '22000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 49);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (179, 4, 2, 9, 12, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 1, 1, 48);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (180, 4, 2, 9, 12, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 48);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (181, 4, 2, 9, 12, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 48);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (182, 4, 2, 9, 12, 60, 'PREVIOUS BALANCE', '15500', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 48);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (183, 4, 2, 9, 17, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 1, 1, 36);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (184, 4, 2, 9, 17, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 36);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (185, 4, 2, 9, 17, 60, 'PREVIOUS BALANCE', '1500', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 36);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (190, 4, 2, 9, 37, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 1, 1, 44);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (191, 4, 2, 9, 37, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 1, 1, 44);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (192, 4, 2, 9, 37, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 44);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (193, 4, 2, 9, 37, 60, 'PREVIOUS BALANCE', '21000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 44);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (194, 4, 3, 10, 9, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 50);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (195, 4, 3, 10, 9, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 50);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (196, 4, 3, 10, 9, 7, 'LAUNDRY', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 50);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (197, 4, 3, 10, 9, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 50);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (198, 4, 3, 9, 3, 1, 'TUITION FEES', '32000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 51);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (199, 4, 3, 9, 3, 4, 'TRANSPORT', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 51);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (200, 4, 3, 9, 3, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 51);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (201, 4, 2, 10, 46, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 1, 1, 16);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (202, 4, 2, 10, 46, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 16);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (203, 4, 2, 10, 46, 7, 'LAUNDRY', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 16);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (204, 4, 2, 10, 46, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1, 16);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (214, 4, 2, 9, 39, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-05-02', '02', '05', '2024', 1, 1, 30);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (215, 4, 2, 9, 39, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-05-02', '02', '05', '2024', 1, 1, 30);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (216, 4, 2, 9, 39, 7, 'LAUNDRY', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-05-02', '02', '05', '2024', 2, 1, 30);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (217, 4, 2, 9, 39, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-05-02', '02', '05', '2024', 2, 1, 30);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (218, 4, 2, 9, 33, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-05-02', '02', '05', '2024', 2, 1, 33);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (219, 4, 2, 9, 33, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-05-02', '02', '05', '2024', 2, 1, 33);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (220, 4, 2, 9, 33, 7, 'LAUNDRY', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-05-02', '02', '05', '2024', 2, 1, 33);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (221, 4, 2, 9, 33, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-05-02', '02', '05', '2024', 2, 1, 33);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (222, 4, 2, 9, 33, 61, 'CLUBS', '3000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-05-02', '02', '05', '2024', 2, 1, 33);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (228, 4, 2, 10, 18, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-05-27', '27', '05', '2024', 1, 1, 41);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (229, 4, 2, 10, 18, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-05-27', '27', '05', '2024', 2, 1, 41);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (230, 4, 2, 10, 18, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-05-27', '27', '05', '2024', 2, 1, 41);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (231, 4, 2, 10, 1, 1, 'TUITION FEES', '35000', '100', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-05-27', '27', '05', '2024', 2, 1, 15);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (232, 4, 2, 10, 1, 3, 'BOARDING', '25000', '100', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-05-27', '27', '05', '2024', 2, 1, 15);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (233, 4, 2, 10, 1, 7, 'LAUNDRY', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-05-27', '27', '05', '2024', 2, 1, 15);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (234, 4, 2, 10, 1, 8, 'OTHER CHARGES', '2000', '100', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-05-27', '27', '05', '2024', 2, 1, 15);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (235, 4, 2, 10, 11, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-05-27', '27', '05', '2024', 2, 1, 40);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (236, 4, 2, 10, 11, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-05-27', '27', '05', '2024', 2, 1, 40);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (237, 4, 2, 10, 11, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-05-27', '27', '05', '2024', 2, 1, 40);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (238, 4, 2, 10, 11, 6, 'UNIFORMS', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-05-27', '27', '05', '2024', 2, 1, 40);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (239, 4, 2, 9, 42, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-05-27', '27', '05', '2024', 1, 1, 23);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (240, 4, 2, 9, 42, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-05-27', '27', '05', '2024', 2, 1, 23);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (241, 4, 2, 9, 42, 60, 'PREVIOUS BALANCE', '21500', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-05-27', '27', '05', '2024', 2, 1, 23);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (242, 4, 2, 9, 28, 1, 'TUITION FEES', '35000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-06-03', '03', '06', '2024', 1, 1, 22);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (243, 4, 2, 9, 28, 8, 'OTHER CHARGES', '2000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-06-03', '03', '06', '2024', 2, 1, 22);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (244, 4, 2, 9, 28, 60, 'PREVIOUS BALANCE', '7500', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-06-03', '03', '06', '2024', 2, 1, 22);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (245, 4, 2, 9, 28, 3, 'BOARDING', '25000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-06-03', '03', '06', '2024', 2, 1, 22);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (246, 4, 2, 9, 28, 7, 'LAUNDRY', '5000', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-06-03', '03', '06', '2024', 2, 1, 22);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (247, 4, 2, 9, 28, 6, 'UNIFORMS', '8500', '0', 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-06-03', '03', '06', '2024', 2, 1, 22);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (264, 4, 1, 10, 52, 1, 'TUITION FEES', '20000', '0', 1, 1, 'Skooly', '2024-06-14', '2024-06-14', '14', '06', '2024', 1, 1, 56);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (265, 4, 1, 10, 52, 2, 'ADMISSION FEES', '1000', '0', 1, 1, 'Skooly', '2024-06-14', '2024-06-14', '14', '06', '2024', 2, 1, 56);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (266, 4, 1, 10, 52, 6, 'UNIFORMS', '3000', '0', 1, 1, 'Skooly', '2024-06-14', '2024-06-14', '14', '06', '2024', 1, 1, 56);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (267, 4, 1, 10, 52, 5, 'TEXTBOOK FUND', '1500', '0', 1, 1, 'Skooly', '2024-06-14', '2024-06-14', '14', '06', '2024', 1, 1, 56);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (268, 4, 1, 9, 53, 1, 'TUITION FEES', '20000', '0', 1, 1, 'Skooly', '2024-06-14', '2024-06-14', '14', '06', '2024', 2, 1, 57);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (269, 4, 1, 9, 53, 2, 'ADMISSION FEES', '1000', '0', 1, 1, 'Skooly', '2024-06-14', '2024-06-14', '14', '06', '2024', 2, 1, 57);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (270, 4, 1, 9, 53, 5, 'TEXTBOOK FUND', '1500', '0', 1, 1, 'Skooly', '2024-06-14', '2024-06-14', '14', '06', '2024', 2, 1, 57);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (271, 4, 1, 9, 53, 6, 'UNIFORMS', '3000', '0', 1, 1, 'Skooly', '2024-06-14', '2024-06-14', '14', '06', '2024', 2, 1, 57);
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `schooltermID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES (272, 4, 2, 9, 54, 2, 'ADMISSION FEES', '1000', '0', 1, 1, 'Skooly', '2024-06-16', '2024-06-16', '16', '06', '2024', 1, 1, 58);


#
# TABLE STRUCTURE FOR: issue
#

DROP TABLE IF EXISTS `issue`;

CREATE TABLE `issue` (
  `issueID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `lID` varchar(128) NOT NULL,
  `bookID` int(11) NOT NULL,
  `serial_no` varchar(40) NOT NULL,
  `issue_date` date NOT NULL,
  `due_date` date NOT NULL,
  `return_date` date DEFAULT NULL,
  `note` text,
  PRIMARY KEY (`issueID`)
) ENGINE=InnoDB AUTO_INCREMENT=424 DEFAULT CHARSET=utf8;

INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (1, '2', 1, 'av/01/20/2024', '2024-04-17', '2024-05-10', NULL, 'in good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (2, '001', 26, 'AS/IS8/07/20/2024', '2024-04-29', '2024-07-31', NULL, 'in good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (3, '015', 26, 'AV/IS8/07/20/2024', '2024-04-29', '2024-08-05', NULL, 'in good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (4, '004', 26, 'AS/IS8/06/20/2024', '2024-04-29', '2024-08-05', NULL, 'in good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (5, '009', 26, 'AS/IS8/15/20/2024', '2024-04-29', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (6, '011', 26, 'AS/IS8/20/20/2024', '2024-04-29', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (7, '013', 26, 'AS/IS8/14/20/2024', '2024-04-29', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (8, '019', 26, 'AS/IS8/13/20/2024', '2024-04-29', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (9, '018', 26, 'AS/IS8/01/20/2024', '2024-04-29', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (10, '019', 11, 'AS/M8/05/20/2024', '2024-04-29', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (11, '001', 11, 'AS/M8/06/20/2024', '2024-04-29', '2024-07-31', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (12, '011', 11, 'AS/M8/07/20/2024', '2024-04-29', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (13, '004', 11, 'AS/M8/08/20/2024', '2024-04-29', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (14, '009', 11, 'AS/M8/01/20/2024', '2024-04-29', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (15, '015', 11, 'AS/M8/02/20/2024', '2024-04-29', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (16, '013', 11, 'AS/M8/03/20/2024', '2024-04-29', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (17, '018', 11, 'AS/M8/16/20/2024', '2024-04-29', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (18, '046', 11, 'A/M8/09/20/2024', '2024-04-29', '2024-07-31', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (19, '013', 9, 'AS/BS8/09/20/2024', '2024-04-29', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (20, '015', 9, 'AS/BS8/08/20/2024', '2024-04-29', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (21, '009', 9, 'AS/BS8/07/20/2024', '2024-04-29', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (22, '011', 9, 'AS/BS8/05/20/2024', '2024-04-29', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (23, '001', 9, 'AS/BS8/04/20/2024', '2024-04-29', '2024-07-31', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (24, '019', 9, 'AS/BS8/03/20/2024', '2024-04-29', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (25, '026', 18, 'AS/COMP7/2/25/2024', '2024-04-29', '2024-05-06', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (26, '033', 18, 'AS/COMP7/10/25/2024', '2024-04-29', '2024-05-06', '2024-05-18', 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (27, '014', 18, 'AS/COMP7/20/25/2024', '2024-04-29', '2024-05-06', '2024-05-18', 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (28, '027', 18, 'AS/COMP7/09/25/2024', '2024-04-29', '2024-05-06', '2024-05-17', 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (29, '016', 18, 'AS/COMP7/08/25/2024', '2024-04-29', '2024-05-06', '2024-05-20', 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (30, '003', 18, 'AS/COMP7/02/25/2024', '2024-04-29', '2024-05-06', '2024-05-17', 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (31, '007', 18, 'AS/COMP7/21/25/2024', '2024-04-29', '2024-05-06', '2024-05-16', 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (32, '030', 15, 'AS/COMP7/03/25/2024', '2024-04-29', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (33, '012', 18, 'AS/COMP7/04/25/2024', '2024-04-29', '2024-05-06', '2024-05-14', 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (34, '037', 18, 'AS/COMP705/25/2024', '2024-04-29', '2024-05-06', '2024-05-17', 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (35, '021', 15, 'AS/COMP7/19/25/2024', '2024-04-29', '2024-07-31', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (36, '008', 18, 'AS/COMP7/22/25/2024', '2024-04-29', '2024-05-06', '2024-05-16', 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (37, '011', 16, 'AS/PE8/04/10/2024', '2024-04-29', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (38, '004', 16, 'AS/PE8/07/10/2024', '2024-04-29', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (39, '015', 16, 'AS/PE8/10/10/2024', '2024-04-29', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (40, '001', 16, 'AS/PE8/01/10/2024', '2024-04-29', '2024-07-31', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (41, '013', 16, 'AS/PE8/09/10/2024', '2024-04-29', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (42, '019', 16, 'AS/PE8/02/10/2024', '2024-04-29', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (43, '018', 16, 'AS/PE8/06/10/2024', '2024-04-29', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (44, '046', 16, 'AS/PE8/08/10/2024', '2024-04-29', '2024-07-31', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (45, '042', 8, 'AS/PT7/10/25/2024', '2024-04-29', '2024-07-31', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (46, '031', 10, 'AS/PTS7/12/25/2024', '2024-04-29', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (47, '024', 8, 'AS/PTS7/14/25/2024', '2024-04-29', '2024-08-05', '2024-05-17', 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (48, '044', 10, 'AS/PTS7/13/25/2024', '2024-04-29', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (49, '047', 10, 'AS/PTS7/23/25/2024', '2024-04-29', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (50, '028', 10, 'AS/PTS7/24/25/2024', '2024-04-29', '2025-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (51, '037', 10, 'AS/PTS7/02/25/2024', '2024-04-29', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (52, '006', 10, 'AS/PTS7/08/25/2024', '2024-04-29', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (53, '034', 8, 'AS/PTS7/25/25/2024', '2024-04-29', '2024-05-06', '2024-05-17', 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (54, '029', 8, 'AS/PTS7/03/25/2024', '2024-04-30', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (55, '037', 8, 'AS/PTS7/11/25/2024', '2024-04-30', '2024-08-05', '2024-05-17', 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (56, '025', 10, 'AS/PTS7/17/25/2024', '2024-04-30', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (57, '008', 8, 'AS/PTS7/04/25/2024', '2024-04-30', '2024-08-05', '2024-05-17', 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (58, '014', 10, 'AS/PTS22/25/2024', '2024-04-30', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (59, '005', 10, 'AS/PTS7/20/25/2024', '2024-04-30', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (60, '021', 8, 'AS/PTS7/06/25/2024', '2024-04-30', '2024-07-31', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (61, '003', 10, 'AS/PTS7/05/25/2024', '2024-04-30', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (62, '016', 10, 'AS/PTS7/07/25/2024', '2024-04-30', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (63, '002', 10, 'AS/PTS7/18/25/2024', '2024-04-30', '2024-08-16', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (64, '010', 8, 'AS/PTS/19/25/2024', '2024-04-30', '2024-08-05', '2024-05-16', 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (65, '017', 10, 'AS/PTS7/21/25/2024', '2024-04-30', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (66, '026', 10, 'AS/PTS7/16/25/2024', '2024-04-30', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (67, '007', 10, 'AS/PTS7/01/25/2024', '2024-04-30', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (68, '012', 10, 'AS/PTS7/09/25/2024', '2024-04-30', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (69, '020', 8, 'AS/PTS7/15/25/2024', '2024-04-30', '2024-05-06', '2024-05-16', 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (70, '041', 9, 'AS/BST/14/25/2024', '2024-04-30', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (71, '035', 25, 'AS/BST7/16/25/2024', '2024-04-30', '2024-08-05', NULL, 'In good condition');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (72, '001', 8, 'AS/PTS8/03/20/2024', '2024-05-09', '2024-05-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (73, '015', 10, 'AS/PTS8/01/20/2024', '2024-05-09', '2024-05-31', '2024-05-16', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (74, '011', 10, 'AS/PTS8/04/20/2024', '2024-05-09', '2024-07-31', '2024-05-16', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (75, '004', 8, 'AS/PTS8/13/20/2024', '2024-05-09', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (76, '009', 8, 'AS/PTS8/19/20/2024', '2024-05-09', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (77, '009', 10, 'AS/PTS8/19/20/2024', '2024-05-09', '2024-05-09', '2024-05-16', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (78, '018', 8, 'AS/PTS8/06/20/2024', '2024-05-09', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (79, '046', 8, 'AS/PTS8/05/20/2024', '2024-05-09', '2024-05-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (80, '041', 25, 'AS/BTS7/14/25/2024', '2024-05-09', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (81, '021', 25, 'AS/BST7/07/25/2024', '2024-05-09', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (82, '025', 25, 'AS/BST715/25/2024', '2024-05-09', '2024-05-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (83, '042', 25, 'AS/BST7/02/25/2024', '2024-05-09', '2024-05-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (84, '005', 25, 'AS/BST7/09/25/2024', '2024-05-09', '2024-05-31', NULL, 'N PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (85, '002', 25, 'AS/BST7/19/25/2024', '2024-05-09', '2024-05-31', NULL, 'N PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (86, '045', 25, 'AS/BST7/03/25/2024', '2024-05-09', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (87, '026', 25, 'AS/BST7/08/25/2024', '2024-05-09', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (88, '039', 25, 'AS/BST7/24/25/2024', '2024-05-09', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (89, '044', 25, 'AS/BST7/25/25/2024', '2024-05-09', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (90, '043', 25, 'AS/BST7/18/25/2024', '2024-05-09', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (91, '027', 25, 'AS/BST7/20/25/2024', '2024-05-09', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (92, '030', 25, 'AS/BST7/11/25/2024', '2024-05-09', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (93, '007', 25, 'AS/BST7/66/25/2024', '2024-05-09', '2024-05-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (94, '003', 25, 'AS/BST7/04/25/2024', '2024-05-09', '2024-05-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (95, '031', 25, 'AS/BST7/17/25/2024', '2024-05-09', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (96, '012', 25, 'AS/BST7/05/25/2024', '2024-05-09', '2024-08-05', NULL, 'IN PERFCET CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (97, '033', 25, 'AS/BST7/22/25/2024', '2024-05-09', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (98, '008', 25, 'AS/BST7/13/25/2024', '2024-05-09', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (99, '022', 25, 'AS/BST7/01/25/2024', '2024-05-09', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (100, '036', 25, 'AS/BST7/23/25/2024', '2024-05-09', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (101, '016', 25, 'AS/BST7/10/25/2024', '2024-05-09', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (102, '023', 25, 'AS/BST7/12/25/2024', '2024-05-09', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (103, '026', 15, 'AS/COMP7/12/25/2024', '2024-05-10', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (104, '033', 15, 'AS/COMP7/10/25/2024', '2024-05-10', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (105, '014', 15, 'AS/COMP7/20/25/2024', '2024-05-10', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (106, '027', 15, 'AS/COMP7/0925/2024', '2024-05-10', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (107, '016', 15, 'AS/COMP7/10/25/2024', '2024-05-10', '2024-08-05', NULL, 'IN PERFCET CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (108, '003', 15, 'AS/COMP7/02/25/2024', '2024-05-10', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (109, '007', 15, 'AS/COMP7/21/25/2024', '2024-05-10', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (110, '012', 15, 'AS/COMP7/04/25/2024', '2024-05-10', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (111, '037', 15, 'AS/COMP7/05/25/2024', '2024-05-10', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (112, '008', 15, 'AS/COMP7/22/25/2024', '2024-05-10', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (113, '041', 15, 'AS/COMP7/24/25/2024', '2024-05-10', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (114, '035', 15, 'AS/COMP7/14/25/2024', '2024-05-10', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (115, '038', 15, 'AS/COMP7/18/25/2024', '2024-05-10', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (116, '025', 15, 'AS/COMP7/01/25/2024', '2024-05-10', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (117, '032', 15, 'AS/COMP7/23/25/2024', '2024-05-10', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (118, '040', 15, 'AS/COMP7/23/25/2024', '2024-05-10', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (119, '005', 15, 'AS/COMP7/25/25/2024', '2024-05-10', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (120, '002', 15, 'AS/COMP7/13/25/2024', '2024-05-10', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (121, '020', 15, 'AS/COMP7/06/25/2024', '2024-05-10', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (122, '029', 15, 'AS/COMP7/07/25/2024', '2024-05-10', '2024-08-05', NULL, 'IN GOOD CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (123, '039', 15, 'AS/COMP7/15/25/2024', '2024-05-10', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (124, '043', 15, 'AS/COMP7/17/25/2024', '2024-05-10', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (125, '001', 21, 'AS/HS8/01/10/2024', '2024-05-10', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (126, '015', 21, 'AS/HS8/02/25/2024', '2024-05-10', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (127, '013', 21, 'AS/HS8/09/25/2024', '2024-05-10', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (128, '004', 12, 'AS/CRE8/20/20/2024', '2024-05-10', '2024-07-31', '2024-05-14', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (129, '001', 12, 'AS/CRE8/17/20/2024', '2024-05-10', '2024-07-31', '2024-05-14', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (130, '011', 12, 'AS/CRE8/18/20/2024', '2024-05-10', '2024-07-31', '2024-05-20', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (131, '019', 12, 'AS/CRE8/19/20/2024', '2024-05-10', '2024-07-31', '2024-05-17', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (132, '046', 12, 'AS/CRE8/11/20/2024', '2024-05-10', '2024-07-31', '2024-05-17', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (133, '009', 12, 'AS/CRE8/16/20/2024', '2024-05-10', '2024-07-31', '2024-05-20', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (134, '008', 23, 'AS/SST7/02/20/2024', '2024-05-10', '2024-07-31', '2024-05-17', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (135, '037', 23, 'AS/SST7/15/20/2024', '2024-05-10', '2024-07-31', '2024-05-17', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (136, '033', 23, 'AS/SST7/17/20/2024', '2024-05-10', '2024-07-31', '2024-05-17', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (137, '007', 23, 'AS/SST7/03/20/2024', '2024-05-10', '2024-07-31', '2024-05-17', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (138, '023', 23, 'AS/SST7/14/20/2024', '2024-05-10', '2024-05-31', '2024-05-17', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (139, '029', 12, 'AS/CRE7/15/15/2024', '2024-05-10', '2024-05-31', '2024-05-10', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (140, '026', 12, 'AS/CRE7/11/25/2024', '2024-05-10', '2024-07-31', '2024-05-10', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (141, '036', 12, 'AS/CRE7/11/25/2024', '2024-05-10', '2024-07-31', '2024-05-17', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (142, '035', 12, 'AS/CRE7/04/25/2024', '2024-05-10', '2024-05-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (143, '033', 12, 'AS/CRE7/12/25/2024', '2024-05-10', '2024-05-31', '2024-05-17', 'PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (144, '027', 12, 'AS/CRE7/13/25/2024', '2024-05-10', '2024-05-31', '2024-05-17', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (145, '024', 12, 'AS/CRE7/03/25/2024', '2024-05-10', '2024-05-31', '2024-05-17', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (146, '005', 12, 'AS/CRE7/06/25/2024', '2024-05-10', '2024-05-31', '2024-05-17', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (147, '021', 12, 'AS/CRE7/10/25/2024', '2024-05-10', '2024-05-10', '2024-05-17', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (148, '042', 12, 'AS/CRE7/02/25/2024', '2024-05-10', '2024-05-31', '2024-05-17', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (149, '006', 30, 'AS/CRE7/14/15/2024', '2024-05-10', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (150, '025', 30, 'AS/CRE7/09/15/2024', '2024-05-10', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (151, '023', 30, 'AS/CRE7/01/15/2024', '2024-05-10', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (152, '040', 30, 'AS/CRE7/08/15/2024', '2024-05-10', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (153, '003', 30, 'AS/CRE7/11/15/2024', '2024-05-10', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (154, '002', 23, 'AS/SST7/11/20/2024', '2024-05-11', '2024-07-31', '2024-05-14', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (155, '005', 23, 'AS/SST7/12/20/2024', '2024-05-11', '2024-07-31', '2024-05-17', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (156, '010', 23, 'AS/SST7/09/20/2024', '2024-05-11', '2024-07-31', '2024-05-20', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (157, '040', 23, 'AS/SST7/02/20/2024', '2024-05-11', '2024-07-31', '2024-05-17', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (158, '044', 23, 'AS/SST7/05/20/2024', '2024-05-11', '2024-07-31', '2024-05-17', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (159, '024', 23, 'AS/SST7/18/20/2024', '2024-05-11', '2024-07-31', '2024-05-17', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (160, '032', 23, 'AS/SST7/10/20/2024', '2024-05-11', '2024-07-31', '2024-05-18', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (161, '035', 23, 'AS/SST7/04/20/2024', '2024-05-11', '2024-07-31', '2024-05-18', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (162, '041', 23, 'AS/SST7/13/20/2024', '2024-05-11', '2024-07-31', '2024-05-17', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (163, '042', 23, 'AS/SST7/19/20/2024', '2024-05-11', '2024-07-31', '2024-05-17', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (164, '043', 23, 'AS/SST7/06/20/2024', '2024-05-11', '2024-07-31', '2024-05-17', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (165, '006', 23, 'AS/SST7/20/20/2024', '2024-05-11', '2024-07-31', '2024-05-17', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (166, '020', 23, 'AS/SST7/11/20/2024', '2024-05-11', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (167, '025', 23, 'AS/SST7/03/05/2024', '2024-05-11', '2024-07-31', '2024-05-17', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (168, '039', 23, 'AS/SST7/04/05/2024', '2024-05-11', '2024-07-31', '2024-05-17', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (169, '001', 5, 'AS/SST8/03/18/2024', '2024-05-11', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (170, '019', 5, 'AS/SS8/18/18/2024', '2024-05-11', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (171, '011', 5, 'AS/SS8/04/18/2024', '2024-05-11', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (172, '046', 5, 'AS/SS8/16/18/2024', '2024-05-11', '2024-07-31', '2024-05-17', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (173, '004', 5, 'AS/SS8/02/18/2024', '2024-05-11', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (174, '015', 5, 'AS/SS8/01/18/2024', '2024-05-11', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (175, '009', 5, 'AS/SST7/13/18/2024', '2024-05-11', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (176, '018', 5, 'AS/SST7/11/18/2024', '2024-05-11', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (177, '013', 5, 'AS/SST7/17/18/2024', '2024-05-11', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (178, '015', 2, 'AS/HE8/03/20/2024', '2024-05-11', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (179, '004', 2, 'AS/HE8/02/20/2024', '2024-05-11', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (180, '011', 2, 'AS/HE8/13/20/2024', '2024-05-11', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (181, '001', 2, 'AS/HE8/20/20/2024', '2024-05-11', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (182, '009', 2, 'AS/HE8/19/20/2024', '2024-05-11', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (183, '019', 2, 'AS/HE8/18/20/2024', '2024-05-11', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (184, '013', 2, 'AS/HE8/14/20/2024', '2024-05-11', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (185, '018', 2, 'AS/HE8/05/20/2024', '2024-05-11', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (186, '041', 24, 'AS/K715/27/2024', '2024-05-11', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (187, '043', 24, 'AS/K702/25/2024', '2024-05-11', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (188, '035', 24, 'AS/K701/25/2024', '2024-05-11', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (189, '038', 24, 'AS/K703/25/2024', '2024-05-11', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (190, '042', 24, 'AS/K706/25/2024', '2024-05-11', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (191, '034', 24, 'AS/K704/25/2024', '2024-05-11', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (192, '010', 24, 'AS/K7/05/25/2024', '2024-05-11', '2024-08-05', '2024-05-20', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (193, '024', 24, 'AS/K708/25/2024', '2024-05-11', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (194, '025', 14, 'AS/MT/12/25/2024', '2024-05-11', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (195, '016', 14, 'AS/MT7/12/25/2024', '2024-05-11', '2024-08-05', NULL, 'IN PERCFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (196, '006', 14, 'AS/MT7/13/25/2024', '2024-05-11', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (197, '003', 14, 'AS/MT7/20/25/2024', '2024-05-11', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (198, '017', 14, 'AS/MT7/15/25/2024', '2024-05-11', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (199, '010', 14, 'AS/MT7/09/25/2024', '2024-05-11', '2024-08-05', '2024-05-20', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (200, '002', 14, 'AS/MT7/11/25/2024', '2024-05-11', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (201, '026', 14, 'AS/MT7/18/25/2024', '2024-05-11', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (202, '007', 14, 'AS/MT7/15/25/2024', '2024-05-11', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (203, '022', 14, 'AS/MT7/08/25/2024', '2024-05-11', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (204, '005', 14, 'AS/MT7/16/25/2024', '2024-05-11', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (205, '020', 14, 'AS/MT7/19/25/2024', '2024-05-11', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (206, '008', 14, 'AS/MT7/12/25/2024', '2024-05-11', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (207, '012', 14, 'AS/MT7/06/25/2024', '2024-05-11', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (208, '014', 14, 'AS/MT7/10/25/2024', '2024-05-11', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (209, '037', 14, 'AS/MT7/24/25/2024', '2024-05-11', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (210, '027', 14, 'AS/MT7/22/25/2024', '2024-05-11', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (211, '036', 14, 'AS/MT7/23/25/2024', '2024-05-11', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (212, '023', 14, 'AS/MT7/01/25/2024', '2024-05-11', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (213, '047', 14, 'AS/MT7/02/25/2024', '2024-05-11', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (214, '035', 14, 'AS/MT7/03/25/2024', '2024-05-11', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (215, '038', 14, 'AS/MT7/04/25/2024', '2024-05-11', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (216, '029', 14, 'AS/MT7/14/25/2024', '2024-05-11', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (217, '045', 14, 'AS/MT7/21/25/2024', '2024-05-11', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (218, '011', 17, 'AS/KF8/12/20/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (219, '001', 17, 'AS/KF8/13/20/2024', '2024-05-13', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (220, '004', 17, 'AS/KF8/18 /20/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (221, '013', 17, 'AS/KF8/19 /20/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (222, '015', 17, 'AS/KF8/07/20/2024', '2024-05-13', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (223, '009', 17, 'AS/KF8/09/20/2024', '2024-05-13', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (224, '019', 17, 'AS/KF8/05/20/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (225, '018', 17, 'AS/KF8/11/20/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (226, '046', 17, 'AS/KF8/15/20/2024', '2024-05-13', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (227, '016', 1, 'AS/IRE7/14/15/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (228, '002', 1, 'AS/IRE7/11/15/2024', '2024-05-13', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (229, '012', 1, 'AS/IRE7/13/15/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (230, '007', 1, 'AS/IRE7/11/15/2024', '2024-05-13', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (231, '017', 1, 'AS/IRE7/12/15/2024', '2024-05-13', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (232, '039', 1, 'AS/IRE7/10/15/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (233, '037', 1, 'AS/IRE7/09/15/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (234, '005', 29, 'AS/LS7/17/202/2024', '2024-05-13', '2024-07-31', '2024-05-16', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (235, '010', 29, 'AS/LS7/14/202/2024', '2024-05-13', '2024-08-05', '2024-05-16', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (236, '002', 29, 'AS/LS7/18/202/2024', '2024-05-13', '2024-07-31', '2024-05-16', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (237, '025', 29, 'AS/LS7/11/202/2024', '2024-05-13', '2024-07-31', '2024-05-16', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (238, '007', 29, 'AS/LS7/13/202/2024', '2024-05-13', '2024-07-31', '2024-05-16', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (239, '006', 29, 'AS/LS7/10/202/2024', '2024-05-13', '2024-07-31', '2024-05-16', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (240, '021', 29, 'AS/LS7/12/202/2024', '2024-05-13', '2024-07-31', '2024-05-16', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (241, '023', 29, 'AS/LS7/16/202/2024', '2024-05-13', '2024-07-31', '2024-05-16', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (242, '022', 29, 'AS/LS7/19/20/2024', '2024-05-13', '2024-07-31', '2024-05-16', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (243, '030', 29, 'AS/LS7/20/20/2024', '2024-05-13', '2024-07-31', '2024-05-16', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (244, '031', 29, 'AS/LS7/06/20/2024', '2024-05-13', '2024-07-31', '2024-05-16', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (245, '012', 29, 'AS/LS7/07/202/2024', '2024-05-13', '2024-08-05', '2024-05-16', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (246, '003', 29, 'AS/LS7/09/202/2024', '2024-05-13', '2024-07-31', '2024-05-16', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (247, '041', 29, 'AS/LS7/08/202/2024', '2024-05-13', '2024-07-31', '2024-05-16', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (248, '015', 6, 'AS/IRE8/07/10/2024', '2024-05-13', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (249, '015', 29, 'AS/IRE8/09/10/2024', '2024-05-13', '2024-07-31', '2024-05-20', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (250, '018', 29, 'AS/IRE8/05/10/2024', '2024-05-13', '2024-08-05', '2024-05-16', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (251, '018', 6, 'AS/IRE8/05/10/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (252, '006', 24, 'AS/K7/15/25/2024', '2024-05-13', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (253, '016', 24, 'AS/K7/12/25/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (254, '002', 24, 'AS/K7/09/25/2024', '2024-05-13', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (255, '020', 24, 'AS/K7/10/25/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (256, '014', 24, 'AS/K7/25/25/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (257, '026', 24, 'AS/K7/16/25/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (258, '017', 24, 'AS/K7/17/25/2024', '2024-05-13', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (259, '025', 24, 'AS/K7/11/25/2024', '2024-05-13', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (260, '003', 24, 'AS/K7/11/25/2024', '2024-05-13', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (261, '012', 24, 'AS/K7/19/25/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (262, '007', 24, 'AS/K7/23/25/2024', '2024-05-13', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (263, '008', 24, 'AS/K7/12/25/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (264, '005', 24, 'AS/K7/24/25/2024', '2024-05-13', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (265, '020', 13, 'AS/ENG7/09/25/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (266, '006', 13, 'AS/ENG7/08/25/2024', '2024-05-13', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (267, '044', 13, 'AS/ENG7/15/25/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (268, '031', 13, 'AS/ENG7/16/25/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (269, '038', 13, 'AS/ENG7/14/25/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (270, '024', 13, 'AS/ENG7/20/25/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (271, '042', 13, 'AS/ENG7/13/25/2024', '2024-05-13', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (272, '041', 13, 'AS/ENG7/13/25/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (273, '043', 13, 'AS/ENG7/19/25/2024', '2024-05-13', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (274, '040', 13, 'AS/ENG7/11/25/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (275, '032', 13, 'AS/ENG7/21/25/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (276, '039', 13, 'AS/ENG7/12/25/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (277, '005', 28, 'AS/A7/22/25/2024', '2024-05-13', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (278, '002', 28, 'AS/A7/23/25/2024', '2024-05-13', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (279, '003', 28, 'AS/A7/21/25/2024', '2024-05-13', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (280, '031', 28, 'AS/A7/20/25/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (281, '024', 28, 'AS/A7/18/25/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (282, '025', 28, 'AS/A7/19/25/2024', '2024-05-13', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (283, '042', 28, 'AS/A7/24/25/2024', '2024-05-13', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (284, '035', 28, 'AS/A7/25/25/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (285, '043', 28, 'AS/A7/17/25/2024', '2024-05-13', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (286, '040', 28, 'AS/A7/07/25/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (287, '029', 28, 'AS/A7/15/25/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (288, '045', 28, 'AS/A7/16/25/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (289, '007', 13, 'AS/ENG7/03/25/2024', '2024-05-13', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (290, '027', 13, 'AS/ENG7/25/25/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (291, '033', 28, 'AS/ENG7/17/25/2024', '2024-05-13', '2024-07-31', '2024-05-13', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (292, '033', 13, 'AS/ENG7/17/25/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (293, '030', 13, 'AS/ENG7/01/25/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (294, '014', 13, 'AS/ENG7/19/25/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (295, '047', 13, 'AS/ENG7/05/25/2024', '2024-05-13', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (296, '016', 13, 'AS/ENG7/04/25/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (297, '037', 13, 'AS/ENG7/18/25/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (298, '021', 13, 'AS/ENG7/22/25/2024', '2024-05-13', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (299, '012', 13, 'AS/ENG7/02/25/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (300, '026', 13, 'AS/ENG7/23/25/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (301, '022', 13, 'AS/ENG7/19/25/2024', '2024-05-13', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (302, '001', 32, 'AS/CRE8/17/20/2024', '2024-05-14', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (303, '002', 31, 'AS/SST7/11/20/2024', '2024-05-14', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (304, '004', 32, 'AS/CRE8/20/20/2024', '2024-05-14', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (305, '027', 28, 'AS A7/05/25/2024', '2024-05-15', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (306, '007', 28, 'AS/A7/12/25/2024', '2024-05-15', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (307, '033', 28, 'AS/A7/02/25/2024', '2024-05-15', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (308, '034', 28, 'AS/A7/08/25/2024', '2024-05-15', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (309, '023', 28, 'AS/A7/04/25/2024', '2024-05-15', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (310, '030', 28, 'AS/A7/11/25/2024', '2024-05-15', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (311, '047', 28, 'AS/A7/03/25/2024', '2024-05-15', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (312, '017', 28, 'AS/A7/13/25/2024', '2024-05-15', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (313, '037', 28, 'AS/A7/06/25/2024', '2024-05-15', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (314, '021', 28, 'AS/A7/01/25/2024', '2024-05-15', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (315, '012', 28, 'AS/A7/09/25/2024', '2024-05-15', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (316, '008', 28, 'AS/A7/10/25/2024', '2024-05-15', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (317, '008', 7, 'AS/HS7/16/2024', '2024-05-15', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (318, '028', 7, 'AS/HS7/09/2024', '2024-05-15', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (319, '036', 7, 'AS/HS7/01/20/2024', '2024-05-15', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (320, '016', 7, 'AS/HS7/20/20/2024', '2024-05-15', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (321, '048', 7, 'AS/HS7/08/20/2024', '2024-05-15', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (322, '010', 7, 'AS/HS7/19/20/2024', '2024-05-15', '2024-08-05', '2024-05-20', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (323, '014', 7, 'AS/HS7/02/20/2024', '2024-05-15', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (324, '026', 7, 'AS/HS703/20/2024', '2024-05-15', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (325, '022', 7, 'AS/HS7/14/20/2024', '2024-05-15', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (326, '038', 7, 'AS/HS7/12/20/2024', '2024-05-15', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (327, '024', 7, 'AS/HS7/10/20/2024', '2024-05-15', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (328, '042', 7, 'AS/HS7/15/20/2024', '2024-05-15', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (329, '041', 7, 'AS/HS7/04/20/2024', '2024-05-15', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (330, '032', 7, 'AS/HS7/11/20/2024', '2024-05-15', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (331, '040', 7, 'AS/HS7/07/20/2024', '2024-05-15', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (332, '029', 7, 'AS/HS7/18/20/2024', '2024-05-15', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (333, '020', 7, 'AS/HS712/20/2024', '2024-05-15', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (334, '044', 7, 'AS/HS7/06/20/2024', '2024-05-15', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (335, '006', 7, 'AS/HS7/17/20/2024', '2024-05-15', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (336, '010', 10, 'AS/PTS7/19/25/2024', '2024-05-16', '2024-08-05', '2024-05-20', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (337, '011', 8, 'AS/PTS8/04/20/2024', '2024-05-16', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (338, '015', 8, 'AS/PTS8/01/20/2024', '2024-05-16', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (339, '034', 10, 'AS/PTS7/25/25/2024', '2024-05-17', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (340, '037', 31, 'AS/SST7/15/20/2024', '2024-05-17', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (341, '040', 31, 'AS/SST7/02/20/2024', '2024-05-17', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (342, '041', 31, 'AS/SST7/13/20/2024', '2024-05-17', '2025-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (343, '042', 30, 'AS/CRE7/02/25/2024', '2024-05-17', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (344, '042', 31, 'AS/SST7/19/20/2024', '2024-05-17', '2025-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (345, '043', 31, 'AS/SST7/06/20/2024', '2024-05-17', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (346, '045', 30, 'AS/CRE8/11/20/2024', '2024-05-17', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (347, '005', 30, 'AS/CRE7/06/25/2024', '2024-05-17', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (348, '005', 31, 'AS/SST7/12/20/2024', '2024-05-17', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (349, '006', 31, 'AS/SST7/20/20/2024', '2024-05-17', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (350, '006', 15, 'AS/COMP7/02/25/2024', '2024-05-17', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (351, '007', 31, 'AS/SST7/03/20/2024', '2024-05-17', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (352, '008', 31, 'AS/SST7/02/20/2024', '2024-05-17', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (353, '008', 10, 'AS/PTS7/04/25/2024', '2024-05-17', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (354, '036', 30, 'AS/CRE7/11/25/2024', '2024-05-17', '2024-08-05', '2024-06-03', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (355, '026', 31, 'AS/SST7/16/20/2024', '2024-05-17', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (356, '033', 31, 'AS/SST7/17/20/2024', '2024-05-17', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (357, '023', 31, 'AS/SST7/14/20/2024', '2024-05-17', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (358, '011', 32, 'AS/CRE8/18/20/2024', '2024-05-17', '2024-08-05', '2024-05-20', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (359, '019', 32, 'AS/19/20/2024', '2024-05-17', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (360, '045', 32, 'AS/CRE8/11/20/2024', '2024-05-17', '2024-08-05', '2024-05-18', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (361, '009', 32, 'AS/CRE8/16/202/2024', '2024-05-17', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (362, '029', 30, 'AS/CRE7/07/15/2024', '2024-05-17', '2025-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (363, '026', 30, 'AS/CRE7/15/15/2024', '2024-05-17', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (364, '025', 31, 'AS/SST7/03/05/2024', '2024-05-17', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (365, '031', 30, 'AS/CRE7/05/15/2024', '2024-05-17', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (366, '031', 31, 'AS/SST7/05/05/2024', '2024-05-17', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (367, '021', 30, 'AS/CRE7/10/15/2024', '2024-05-17', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (368, '024', 30, 'AS/CRE7/03/15/2024', '2024-05-17', '2024-08-05', '2024-06-03', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (369, '024', 31, 'AS/SST7/18/20/2024', '2024-05-17', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (370, '027', 30, 'AAS/CRE713/15/2024', '2024-05-17', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (371, '024', 10, 'AS/PTS7/14/25/2024', '2024-05-17', '2024-08-11', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (372, '032', 31, 'AS/SSST7/10/20/2024', '2024-05-18', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (373, '035', 31, 'AS/SST7/04/20/2024', '2024-05-18', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (374, '029', 31, 'AS/SST7/01/20/2024', '2024-05-18', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (375, '045', 31, 'AS/SST7/01/05/2024', '2024-05-18', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (376, '010', 9, 'AS/BS8/09/20/2024', '2024-05-20', '2024-08-05', '2024-05-20', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (377, '010', 32, 'AS/CRE8/18/20/2024', '2024-05-20', '2024-08-05', '2024-05-20', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (378, '010', 8, 'AS/PTS8/04/20/2024', '2024-05-20', '2024-08-05', '2024-05-20', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (379, '010', 17, 'AS/KF8/12/20/2024', '2024-05-20', '2024-08-05', '2024-05-20', 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (380, '011', 32, 'AS/CRE8/18/20/2024', '2024-05-20', '2024-08-05', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (381, '008', 66, 'AS/SST/02/20/2024', '2024-05-30', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (382, '037', 66, 'AS/SST7/15/20/2024', '2024-05-30', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (383, '026', 66, 'AS/SST7/16/20/2024', '2024-05-30', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (384, '033', 66, 'AS/SST7/17/20/2024', '2024-05-30', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (385, '007', 66, 'AS/SST7/03/20/2024', '2024-05-30', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (386, '023', 66, 'AS/SST7/14/20/2024', '2024-05-30', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (387, '012', 66, 'AS/SST7/05/20/2024', '2024-05-30', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (388, '016', 66, 'AS/SST7/16/20/2024', '2024-05-30', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (389, '027', 66, 'AS/SST7/18/20/2024', '2024-05-30', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (390, '017', 66, 'AS/SST7/02/20/2024', '2024-05-30', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (391, '036', 66, 'AS/SST7/03/20/2024', '2024-05-30', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (392, '048', 66, 'AS/SST7/04/20/2024', '2024-05-30', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (393, '034', 66, 'AS/SST7/01/20/2024', '2024-05-30', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (394, '014', 66, 'AS/SST7/06/20/2024', '2024-05-30', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (395, '047', 66, 'AS/SST7/07/20/2024', '2024-05-30', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (396, '028', 66, 'AS/SST7/08/20/2024', '2024-05-30', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (397, '030', 66, 'AS/SST7/14/20/2024', '2024-05-30', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (398, '031', 66, 'AS/SST7/13/20/2024', '2024-05-30', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (399, '010', 66, 'AS/SST7/15/20/2024', '2024-05-30', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (400, '022', 66, 'AS/SST7/09/20/2024', '2024-05-30', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (401, '029', 67, 'AS/CRE7/07/15/2024', '2024-06-03', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (402, '026', 67, 'AS/CRE7/15/15/2024', '2024-06-03', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (403, '036', 67, 'AS/CRE7/09/20/2024', '2024-06-03', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (404, '003', 67, 'AS/CRE7/11/15/2024', '2024-06-03', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (405, '032', 67, 'AS/CRE7/01/20/2024', '2024-06-03', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (406, '040', 67, 'AS/CRE7/08/15/2024', '2024-06-03', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (407, '023', 67, 'AS/CRE7/01/15/2024', '2024-06-03', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (408, '025', 67, 'AS/CRE7/09/15/2024', '2024-06-03', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (409, '008', 67, 'AS/CRE7/10/20/2024', '2024-06-03', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (410, '006', 67, 'AS/CRE7/14/15/2024', '2024-06-03', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (411, '038', 67, 'AS/CRE7/09/15/2024', '2024-06-03', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (412, '031', 67, 'AS/CRE7/05/15/2024', '2024-06-03', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (413, '041', 67, 'AS/CRE7/03/20/2024', '2024-06-03', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (414, '042', 67, 'AS/CRE7/02/15/2024', '2024-06-03', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (415, '034', 67, 'AS/CRE7/095120/2024', '2024-06-03', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (416, '021', 67, 'AS/CRE7/10/15/2024', '2024-06-03', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (417, '022', 67, 'AS/CRE7/06/20/2024', '2024-06-03', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (418, '005', 67, 'AS/CRE7/06/15/2024', '2024-06-03', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (419, '024', 67, 'AS/CRE7/07/20/2024', '2024-06-03', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (420, '027', 67, 'AS/CRE7/13/15/2024', '2024-06-03', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (421, '033', 67, 'AS/CRE7/12/15/2024', '2024-06-03', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (422, '035', 67, 'AS/CRE7/04/15/2024', '2024-06-03', '2024-07-31', NULL, 'IN PERFECT CONDITION');
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES (423, '036', 56, 'AS/K7/19/25/2024', '2024-06-03', '2024-07-31', NULL, 'IN PERFECT CONDITION');


#
# TABLE STRUCTURE FOR: leaveapplications
#

DROP TABLE IF EXISTS `leaveapplications`;

CREATE TABLE `leaveapplications` (
  `leaveapplicationID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `leavecategoryID` int(10) unsigned NOT NULL,
  `apply_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `od_status` tinyint(1) NOT NULL DEFAULT '0',
  `from_date` date NOT NULL,
  `from_time` time DEFAULT NULL,
  `to_date` date NOT NULL,
  `to_time` time DEFAULT NULL,
  `leave_days` int(11) NOT NULL,
  `reason` text,
  `attachment` varchar(200) DEFAULT NULL,
  `attachmentorginalname` varchar(200) DEFAULT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(10) unsigned NOT NULL,
  `applicationto_userID` int(10) unsigned DEFAULT NULL,
  `applicationto_usertypeID` int(10) unsigned DEFAULT NULL,
  `approver_userID` int(10) unsigned DEFAULT NULL,
  `approver_usertypeID` int(10) unsigned DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `schoolyearID` int(11) NOT NULL,
  PRIMARY KEY (`leaveapplicationID`),
  KEY `leave_categoryID` (`leavecategoryID`),
  KEY `from_date` (`from_date`),
  KEY `to_date` (`to_date`),
  KEY `approver_userID` (`approver_userID`),
  KEY `approver_usertypeID` (`approver_usertypeID`),
  KEY `applicationto_usertypeID` (`applicationto_usertypeID`),
  KEY `applicationto_userID` (`applicationto_userID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: leaveassign
#

DROP TABLE IF EXISTS `leaveassign`;

CREATE TABLE `leaveassign` (
  `leaveassignID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `leavecategoryID` int(10) unsigned NOT NULL,
  `usertypeID` int(10) unsigned NOT NULL,
  `leaveassignday` int(11) NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`leaveassignID`),
  KEY `leave_categoryID` (`leavecategoryID`),
  KEY `usertypeID` (`usertypeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: leavecategory
#

DROP TABLE IF EXISTS `leavecategory`;

CREATE TABLE `leavecategory` (
  `leavecategoryID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `leavecategory` varchar(255) NOT NULL,
  `leavegender` int(11) DEFAULT '0' COMMENT '1 = General, 2 = Male, 3 = Femele',
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`leavecategoryID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: lmember
#

DROP TABLE IF EXISTS `lmember`;

CREATE TABLE `lmember` (
  `lmemberID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `lID` varchar(40) NOT NULL,
  `studentID` int(11) NOT NULL,
  `name` varchar(60) NOT NULL,
  `email` varchar(40) DEFAULT NULL,
  `phone` tinytext,
  `lbalance` varchar(20) DEFAULT NULL,
  `ljoindate` date NOT NULL,
  PRIMARY KEY (`lmemberID`)
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=utf8;

INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (1, '001', 1, 'JULIE SAGA HANS', '001@email.com', '0723821682', '0.00', '2024-03-08');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (2, '002', 2, 'SALIM. N. MWAKIKOI', '002@email.com', '0721242304', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (3, '003', 3, 'EMMANUEL MWANGI', '003@email.com', '0718559574', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (4, '005', 5, 'LIAM KIRUHI KAMWERU', '005@email.com', '0710847382', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (5, '006', 6, 'ESTHER MUENI', '006@email.com', '0722275523', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (6, '007', 7, 'JUMA SWALEH', '007@email.com', '0725847742', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (7, '008', 8, 'MARYLNE NJOKI', '008@email.com', '0724729313', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (8, '010', 10, 'EVANS MUTUA', '010@email.com', '0725736549', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (9, '012', 12, 'YUSUF MWINYI', '012@email.com', '0720416331', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (10, '014', 14, 'RICHARD MSOMI', '014@email.com', '0791356119', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (11, '016', 16, 'ALI SAID', '016@email.com', '0720470947', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (12, '017', 17, 'RANDANI KASSIM', '017@email.com', '0714566632', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (13, '020', 20, 'ZAINAB SALIM', '020@email.com', '0712061423', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (14, '021', 21, 'DELPHINE KHALAI', '021@email.com', '0721297829', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (15, '022', 22, 'ISAACK MULEI', '022@email.com', '0724596068', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (16, '023', 23, 'YOHANN’S MUGO', '023@email.com', '0728812791', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (17, '024', 24, 'TYRESE KITHUNGA', '024@email.com', '0723202044', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (18, '025', 25, 'YVONNE KAMENE', '025@email.com', '0728340284', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (19, '026', 26, 'WENDY NDUKU', '026@email.com', '072044052', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (20, '027', 27, 'CHELSEA JULIA', '027@email.com', '0715017692', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (21, '028', 28, 'SHAUN MATHEKA', '028@email.com', '0728577762', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (22, '038', 38, 'ADELIGHT FURAHA', '038@email.com', '0721992929', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (23, '037', 37, 'KHADIJA JUMA', '037@email.com', '0700488072', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (24, '036', 36, 'FORTUNE KAITHYA', '036@email.com', '0721374654', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (25, '035', 35, 'LOUIS KITSAO', '035@email.com', '0705562938', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (26, '029', 29, 'ASHLEY NELIMA', '029@email.com', '0726565822', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (27, '030', 30, 'VANESSA WANGU', '030@email.com', '0720453785', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (28, '031', 31, 'OPRAH WANGARE', '031@email.com', '0724700760', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (29, '032', 32, 'ROBIN  BAYA EDWIN MISTANZE', '032@email.com', '07022208172', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (30, '033', 33, 'LIONELL KADIEDA', '033@email.com', '0713562695', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (31, '034', 34, 'SANDRA NASIKE', '034@email.com', '0722730248', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (32, '048', 48, 'RAINER KIMILU', '048@email.com', '0799212822', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (33, '047', 47, 'LATIFFA BRIGIT MATASA', '047@email.com', '0723342467', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (34, '045', 45, 'LISSY IVY', '045@email.com', '0721970074', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (35, '044', 44, 'ISMAILMGANDI', '044@email.com', '0726370674', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (36, '043', 43, 'KHERI MWANGAZA', '043@email.com', '0720092398', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (37, '042', 42, 'BENJAMIN\nMUTHOMI', '042@email.com', '0743061566', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (38, '041', 41, 'SULEIMANABDALLAH', '041@email.com', '0716781801', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (39, '040', 40, 'SEMIGIL KOOME', '040@email.com', '0712977566', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (40, '039', 39, 'SASHA PEARL', '039@email.com', '0737142919', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (41, '004', 4, 'BLESSING LUYAI', '004@email.com', '0111252511', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (42, '009', 9, 'MICHAEL FREDRICK', '009@email.com', '0721843049', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (43, '011', 11, 'N’NJEMA ISABEL', '011@email.com', '0700494066', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (44, '013', 13, 'ALI WASILWA PAKIA', '013@email.com', '0721212078', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (45, '015', 15, 'ISSA HAMAD', '015@email.com', '0792103291', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (46, '018', 18, 'ALMASI MALAU', '018@email.com', '0797902314', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (47, '019', 19, 'BRIAN KIOKO', '019@email.com', '0726485462,0721894090', '0.00', '2024-04-17');
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES (48, '046', 46, 'LINDA MAUA', '046@email.com', '0721536537', '0.00', '2024-04-17');


#
# TABLE STRUCTURE FOR: location
#

DROP TABLE IF EXISTS `location`;

CREATE TABLE `location` (
  `locationID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `location` varchar(128) NOT NULL,
  `description` text,
  `create_date` date NOT NULL,
  `modify_date` date NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  `active` int(11) NOT NULL,
  PRIMARY KEY (`locationID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: loginlog
#

DROP TABLE IF EXISTS `loginlog`;

CREATE TABLE `loginlog` (
  `loginlogID` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(45) DEFAULT NULL,
  `browser` varchar(128) DEFAULT NULL,
  `operatingsystem` varchar(128) DEFAULT NULL,
  `login` int(10) unsigned DEFAULT NULL,
  `logout` int(10) unsigned DEFAULT NULL,
  `usertypeID` int(11) DEFAULT NULL,
  `userID` int(11) DEFAULT NULL,
  PRIMARY KEY (`loginlogID`)
) ENGINE=InnoDB AUTO_INCREMENT=489 DEFAULT CHARSET=utf8;

INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (1, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709146232, 1709146532, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (2, '102.222.4.116', 'Mozilla Firefox', 'linux', 1709192323, 1709192623, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (3, '102.222.4.116', 'Mozilla Firefox', 'linux', 1709200202, 1709200502, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (4, '102.222.4.116', 'Google Chrome', 'linux', 1709200954, 1709201254, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (5, '102.222.4.116', 'Google Chrome', 'linux', 1709200955, 1709201255, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (6, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709484669, 1709485054, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (7, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709485062, 1709485181, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (8, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709485184, 1709486386, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (9, '102.213.176.14', 'Google Chrome', 'linux', 1709485696, 1709485996, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (10, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709486396, 1709486420, 2, 33);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (11, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709486424, 1709486689, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (12, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709486699, 1709486751, 2, 33);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (13, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709486753, 1709486894, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (14, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709486896, 1709486938, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (15, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709486951, 1709486992, 2, 28);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (16, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709487003, 1709487026, 2, 33);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (17, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709487029, 1709487109, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (18, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709487120, 1709487155, 2, 33);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (19, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709491141, 1709491441, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (20, '41.90.5.7', 'Mozilla Firefox', 'linux', 1709542732, 1709544128, 2, 32);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (21, '41.90.5.7', 'Mozilla Firefox', 'linux', 1709544131, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (22, '102.222.4.116', 'Google Chrome', 'linux', 1709544246, 1709544348, 2, 32);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (23, '102.222.4.116', 'Google Chrome', 'linux', 1709544360, 1709544554, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (24, '41.90.5.51', 'Mozilla Firefox', 'Unknown', 1709544501, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (25, '102.222.4.116', 'Google Chrome', 'linux', 1709544780, NULL, 2, 32);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (26, '41.90.5.136', 'Mozilla Firefox', 'linux', 1709546902, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (27, '102.222.4.116', 'Google Chrome', 'windows', 1709551298, 1709551598, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (28, '196.201.210.106', 'Mozilla Firefox', 'linux', 1709628121, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (29, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709712929, 1709722099, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (30, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709722108, 1709722212, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (31, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709722217, 1709722978, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (32, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709722983, 1709723283, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (33, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709723117, 1709723417, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (34, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709723364, 1709723664, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (35, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709723487, 1709723787, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (36, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709723548, 1709723848, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (37, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709723635, 1709723935, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (38, '102.213.176.14', 'Google Chrome', 'linux', 1709731472, 1709731772, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (39, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709731612, 1709732441, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (40, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709732652, 1709732952, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (41, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709733951, 1709734251, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (42, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709743033, 1709746510, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (43, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709746521, 1709746588, 2, 30);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (44, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709746617, 1709747804, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (45, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709747815, 1709748201, 2, 32);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (46, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709748203, 1709748503, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (47, '196.201.210.122', 'Mozilla Firefox', 'Unknown', 1709797729, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (48, '102.222.4.116', 'Google Chrome', 'windows', 1709804982, 1709805651, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (49, '105.161.138.197', 'Mozilla Firefox', 'linux', 1709805314, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (50, '102.222.4.116', 'Google Chrome', 'windows', 1709805671, 1709805971, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (51, '102.222.4.116', 'Google Chrome', 'linux', 1709806692, 1709806992, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (52, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709823000, 1709823300, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (53, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709866380, 1709866680, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (54, '105.161.45.13', 'Mozilla Firefox', 'Unknown', 1709876586, 1709876886, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (55, '105.161.45.13', 'Mozilla Firefox', 'linux', 1709882999, 1709883438, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (56, '105.161.45.13', 'Mozilla Firefox', 'linux', 1709883441, 1709883741, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (57, '102.222.4.116', 'Google Chrome', 'windows', 1709886012, 1709886965, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (58, '105.161.45.13', 'Mozilla Firefox', 'linux', 1709886312, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (59, '102.222.4.116', 'Google Chrome', 'windows', 1709886974, 1709887274, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (60, '102.222.4.116', 'Google Chrome', 'linux', 1709887599, 1709888706, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (61, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709917352, 1709917652, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (62, '102.213.176.14', 'Mozilla Firefox', 'linux', 1709918573, 1709918873, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (63, '102.213.176.14', 'Mozilla Firefox', 'Unknown', 1709920025, 1709920325, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (64, '102.222.4.116', 'Google Chrome', 'windows', 1710140671, 1710140971, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (65, '102.222.4.116', 'Google Chrome', 'windows', 1710140822, 1710141122, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (66, '102.222.4.116', 'Google Chrome', 'windows', 1710140825, 1710141125, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (67, '102.213.176.14', 'Mozilla Firefox', 'linux', 1710211976, 1710212276, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (68, '102.222.4.116', 'Google Chrome', 'windows', 1710329797, 1710331865, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (69, '102.222.4.116', 'Google Chrome', 'windows', 1710331919, 1710333080, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (70, '41.81.83.42', 'Mozilla Firefox', 'Unknown', 1710333813, 1710333847, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (71, '41.81.83.42', 'Mozilla Firefox', 'Unknown', 1710333924, 1710333984, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (72, '41.81.83.42', 'Mozilla Firefox', 'Unknown', 1710333997, 1710335576, 5, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (73, '41.81.83.42', 'Mozilla Firefox', 'Unknown', 1710335666, NULL, 2, 30);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (74, '102.213.176.14', 'Mozilla Firefox', 'linux', 1710350220, 1710350520, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (75, '102.213.176.14', 'Mozilla Firefox', 'linux', 1710351322, 1710351373, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (76, '102.213.176.14', 'Mozilla Firefox', 'linux', 1710351382, 1710351387, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (77, '102.213.176.14', 'Mozilla Firefox', 'linux', 1710351395, 1710351418, 5, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (78, '102.222.4.116', 'Google Chrome', 'windows', 1710390031, 1710390490, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (79, '102.222.4.116', 'Google Chrome', 'windows', 1710390501, 1710390801, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (80, '102.222.4.116', 'Google Chrome', 'windows', 1710390775, 1710391075, 2, 30);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (81, '105.160.89.101', 'Mozilla Firefox', 'Unknown', 1710391829, 1710392030, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (82, '105.160.89.101', 'Mozilla Firefox', 'Unknown', 1710392046, NULL, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (83, '102.222.4.116', 'Google Chrome', 'linux', 1710392423, 1710392723, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (84, '102.222.4.116', 'Google Chrome', 'linux', 1710395398, 1710396603, 2, 30);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (85, '102.222.4.116', 'Google Chrome', 'linux', 1710396631, 1710396931, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (86, '102.222.4.116', 'Google Chrome', 'windows', 1710397298, 1710397598, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (87, '102.222.4.116', 'Google Chrome', 'linux', 1710398003, 1710398303, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (88, '102.222.4.116', 'Google Chrome', 'linux', 1710400881, 1710401181, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (89, '102.222.4.116', 'Google Chrome', 'windows', 1710404739, 1710405039, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (90, '41.90.4.127', 'Google Chrome', 'linux', 1710407905, NULL, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (91, '62.24.116.41', 'Google Chrome', 'windows', 1710416312, NULL, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (92, '102.222.4.116', 'Google Chrome', 'linux', 1710418748, 1710419048, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (93, '102.222.4.116', 'Google Chrome', 'linux', 1710418749, 1710419049, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (94, '102.222.4.116', 'Google Chrome', 'windows', 1710422583, 1710422883, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (95, '102.222.4.116', 'Google Chrome', 'linux', 1710423772, 1710423840, 2, 30);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (96, '102.222.4.116', 'Google Chrome', 'linux', 1710423852, 1710424446, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (97, '102.222.4.116', 'Google Chrome', 'linux', 1710424454, 1710424754, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (98, '102.222.4.116', 'Google Chrome', 'windows', 1710433100, 1710433400, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (99, '102.213.176.14', 'Mozilla Firefox', 'Unknown', 1710437471, 1710437771, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (100, '154.159.254.181', 'Google Chrome', 'linux', 1710471341, NULL, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (101, '154.159.254.202', 'Google Chrome', 'linux', 1710475781, NULL, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (102, '102.222.4.116', 'Google Chrome', 'windows', 1710476877, 1710479288, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (103, '102.222.4.116', 'Google Chrome', 'windows', 1710479327, 1710480006, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (104, '102.222.4.116', 'Google Chrome', 'windows', 1710480018, 1710480318, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (105, '102.222.4.116', 'Google Chrome', 'linux', 1710485154, 1710485454, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (106, '105.49.172.92', 'Mozilla Firefox', 'Unknown', 1710487715, 1710490349, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (107, '105.49.172.92', 'Mozilla Firefox', 'Unknown', 1710490368, NULL, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (108, '102.222.4.116', 'Mozilla Firefox', 'linux', 1710493841, 1710497551, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (109, '102.222.4.116', 'Google Chrome', 'linux', 1710494360, 1710494660, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (110, '102.222.4.116', 'Google Chrome', 'windows', 1710494555, 1710494855, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (111, '102.222.4.116', 'Google Chrome', 'linux', 1710495119, 1710496459, 5, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (112, '102.222.4.116', 'Google Chrome', 'linux', 1710496524, 1710496964, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (113, '102.222.4.116', 'Google Chrome', 'linux', 1710497023, 1710499115, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (114, '102.222.4.116', 'Google Chrome', 'linux', 1710497179, 1710497479, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (115, '102.222.4.116', 'Mozilla Firefox', 'linux', 1710497928, 1710502523, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (116, '102.222.4.116', 'Google Chrome', 'windows', 1710499145, 1710502776, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (117, '102.222.4.116', 'Google Chrome', 'linux', 1710499171, 1710499500, 2, 30);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (118, '102.222.4.116', 'Google Chrome', 'linux', 1710499680, 1710500445, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (119, '102.222.4.116', 'Google Chrome', 'linux', 1710500459, 1710500759, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (120, '102.222.4.116', 'Mozilla Firefox', 'linux', 1710502569, 1710502596, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (121, '102.222.4.116', 'Mozilla Firefox', 'linux', 1710502609, 1710502621, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (122, '102.222.4.116', 'Mozilla Firefox', 'linux', 1710502628, 1710502722, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (123, '102.222.4.116', 'Mozilla Firefox', 'linux', 1710502753, 1710503190, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (124, '102.222.4.116', 'Google Chrome', 'linux', 1710502796, 1710503096, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (125, '102.222.4.116', 'Mozilla Firefox', 'linux', 1710503201, 1710503417, 2, 28);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (126, '102.222.4.116', 'Mozilla Firefox', 'linux', 1710503420, 1710503428, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (127, '102.222.4.116', 'Mozilla Firefox', 'linux', 1710503436, 1710503818, 2, 28);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (128, '102.222.4.116', 'Mozilla Firefox', 'linux', 1710503822, 1710504122, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (129, '102.222.4.116', 'Google Chrome', 'windows', 1710504028, 1710506168, 2, 33);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (130, '102.222.4.116', 'Google Chrome', 'windows', 1710506182, 1710506224, 2, 33);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (131, '102.222.4.116', 'Google Chrome', 'windows', 1710506232, 1710506236, 2, 33);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (132, '102.222.4.116', 'Google Chrome', 'windows', 1710506398, 1710506594, 2, 33);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (133, '196.201.210.179', 'Google Chrome', 'linux', 1710506561, 1710506609, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (134, '102.222.4.116', 'Google Chrome', 'windows', 1710506618, 1710506697, 2, 28);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (135, '102.222.4.116', 'Google Chrome', 'windows', 1710506710, 1710506727, 2, 28);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (136, '102.222.4.116', 'Google Chrome', 'windows', 1710506776, 1710506835, 2, 33);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (137, '102.222.4.116', 'Mozilla Firefox', 'Unknown', 1710507132, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (138, '196.201.210.179', 'Google Chrome', 'linux', 1710507384, 1710507569, 9, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (139, '196.201.210.179', 'Google Chrome', 'linux', 1710507573, NULL, 9, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (140, '102.222.4.116', 'Google Chrome', 'windows', 1710509770, 1710510070, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (141, '102.222.4.116', 'Google Chrome', 'windows', 1710563097, 1710565011, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (142, '102.213.176.14', 'Mozilla Firefox', 'linux', 1710564099, 1710565618, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (143, '102.222.4.116', 'Google Chrome', 'windows', 1710565045, 1710565181, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (144, '102.222.4.116', 'Google Chrome', 'windows', 1710565195, 1710565495, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (145, '102.213.176.14', 'Mozilla Firefox', 'linux', 1710565626, 1710565926, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (146, '102.213.176.14', 'Mozilla Firefox', 'linux', 1710566860, 1710567481, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (147, '102.213.176.14', 'Mozilla Firefox', 'linux', 1710567738, 1710567776, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (148, '102.213.176.14', 'Mozilla Firefox', 'linux', 1710567951, 1710568251, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (149, '102.213.176.14', 'Mozilla Firefox', 'linux', 1710568418, 1710568718, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (150, '102.222.4.116', 'Google Chrome', 'linux', 1710577943, 1710578243, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (151, '102.213.176.14', 'Mozilla Firefox', 'linux', 1710581930, 1710582230, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (152, '102.222.4.116', 'Google Chrome', 'windows', 1710585546, 1710585846, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (153, '102.222.4.116', 'Google Chrome', 'windows', 1710585546, 1710746321, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (154, '105.164.143.31', 'Mozilla Firefox', 'linux', 1710684797, 1710685984, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (155, '105.164.143.31', 'Mozilla Firefox', 'linux', 1710685993, 1710686050, 2, 32);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (156, '105.164.143.31', 'Mozilla Firefox', 'linux', 1710686053, 1710686477, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (157, '105.164.143.31', 'Mozilla Firefox', 'linux', 1710686490, NULL, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (158, '105.161.89.250', 'Mozilla Firefox', 'linux', 1710700649, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (159, '102.222.4.116', 'Google Chrome', 'windows', 1710740933, 1710741233, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (160, '102.222.4.116', 'Google Chrome', 'windows', 1710741154, 1710741454, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (161, '102.222.4.116', 'Google Chrome', 'linux', 1710744202, 1710744502, 9, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (162, '102.222.4.116', 'Google Chrome', 'windows', 1710744471, 1710744771, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (163, '102.222.4.116', 'Google Chrome', 'windows', 1710746332, 1710746352, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (164, '102.222.4.116', 'Google Chrome', 'windows', 1710746363, 1710746663, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (165, '102.222.4.116', 'Google Chrome', 'windows', 1710758361, 1710758661, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (166, '102.222.4.116', 'Google Chrome', 'windows', 1710767380, 1710767680, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (167, '102.222.4.116', 'Google Chrome', 'linux', 1710821600, 1710821900, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (168, '102.222.4.116', 'Google Chrome', 'linux', 1710826923, 1710827223, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (169, '102.222.4.116', 'Google Chrome', 'linux', 1710830037, 1710830337, 9, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (170, '102.222.4.116', 'Google Chrome', 'windows', 1710831941, 1710832241, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (171, '102.222.4.116', 'Google Chrome', 'linux', 1710834099, 1710834399, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (172, '102.222.4.116', 'Google Chrome', 'windows', 1710835265, 1710835286, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (173, '102.222.4.116', 'Google Chrome', 'windows', 1710835290, 1710835590, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (174, '102.222.4.116', 'Google Chrome', 'windows', 1710838815, 1710839741, 5, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (175, '102.222.4.116', 'Google Chrome', 'windows', 1710839346, 1710839646, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (176, '154.159.252.5', 'Google Chrome', 'windows', 1710846113, 1710846413, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (177, '102.222.4.116', 'Google Chrome', 'linux', 1710847138, 1710847884, 9, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (178, '102.135.168.106', 'Mozilla Firefox', 'linux', 1710847224, 1710847524, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (179, '102.222.4.116', 'Google Chrome', 'linux', 1710847888, 1710848236, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (180, '102.222.4.116', 'Google Chrome', 'linux', 1710848242, 1710848542, 9, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (181, '102.135.168.106', 'Mozilla Firefox', 'linux', 1710855743, 1710855788, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (182, '102.135.168.106', 'Mozilla Firefox', 'linux', 1710855803, 1710856103, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (183, '102.135.168.106', 'Mozilla Firefox', 'linux', 1710857718, 1710860518, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (184, '102.135.168.106', 'Mozilla Firefox', 'linux', 1710860540, 1710860563, 2, 32);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (185, '102.135.168.106', 'Mozilla Firefox', 'linux', 1710860588, 1710861125, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (186, '102.135.168.106', 'Mozilla Firefox', 'linux', 1710861128, 1710862642, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (187, '154.159.252.5', 'Google Chrome', 'windows', 1710861481, 1710861781, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (188, '102.135.168.106', 'Mozilla Firefox', 'linux', 1710862691, 1710862991, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (189, '102.135.168.106', 'Mozilla Firefox', 'Unknown', 1710862766, 1710862994, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (190, '102.135.168.106', 'Mozilla Firefox', 'linux', 1710863056, NULL, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (191, '154.159.252.5', 'Google Chrome', 'windows', 1710868865, 1710869165, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (192, '102.222.4.116', 'Google Chrome', 'windows', 1710908344, 1710911414, 5, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (193, '154.159.252.5', 'Google Chrome', 'windows', 1710928396, 1710928696, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (194, '102.213.176.14', 'Mozilla Firefox', 'linux', 1710986530, 1710993611, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (195, '102.213.176.14', 'Mozilla Firefox', 'linux', 1710993620, 1710994503, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (196, '102.213.176.14', 'Mozilla Firefox', 'linux', 1710994518, 1710994818, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (197, '102.222.4.116', 'Google Chrome', 'linux', 1711035069, 1711035369, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (198, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711077007, 1711077307, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (199, '102.222.4.116', 'Google Chrome', 'linux', 1711083916, 1711084216, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (200, '102.222.4.116', 'Google Chrome', 'linux', 1711083917, 1711084217, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (201, '102.222.4.116', 'Google Chrome', 'windows', 1711092012, 1711092312, 5, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (202, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711093642, 1711093922, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (203, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711093933, 1711095019, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (204, '102.222.4.116', 'Google Chrome', 'linux', 1711096803, 1711097103, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (205, '154.159.252.5', 'Google Chrome', 'windows', 1711096911, 1711097211, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (206, '102.222.4.116', 'Google Chrome', 'windows', 1711098548, 1711098848, 2, 28);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (207, '154.159.252.5', 'Google Chrome', 'windows', 1711105709, 1711106009, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (208, '102.222.4.116', 'Google Chrome', 'windows', 1711113762, 1711115691, 5, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (209, '154.159.252.5', 'Google Chrome', 'windows', 1711121956, 1711122256, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (210, '154.159.252.5', 'Google Chrome', 'windows', 1711132448, 1711132748, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (211, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711141670, 1711141970, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (212, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711164789, 1711165089, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (213, '102.222.4.116', 'Google Chrome', 'linux', 1711169209, 1711169509, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (214, '102.222.4.116', 'Google Chrome', 'windows', 1711171806, 1711171840, 5, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (215, '102.222.4.116', 'Google Chrome', 'windows', 1711180230, NULL, 2, 28);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (216, '154.159.252.5', 'Google Chrome', 'windows', 1711186062, 1711186362, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (217, '102.222.4.116', 'Google Chrome', 'windows', 1711190052, 1711190352, 2, 33);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (218, '102.222.4.116', 'Google Chrome', 'windows', 1711190684, 1711190927, 2, 33);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (219, '102.222.4.116', 'Google Chrome', 'windows', 1711190931, 1711191231, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (220, '102.222.4.116', 'Google Chrome', 'linux', 1711192774, 1711193074, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (221, '154.159.252.5', 'Google Chrome', 'windows', 1711196056, 1711196356, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (222, '154.159.252.5', 'Google Chrome', 'windows', 1711204166, 1711204466, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (223, '41.215.120.114', 'Mozilla Firefox', 'linux', 1711204696, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (224, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711209996, 1711210296, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (225, '154.159.252.5', 'Google Chrome', 'windows', 1711215601, 1711215901, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (226, '102.222.4.116', 'Google Chrome', 'linux', 1711284552, 1711284852, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (227, '105.161.213.190', 'Google Chrome', 'linux', 1711292051, NULL, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (228, '102.222.4.116', 'Google Chrome', 'linux', 1711345550, 1711345850, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (229, '102.222.4.116', 'Google Chrome', 'linux', 1711345745, 1711346045, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (230, '102.222.4.116', 'Google Chrome', 'windows', 1711346359, 1711346546, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (231, '102.222.4.116', 'Google Chrome', 'windows', 1711346560, 1711346860, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (232, '102.222.4.116', 'Google Chrome', 'windows', 1711346889, 1711349659, 5, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (233, '102.222.4.116', 'Google Chrome', 'linux', 1711347495, 1711347795, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (234, '102.222.4.116', 'Google Chrome', 'windows', 1711350894, 1711352208, 5, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (235, '102.222.4.116', 'Google Chrome', 'windows', 1711357168, 1711357468, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (236, '102.222.4.116', 'Google Chrome', 'linux', 1711357298, 1711357598, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (237, '102.222.4.116', 'Google Chrome', 'windows', 1711358063, 1711358363, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (238, '102.222.4.116', 'Google Chrome', 'linux', 1711358712, 1711359012, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (239, '102.222.4.116', 'Google Chrome', 'linux', 1711359077, 1711359377, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (240, '102.222.4.116', 'Google Chrome', 'linux', 1711360834, 1711361134, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (241, '102.222.4.116', 'Google Chrome', 'windows', 1711372656, 1711372832, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (242, '102.222.4.116', 'Google Chrome', 'windows', 1711372841, 1711373141, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (243, '102.222.4.116', 'Google Chrome', 'linux', 1711437595, 1711437895, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (244, '102.222.4.116', 'Google Chrome', 'windows', 1711449475, 1711449621, 5, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (245, '102.222.4.116', 'Google Chrome', 'windows', 1711449682, 1711449982, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (246, '154.159.252.5', 'Google Chrome', 'windows', 1711458342, 1711458642, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (247, '102.222.4.116', 'Google Chrome', 'linux', 1711460734, 1711461034, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (248, '102.222.4.116', 'Google Chrome', 'linux', 1711515631, 1711515931, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (249, '154.159.254.158', 'Google Chrome', 'linux', 1711518018, NULL, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (250, '102.222.4.116', 'Google Chrome', 'windows', 1711522434, 1711527251, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (251, '154.159.252.5', 'Google Chrome', 'windows', 1711525337, 1711526155, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (252, '154.159.252.5', 'Google Chrome', 'windows', 1711526158, 1711526458, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (253, '102.222.4.116', 'Google Chrome', 'windows', 1711527261, 1711527561, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (254, '102.222.4.116', 'Google Chrome', 'linux', 1711527902, 1711528202, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (255, '102.222.4.116', 'Google Chrome', 'linux', 1711530216, 1711530516, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (256, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711532859, 1711536118, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (257, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711536122, 1711536422, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (258, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711536517, 1711543850, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (259, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711543867, 1711544069, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (260, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711544073, 1711544222, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (261, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711544233, 1711544255, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (262, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711544264, 1711545235, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (263, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711545245, 1711545641, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (264, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711545653, 1711546629, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (265, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711546633, 1711560927, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (266, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711560937, 1711560977, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (267, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711560982, 1711561064, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (268, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711561068, 1711567494, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (269, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711567499, 1711567526, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (270, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711567539, 1711570365, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (271, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711570370, 1711570423, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (272, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711570428, 1711570464, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (273, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711570475, 1711571431, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (274, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711571449, 1711571621, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (275, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711571625, 1711573867, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (276, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711573872, 1711575911, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (277, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711575915, 1711575923, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (278, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711575936, 1711575945, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (279, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711575954, 1711576839, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (280, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711576842, 1711577019, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (281, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711577027, 1711577785, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (282, '154.159.252.5', 'Google Chrome', 'windows', 1711577152, 1711577750, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (283, '154.159.252.5', 'Google Chrome', 'windows', 1711577754, 1711578054, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (284, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711577789, 1711579706, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (285, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711579711, 1711579718, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (286, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711579732, 1711582280, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (287, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711582284, 1711582840, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (288, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711582851, 1711583151, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (289, '102.222.4.116', 'Google Chrome', 'windows', 1711599773, 1711607419, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (290, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711601601, 1711602593, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (291, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711602603, 1711602687, 9, 13);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (292, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711602695, 1711602875, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (293, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711602884, 1711603070, 9, 13);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (294, '102.213.176.14', 'Mozilla Firefox', 'Unknown', 1711603021, 1711603321, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (295, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711603074, 1711603225, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (296, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711603235, 1711603263, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (297, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711603272, 1711603287, 2, 29);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (298, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711603291, 1711603312, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (299, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711603337, 1711603354, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (300, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711603363, 1711603395, 2, 34);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (301, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711603400, 1711604253, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (302, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711604271, 1711608383, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (303, '102.222.4.116', 'Google Chrome', 'windows', 1711607472, 1711608782, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (304, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711608388, 1711611926, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (305, '102.222.4.116', 'Google Chrome', 'windows', 1711608841, 1711609141, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (306, '102.222.4.116', 'Google Chrome', 'linux', 1711610809, 1711611405, 3, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (307, '154.159.252.5', 'Google Chrome', 'windows', 1711611424, 1711611673, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (308, '154.159.252.5', 'Google Chrome', 'windows', 1711611681, 1711611981, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (309, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711611931, 1711611947, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (310, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711612001, 1711612171, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (311, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711612176, 1711612489, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (312, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711612497, 1711612797, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (313, '102.213.176.14', 'Mozilla Firefox', 'Unknown', 1711612961, 1711612975, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (314, '102.213.176.14', 'Mozilla Firefox', 'Unknown', 1711612985, 1711613557, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (315, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711613561, 1711619412, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (316, '105.161.107.254', 'Google Chrome', 'linux', 1711616169, NULL, 3, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (317, '102.222.4.116', 'Google Chrome', 'windows', 1711616713, NULL, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (318, '102.222.4.116', 'Google Chrome', 'windows', 1711618473, 1711619310, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (319, '102.222.4.116', 'Google Chrome', 'linux', 1711618572, 1711618872, 9, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (320, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711619421, 1711619440, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (321, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711619451, 1711619837, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (322, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711619841, 1711620723, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (323, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711620726, 1711624864, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (324, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711624871, 1711624944, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (325, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711624953, 1711628238, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (326, '209.222.101.90', 'Google Chrome', 'windows', 1711625061, NULL, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (327, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711628247, 1711628928, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (328, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711628932, 1711628938, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (329, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711628948, 1711629248, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (330, '102.213.176.14', 'Mozilla Firefox', 'Unknown', 1711629174, 1711629605, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (331, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711629609, 1711630780, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (332, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711630788, 1711631088, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (333, '154.159.252.5', 'Google Chrome', 'windows', 1711663624, 1711663924, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (334, '102.222.4.116', 'Google Chrome', 'windows', 1711691292, 1711691433, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (335, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711692468, 1711692619, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (336, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711692625, 1711693013, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (337, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711693017, 1711693317, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (338, '102.213.176.14', 'Mozilla Firefox', 'Unknown', 1711696907, 1711696960, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (339, '102.213.176.14', 'Mozilla Firefox', 'Unknown', 1711696982, 1711697282, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (340, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711772665, 1711773376, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (341, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711773383, 1711775851, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (342, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711775877, 1711776177, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (343, '102.213.176.14', 'Mozilla Firefox', 'linux', 1711954322, 1711954622, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (344, '102.213.176.14', 'Mozilla Firefox', 'linux', 1712030911, 1712031211, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (345, '196.101.169.149', 'Google Chrome', 'linux', 1712033263, NULL, 3, 34);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (346, '105.160.121.140', 'Google Chrome', 'windows', 1712041011, 1712041311, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (347, '154.159.252.5', 'Google Chrome', 'windows', 1712042080, NULL, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (348, '105.160.121.140', 'Google Chrome', 'linux', 1712043925, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (349, '102.222.4.116', 'Google Chrome', 'windows', 1712135876, 1712136176, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (350, '102.222.4.116', 'Google Chrome', 'windows', 1712227074, 1712227374, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (351, '154.159.252.5', 'Google Chrome', 'windows', 1712237867, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (352, '102.222.4.116', 'Google Chrome', 'windows', 1712300499, NULL, 2, 33);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (353, '154.159.254.112', 'Google Chrome', 'linux', 1712741633, NULL, 3, 34);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (354, '102.22.152.135', 'Google Chrome', 'linux', 1712745691, NULL, 3, 34);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (355, '102.222.4.116', 'Google Chrome', 'linux', 1713090686, 1713090725, 9, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (356, '197.254.77.166', 'Mozilla Firefox', 'linux', 1713164375, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (357, '102.222.4.116', 'Google Chrome', 'windows', 1713332312, 1713332608, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (358, '102.213.176.14', 'Mozilla Firefox', 'linux', 1713332541, 1713332841, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (359, '102.222.4.116', 'Google Chrome', 'windows', 1713332739, 1713333039, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (360, '102.222.4.116', 'Google Chrome', 'windows', 1713505771, 1713506071, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (361, '154.159.254.17', 'Google Chrome', 'linux', 1713620163, NULL, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (362, '105.160.47.245', 'Mozilla Firefox', 'linux', 1713950561, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (363, '154.159.254.245', 'Google Chrome', 'linux', 1714045953, NULL, 9, 12);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (364, '154.159.254.218', 'Google Chrome', 'linux', 1714045989, NULL, 2, 28);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (365, '102.213.176.14', 'Mozilla Firefox', 'linux', 1714193349, 1714193649, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (366, '102.213.176.14', 'Mozilla Firefox', 'linux', 1714281477, 1714281777, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (367, '102.222.4.116', 'Google Chrome', 'windows', 1714377815, 1714381926, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (368, '102.222.4.116', 'Google Chrome', 'windows', 1714395245, 1714399109, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (369, '102.222.4.116', 'Google Chrome', 'windows', 1714480820, 1714481120, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (370, '102.213.176.14', 'Mozilla Firefox', 'linux', 1714483935, 1714484235, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (371, '102.222.4.116', 'Google Chrome', 'windows', 1714640596, 1714647865, 5, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (372, '102.222.4.116', 'Google Chrome', 'windows', 1714647882, 1714648234, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (373, '102.222.4.116', 'Google Chrome', 'windows', 1714648271, 1714648282, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (374, '102.213.176.34', 'Google Chrome', 'windows', 1714974869, 1714975169, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (375, '102.213.176.34', 'Google Chrome', 'windows', 1714983070, 1714983648, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (376, '102.213.176.34', 'Google Chrome', 'linux', 1715107410, 1715107710, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (377, '102.222.4.116', 'Google Chrome', 'windows', 1715246382, 1715246682, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (378, '41.81.223.77', 'Mozilla Firefox', 'Unknown', 1715246563, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (379, '102.222.4.116', 'Google Chrome', 'windows', 1715249373, 1715249673, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (380, '197.231.180.85', 'Mozilla Firefox', 'Unknown', 1715250558, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (381, '41.212.49.100', 'Google Chrome', 'windows', 1715251022, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (382, '102.213.176.34', 'Google Chrome', 'windows', 1715282841, 1715283141, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (383, '102.213.176.34', 'Google Chrome', 'windows', 1715321330, 1715321630, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (384, '102.213.176.34', 'Google Chrome', 'windows', 1715356161, 1715356461, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (385, '102.213.176.34', 'Google Chrome', 'windows', 1715371447, 1715371747, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (386, '102.213.176.34', 'Google Chrome', 'windows', 1715374302, 1715374602, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (387, '102.213.176.34', 'Google Chrome', 'windows', 1715374302, 1715374602, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (388, '102.213.176.34', 'Google Chrome', 'windows', 1715375388, 1715375688, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (389, '102.213.176.34', 'Google Chrome', 'windows', 1715378268, 1715378568, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (390, '102.213.176.34', 'Google Chrome', 'windows', 1715454307, 1715454607, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (391, '102.213.176.34', 'Google Chrome', 'windows', 1715456633, 1715456933, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (392, '102.213.176.34', 'Google Chrome', 'windows', 1715536292, NULL, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (393, '102.222.4.116', 'Google Chrome', 'windows', 1715581011, 1715581311, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (394, '197.232.133.21', 'Mozilla Firefox', 'linux', 1715596351, 1715596437, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (395, '197.232.133.21', 'Mozilla Firefox', 'linux', 1715596442, 1715596458, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (396, '197.232.133.21', 'Mozilla Firefox', 'linux', 1715596489, 1715597435, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (397, '102.222.4.116', 'Google Chrome', 'windows', 1715662700, 1715663000, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (398, '102.222.4.116', 'Google Chrome', 'windows', 1715754157, 1715754457, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (399, '102.222.4.116', 'Google Chrome', 'windows', 1715835828, 1715836128, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (400, '102.222.4.116', 'Google Chrome', 'linux', 1715835884, 1715836184, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (401, '102.222.4.116', 'Google Chrome', 'linux', 1715845579, 1715845879, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (402, '102.222.4.116', 'Google Chrome', 'windows', 1715848459, 1715848759, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (403, '102.222.4.116', 'Google Chrome', 'windows', 1715922199, 1715922499, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (404, '102.222.4.116', 'Google Chrome', 'windows', 1716005707, 1716006007, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (405, '102.222.4.116', 'Google Chrome', 'windows', 1716019700, 1716020000, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (406, '102.222.4.116', 'Google Chrome', 'linux', 1716019860, 1716020160, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (407, '197.248.115.175', 'Mozilla Firefox', 'linux', 1716020762, 1716021062, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (408, '102.222.4.116', 'Google Chrome', 'windows', 1716179341, 1716179641, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (409, '102.222.4.116', 'Google Chrome', 'windows', 1716194844, 1716195144, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (410, '102.222.4.116', 'Google Chrome', 'windows', 1716270510, 1716270810, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (411, '102.222.4.116', 'Google Chrome', 'windows', 1716795887, 1716796973, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (412, '102.222.4.116', 'Google Chrome', 'windows', 1716797297, 1716797391, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (413, '102.222.4.116', 'Google Chrome', 'windows', 1716797412, 1716807344, 5, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (414, '102.222.4.116', 'Google Chrome', 'windows', 1716798404, 1716798704, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (415, '102.222.4.116', 'Google Chrome', 'windows', 1716807511, 1716807561, 5, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (416, '102.222.4.116', 'Google Chrome', 'windows', 1716810143, 1716811824, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (417, '105.160.75.215', 'Mozilla Firefox', 'linux', 1716975680, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (418, '102.222.4.116', 'Google Chrome', 'windows', 1717050081, 1717050381, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (419, '105.160.101.2', 'Mozilla Firefox', 'linux', 1717050163, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (420, '197.232.133.21', 'Mozilla Firefox', 'linux', 1717081367, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (421, '105.163.46.250', 'Mozilla Firefox', 'linux', 1717135842, 1717135910, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (422, '105.163.46.250', 'Mozilla Firefox', 'linux', 1717135914, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (423, '105.161.4.221', 'Mozilla Firefox', 'linux', 1717174497, NULL, 3, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (424, '62.24.116.41', 'Google Chrome', 'windows', 1717391909, 1717392209, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (425, '41.81.179.189', 'Mozilla Firefox', 'Unknown', 1717402980, 1717403280, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (426, '102.222.4.116', 'Google Chrome', 'windows', 1717403042, 1717405988, 5, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (427, '102.222.4.116', 'Google Chrome', 'windows', 1717406016, NULL, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (428, '41.81.179.189', 'Mozilla Firefox', 'linux', 1717408638, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (429, '102.213.176.34', 'Google Chrome', 'linux', 1717437214, NULL, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (430, '102.222.4.116', 'Google Chrome', 'windows', 1717473076, 1717473376, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (431, '102.222.4.116', 'Google Chrome', 'linux', 1717473516, 1717473816, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (432, '102.222.4.116', 'Google Chrome', 'windows', 1717498205, 1717501172, 5, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (433, '102.222.4.116', 'Google Chrome', 'windows', 1717502087, 1717502134, 5, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (434, '102.222.4.116', 'Google Chrome', 'linux', 1717509247, NULL, 12, 11);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (435, '102.222.4.116', 'Google Chrome', 'linux', 1717509779, 1717510079, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (436, '102.222.4.116', 'Google Chrome', 'linux', 1717559308, 1717559608, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (437, '102.222.4.116', 'Google Chrome', 'linux', 1717576897, 1717577197, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (438, '102.222.4.116', 'Google Chrome', 'linux', 1717591395, 1717591695, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (439, '102.222.4.116', 'Google Chrome', 'linux', 1717646053, 1717646353, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (440, '102.222.4.116', 'Google Chrome', 'windows', 1717653005, 1717653305, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (441, '197.248.115.175', 'Mozilla Firefox', 'linux', 1717660068, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (442, '62.24.116.41', 'Google Chrome', 'windows', 1717680548, 1717680848, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (443, '62.24.116.41', 'Google Chrome', 'windows', 1717680554, 1717681717, 1, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (444, '62.24.116.41', 'Google Chrome', 'windows', 1717682385, NULL, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (445, '154.159.254.200', 'Google Chrome', 'linux', 1717683736, 1717684036, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (446, '154.159.254.200', 'Google Chrome', 'linux', 1717732430, NULL, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (447, '102.222.4.116', 'Google Chrome', 'windows', 1717744945, 1717745245, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (448, '102.222.4.116', 'Google Chrome', 'linux', 1717750177, 1717750477, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (449, '102.222.4.116', 'Google Chrome', 'windows', 1717753395, 1717755035, 5, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (450, '102.222.4.116', 'Google Chrome', 'linux', 1717758197, 1717758497, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (451, '102.222.4.116', 'Google Chrome', 'linux', 1717758202, 1717758502, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (452, '102.222.4.116', 'Google Chrome', 'linux', 1717768915, 1717769215, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (453, '102.222.4.116', 'Google Chrome', 'linux', 1717824085, 1717824385, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (454, '102.222.4.116', 'Google Chrome', 'linux', 1717840622, NULL, 7, 10);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (455, '102.213.176.14', 'Mozilla Firefox', 'linux', 1717872322, 1717872622, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (456, '102.213.176.14', 'Mozilla Firefox', 'linux', 1717902474, 1717902774, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (457, '105.160.1.44', 'Mozilla Firefox', 'linux', 1718000682, 1718000982, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (458, '105.160.1.44', 'Mozilla Firefox', 'Unknown', 1718000771, 1718001071, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (459, '105.160.1.44', 'Mozilla Firefox', 'linux', 1718010259, 1718010559, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (460, '105.160.1.44', 'Mozilla Firefox', 'Unknown', 1718011979, 1718012279, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (461, '105.160.1.44', 'Mozilla Firefox', 'linux', 1718103429, 1718103729, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (462, '105.160.1.44', 'Mozilla Firefox', 'Unknown', 1718107436, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (463, '102.213.176.14', 'Mozilla Firefox', 'linux', 1718200096, 1718200396, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (464, '102.213.176.14', 'Mozilla Firefox', 'linux', 1718211754, 1718212054, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (465, '102.213.176.14', 'Mozilla Firefox', 'Unknown', 1718212700, 1718213000, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (466, '102.213.176.14', 'Mozilla Firefox', 'Unknown', 1718215866, 1718216166, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (467, '102.213.176.14', 'Google Chrome', 'linux', 1718216012, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (468, '41.90.42.205', 'Mozilla Firefox', 'linux', 1718267624, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (469, '105.161.170.239', 'Mozilla Firefox', 'windows', 1718283215, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (470, '105.161.205.194', 'Mozilla Firefox', 'Unknown', 1718284019, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (471, '102.213.176.14', 'Mozilla Firefox', 'linux', 1718334444, 1718334744, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (472, '41.90.34.148', 'Mozilla Firefox', 'linux', 1718339927, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (473, '196.96.117.203', 'Mozilla Firefox', 'windows', 1718375860, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (474, '196.96.76.195', 'Mozilla Firefox', 'windows', 1718454973, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (475, '105.161.27.20', 'Mozilla Firefox', 'Unknown', 1718455956, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (476, '196.96.67.145', 'Mozilla Firefox', 'linux', 1718529558, 1718529858, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (477, '196.96.67.145', 'Mozilla Firefox', 'Unknown', 1718537234, 1718537534, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (478, '196.96.67.145', 'Mozilla Firefox', 'Unknown', 1718544796, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (479, '196.96.118.214', 'Google Chrome', 'linux', 1718546136, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (480, '196.96.118.214', 'Mozilla Firefox', 'linux', 1718546261, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (481, '102.222.145.106', 'Google Chrome', 'linux', 1718618667, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (482, '105.160.125.212', 'Mozilla Firefox', 'windows', 1718618930, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (483, '105.161.35.117', 'Mozilla Firefox', 'linux', 1718689004, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (484, '105.161.35.117', 'Google Chrome', 'linux', 1718693534, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (485, '105.161.146.83', 'Mozilla Firefox', 'linux', 1718795205, NULL, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (486, '102.213.176.14', 'Mozilla Firefox', 'linux', 1718817531, 1718819780, 1, 1);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (487, '102.213.176.14', 'Mozilla Firefox', 'linux', 1718819787, 1718820047, 3, 2);
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES (488, '102.213.176.14', 'Mozilla Firefox', 'linux', 1718820049, NULL, 1, 1);


#
# TABLE STRUCTURE FOR: lunch_setting
#

DROP TABLE IF EXISTS `lunch_setting`;

CREATE TABLE `lunch_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `break` double(10,2) NOT NULL,
  `lunch` double(10,2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `lunch_setting` (`id`, `break`, `lunch`) VALUES (1, '70.00', '40.00');


#
# TABLE STRUCTURE FOR: lunchlogs
#

DROP TABLE IF EXISTS `lunchlogs`;

CREATE TABLE `lunchlogs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `amount` double(10,2) DEFAULT NULL,
  `studentID` int(11) DEFAULT NULL,
  `schoolyearID` int(11) NOT NULL DEFAULT '3',
  `type` varchar(20) DEFAULT NULL,
  `referenceno` varchar(20) DEFAULT NULL,
  `time` time DEFAULT NULL,
  `date` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

INSERT INTO `lunchlogs` (`id`, `amount`, `studentID`, `schoolyearID`, `type`, `referenceno`, `time`, `date`) VALUES (1, '30.00', 18, 4, 'break', 'PJRNP6QSHFO1', '12:35:11', '2024-06-10 12:35:11');
INSERT INTO `lunchlogs` (`id`, `amount`, `studentID`, `schoolyearID`, `type`, `referenceno`, `time`, `date`) VALUES (2, '60.00', 18, 4, 'lunch', 'O1C955NJ9HUQ', '12:35:20', '2024-06-10 12:35:20');
INSERT INTO `lunchlogs` (`id`, `amount`, `studentID`, `schoolyearID`, `type`, `referenceno`, `time`, `date`) VALUES (3, '30.00', 54, 4, 'break', 'S1FX6YPYFNEH', '14:27:46', '2024-06-16 14:27:46');
INSERT INTO `lunchlogs` (`id`, `amount`, `studentID`, `schoolyearID`, `type`, `referenceno`, `time`, `date`) VALUES (4, '30.00', 54, 4, 'break', '2BG4DMGXTENR', '14:28:39', '2024-06-16 14:28:39');
INSERT INTO `lunchlogs` (`id`, `amount`, `studentID`, `schoolyearID`, `type`, `referenceno`, `time`, `date`) VALUES (5, '60.00', 54, 4, 'lunch', '2S1MPZO8JXP1', '14:35:01', '2024-06-16 14:35:01');
INSERT INTO `lunchlogs` (`id`, `amount`, `studentID`, `schoolyearID`, `type`, `referenceno`, `time`, `date`) VALUES (6, '200.00', 54, 4, 'lunch', '5Z23RV8FUGEY', '14:41:41', '2024-06-16 14:41:41');
INSERT INTO `lunchlogs` (`id`, `amount`, `studentID`, `schoolyearID`, `type`, `referenceno`, `time`, `date`) VALUES (7, '60.00', 54, 4, 'break', 'EACOA7XP7X7F', '16:15:42', '2024-06-16 16:15:42');
INSERT INTO `lunchlogs` (`id`, `amount`, `studentID`, `schoolyearID`, `type`, `referenceno`, `time`, `date`) VALUES (8, '100.00', 54, 4, 'lunch', 'DSQKXZR84MZ6', '16:15:55', '2024-06-16 16:15:55');
INSERT INTO `lunchlogs` (`id`, `amount`, `studentID`, `schoolyearID`, `type`, `referenceno`, `time`, `date`) VALUES (9, '200.00', 54, 4, 'lunch', 'BOKD3UT9AMTM', '16:21:24', '2024-06-16 16:21:24');


#
# TABLE STRUCTURE FOR: mailandsms
#

DROP TABLE IF EXISTS `mailandsms`;

CREATE TABLE `mailandsms` (
  `mailandsmsID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `usertypeID` int(11) NOT NULL,
  `users` text NOT NULL,
  `type` varchar(16) NOT NULL,
  `senderusertypeID` int(11) NOT NULL,
  `senderID` int(11) NOT NULL,
  `message` text NOT NULL,
  `create_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `year` year(4) NOT NULL,
  PRIMARY KEY (`mailandsmsID`)
) ENGINE=InnoDB AUTO_INCREMENT=232 DEFAULT CHARSET=utf8;

INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (1, 0, 'SANDRA NASIKE', 'Automated', 1, 1, 'Dear Guardian, the account for SANDRA NASIKE , ADM 034 has been credited with 5000 at 13:47:01 on 10/04/2024. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-04-10 10:47:01', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (2, 3, 'JULIE SAGA HANS ,BLESSING LUYAI ,MICHAEL FREDRICK ,N’NJEMA ISABEL ,ALI WASILWA PAKIA ,ISSA HAMAD ,ALMASI MALAU ,BRIAN KIOKO ,LINDA MAUA ,', 'Sms', 1, 1, 'Testing', '2024-05-09 09:35:28', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (3, 0, 'JULIE SAGA HANS', 'Automated', 1, 1, 'Dear Guardian, your child JULIE SAGA HANS adm 001 has checked in at school at 12:53:28 on 09/05/2024 . Thanks', '2024-05-09 09:53:28', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (4, 0, 'JULIE SAGA HANS', 'Automated', 1, 0, ' Dear Guardian, the fee balance for JULIE SAGA HANS, ADM 001  is kes. 67000. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-05-09 10:16:37', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (5, 0, 'JULIE SAGA HANS', 'Automated', 1, 1, 'Dear Guardian, your child JULIE SAGA HANS adm 001 has checked in at school at 13:22:24 on 09/05/2024 . Thanks', '2024-05-09 10:22:25', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (6, 0, 'JULIE SAGA HANS', 'Automated', 1, 1, 'Dear Guardian,  your child JULIE SAGA HANS adm 001 has checked out of school at 13:22:28 on 09/05/2024Thanks', '2024-05-09 10:22:29', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (7, 0, 'JULIE SAGA HANS', 'Automated', 1, 0, ' Dear Guardian, the fee balance for JULIE SAGA HANS, ADM 001  is kes. 67000. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-05-09 10:23:12', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (8, 0, 'JULIE SAGA HANS', 'Automated', 1, 1, 'Dear Guardian, your child JULIE SAGA HANS adm 001 has checked in at school at 13:25:32 on 09/05/2024 . Thanks', '2024-05-09 10:25:32', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (9, 0, 'JULIE SAGA HANS', 'Automated', 1, 1, 'Dear Guardian,  your child JULIE SAGA HANS adm 001 has checked out of school at 13:25:42 on 09/05/2024Thanks', '2024-05-09 10:25:42', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (10, 0, 'JULIE SAGA HANS', 'Automated', 1, 0, 'Dear Guardian, your child JULIE SAGA HANS adm 001 has checked in at school at 13:30:05 on 09/05/2024 . Powered by Skooly. ', '2024-05-09 10:30:05', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (11, 0, 'JULIE SAGA HANS', 'Automated', 1, 0, 'Dear Guardian,  your child JULIE SAGA HANS adm 1 has checked out of school at 13:30:21 on 09/05/2024. Powered by Skooly.', '2024-05-09 10:30:22', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (12, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:41:39', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (13, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:41:40', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (14, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:41:42', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (15, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:41:43', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (16, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:41:44', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (17, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:41:45', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (18, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:41:46', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (19, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:41:47', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (20, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:41:49', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (21, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:41:50', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (22, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:41:51', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (23, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:41:52', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (24, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:41:53', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (25, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:41:55', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (26, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:41:56', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (27, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:41:57', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (28, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:41:58', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (29, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:41:59', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (30, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:42:00', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (31, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:42:02', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (32, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:42:03', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (33, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:42:04', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (34, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:42:05', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (35, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:42:07', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (36, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:42:08', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (37, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:42:09', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (38, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:42:11', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (39, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:42:12', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (40, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:42:13', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (41, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:42:15', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (42, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:42:16', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (43, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:42:17', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (44, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:42:18', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (45, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:42:19', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (46, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:42:20', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (47, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:42:22', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (48, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:42:23', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (49, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:42:24', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (50, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:42:25', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (51, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:42:26', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (52, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:42:27', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (53, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:42:28', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (54, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:42:30', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (55, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:42:31', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (56, 0, '', 'Automated', 1, 0, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:42:32', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (57, 3, 'JULIE SAGA HANS ,SALIM. N. MWAKIKOI ,EMMANUEL MWANGI ,BLESSING LUYAI ,LIAM KIRUHI KAMWERU ,ESTHER MUENI ,JUMA SWALEH ,MARYLNE NJOKI ,MICHAEL FREDRICK ,N’NJEMA ISABEL ,YUSUF MWINYI ,ALI WASILWA PAKIA ,RICHARD MSOMI ,ISSA HAMAD ,ALI SAID ,RANDANI KASSIM ,ALMASI MALAU ,BRIAN KIOKO ,ZAINAB SALIM ,DELPHINE KHALAI ,ISAACK MULEI ,YOHANN’S MUGO ,TYRESE KITHUNGA ,YVONNE KAMENE ,WENDY NDUKU ,CHELSEA JULIA ,SHAUN MATHEKA ,ASHLEY NELIMA ,VANESSA WANGU ,OPRAH WANGARE ,ROBIN  BAYA EDWIN MISTANZE ,LIONELL KADIEDA ,SANDRA NASIKE ,LOUIS KITSAO ,FORTUNE KAITHYA ,KHADIJA JUMA ,ADELIGHT FURAHA ,SASHA PEARL ,SEMIGIL KOOME ,SULEIMANABDALLAH ,BENJAMIN\nMUTHOMI ,KHERI MWANGAZA ,ISMAILMGANDI ,LISSY IVY ,LINDA MAUA ,LATIFFA BRIGIT MATASA ,RAINER KIMILU ,', 'Sms', 1, 2, 'Good afternoon dear parents and guardians.\r\nWe thank God for his grace that has been sufficient to all of us .\r\nKindly note the following:\r\n1. We shall open school on Monday 13/05/24. Day scholars will be picked by the bus at the usual time.Boarders to be in school by 10:00 am\r\n2. School fees to be paid in advance to avoid inconveniences.\r\n3. Learners to carry their school ID\'s ,assessment books and holiday assignment.\r\n4. Check on their uniform and fix any loose or missing buttons. If possible  get them an umbrella,especially boarders.\r\n\r\nThanks in advance\r\nAveon schools', '2024-05-09 10:42:32', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (58, 0, 'MARYLNE NJOKI', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 67000 for MARYLNE NJOKI, ADM 008 has been processed successfuly at 11:44:36 on 27/05/2024. Your fee balance is kes. 0. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-05-27 08:44:36', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (59, 0, 'YUSUF MWINYI', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 30000 for YUSUF MWINYI, ADM 012 has been processed successfuly at 11:49:31 on 27/05/2024. Your fee balance is kes. 32000. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-05-27 08:49:32', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (60, 0, 'RICHARD MSOMI', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 35000 for RICHARD MSOMI, ADM 014 has been processed successfuly at 11:54:31 on 27/05/2024. Your fee balance is kes. 32000. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-05-27 08:54:32', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (61, 0, 'RANDANI KASSIM', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 35000 for RANDANI KASSIM, ADM 017 has been processed successfuly at 11:56:26 on 27/05/2024. Your fee balance is kes. 3500. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-05-27 08:56:26', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (62, 0, 'DELPHINE KHALAI', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 30000 for DELPHINE KHALAI, ADM 021 has been processed successfuly at 12:22:43 on 27/05/2024. Your fee balance is kes. 32000. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-05-27 09:22:44', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (63, 0, 'ISAACK MULEI', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 15000 for ISAACK MULEI, ADM 022 has been processed successfuly at 12:23:37 on 27/05/2024. Your fee balance is kes. 27000. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-05-27 09:23:38', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (64, 0, 'YOHANN’S MUGO', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 67000 for YOHANN’S MUGO, ADM 023 has been processed successfuly at 12:24:51 on 27/05/2024. Your fee balance is kes. 0. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-05-27 09:24:52', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (65, 0, 'CHELSEA JULIA', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 42000 for CHELSEA JULIA, ADM 027 has been processed successfuly at 12:30:32 on 27/05/2024. Your fee balance is kes. 0. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-05-27 09:30:33', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (66, 0, 'SHAUN MATHEKA', 'Automated', 1, 0, 'Dear Guardian, a correction  has been made on the previous school fees invoice for SHAUN MATHEKA ADM 028. Your new fee balancee effective from 12:34:08 27/05/2024 is kes. 75500. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-05-27 09:34:09', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (67, 0, 'VANESSA WANGU', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 12000 for VANESSA WANGU, ADM 030 has been processed successfuly at 12:34:52 on 27/05/2024. Your fee balance is kes. 0. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-05-27 09:34:53', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (68, 0, 'SANDRA NASIKE', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 12000 for SANDRA NASIKE, ADM 034 has been processed successfuly at 12:36:12 on 27/05/2024. Your fee balance is kes. 25000. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-05-27 09:36:13', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (69, 0, 'FORTUNE KAITHYA', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 55000 for FORTUNE KAITHYA, ADM 036 has been processed successfuly at 12:37:59 on 27/05/2024. Your fee balance is kes. 12000. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-05-27 09:38:00', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (70, 0, 'KHADIJA JUMA', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 41700 for KHADIJA JUMA, ADM 037 has been processed successfuly at 12:41:01 on 27/05/2024. Your fee balance is kes. 41300. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-05-27 09:41:02', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (71, 0, 'LATIFFA BRIGIT MATASA', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 35500 for LATIFFA BRIGIT MATASA, ADM 047 has been processed successfuly at 12:45:41 on 27/05/2024. Your fee balance is kes. 22000. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-05-27 09:45:42', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (72, 0, 'ZAINAB SALIM', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 15000 for ZAINAB SALIM, ADM 020 has been processed successfuly at 12:53:14 on 27/05/2024. Your fee balance is kes. 22000. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-05-27 09:53:14', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (73, 0, 'YVONNE KAMENE', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 30000 for YVONNE KAMENE, ADM 025 has been processed successfuly at 12:55:01 on 27/05/2024. Your fee balance is kes. 37000. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-05-27 09:55:02', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (74, 0, 'ASHLEY NELIMA', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 30000 for ASHLEY NELIMA, ADM 029 has been processed successfuly at 12:55:58 on 27/05/2024. Your fee balance is kes. 32000. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-05-27 09:55:58', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (75, 0, 'OPRAH WANGARE', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 20000 for OPRAH WANGARE, ADM 031 has been processed successfuly at 12:56:46 on 27/05/2024. Your fee balance is kes. 22000. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-05-27 09:56:46', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (76, 0, 'LOUIS KITSAO', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 17000 for LOUIS KITSAO, ADM 035 has been processed successfuly at 12:59:22 on 27/05/2024. Your fee balance is kes. 25000. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-05-27 09:59:23', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (77, 0, 'ADELIGHT FURAHA', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 30000 for ADELIGHT FURAHA, ADM 038 has been processed successfuly at 13:00:21 on 27/05/2024. Your fee balance is kes. 12000. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-05-27 10:00:22', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (78, 0, 'SEMIGIL KOOME', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 28000 for SEMIGIL KOOME, ADM 040 has been processed successfuly at 13:03:28 on 27/05/2024. Your fee balance is kes. 39000. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-05-27 10:03:29', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (79, 0, 'SULEIMANABDALLAH', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 8000 for SULEIMANABDALLAH, ADM 041 has been processed successfuly at 13:08:58 on 27/05/2024. Your fee balance is kes. 54900. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-05-27 10:08:58', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (80, 0, 'KHERI MWANGAZA', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 10000 for KHERI MWANGAZA, ADM 043 has been processed successfuly at 13:11:19 on 27/05/2024. Your fee balance is kes. 54000. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-05-27 10:11:19', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (81, 0, 'LISSY IVY', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 20000 for LISSY IVY, ADM 045 has been processed successfuly at 13:12:22 on 27/05/2024. Your fee balance is kes. 47000. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-05-27 10:12:23', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (82, 0, 'ALI WASILWA PAKIA', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 21000 for ALI WASILWA PAKIA, ADM 013 has been processed successfuly at 13:15:13 on 27/05/2024. Your fee balance is kes. 22000. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-05-27 10:15:13', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (83, 0, 'ISSA HAMAD', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 40000 for ISSA HAMAD, ADM 015 has been processed successfuly at 13:16:35 on 27/05/2024. Your fee balance is kes. 2000. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-05-27 10:16:35', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (84, 0, 'BRIAN KIOKO', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 25000 for BRIAN KIOKO, ADM 019 has been processed successfuly at 13:18:25 on 27/05/2024. Your fee balance is kes. 17000. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-05-27 10:18:26', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (85, 0, 'ALMASI MALAU', 'Automated', 1, 0, 'Dear Guardian, a correction  has been made on the previous school fees invoice for ALMASI MALAU ADM 018. Your new fee balancee effective from 13:29:14 27/05/2024 is kes. 62000. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-05-27 10:29:15', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (86, 0, 'ALMASI MALAU', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 42000 for ALMASI MALAU, ADM 018 has been processed successfuly at 13:32:27 on 27/05/2024. Your fee balance is kes. 20000. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-05-27 10:32:28', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (87, 0, 'JULIE SAGA HANS', 'Automated', 1, 0, 'Dear Guardian, a correction  has been made on the previous school fees invoice for JULIE SAGA HANS ADM 001. Your new fee balancee effective from 13:33:25 27/05/2024 is kes. 67000. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-05-27 10:33:26', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (88, 0, 'JULIE SAGA HANS', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 5000 for JULIE SAGA HANS, ADM 001 has been processed successfuly at 13:33:49 on 27/05/2024. Your fee balance is kes. 62000. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-05-27 10:33:50', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (89, 0, 'N’NJEMA ISABEL', 'Automated', 1, 0, 'Dear Guardian, a correction  has been made on the previous school fees invoice for N’NJEMA ISABEL ADM 011. Your new fee balancee effective from 13:39:02 27/05/2024 is kes. 64000. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-05-27 10:39:02', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (90, 0, 'N’NJEMA ISABEL', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 45000 for N’NJEMA ISABEL, ADM 011 has been processed successfuly at 13:40:51 on 27/05/2024. Your fee balance is kes. 19000. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-05-27 10:40:52', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (91, 0, 'BENJAMIN\nMUTHOMI', 'Automated', 1, 0, 'Dear Guardian, a correction  has been made on the previous school fees invoice for BENJAMIN\nMUTHOMI ADM 042. Your new fee balancee effective from 13:50:37 27/05/2024 is kes. 58500. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-05-27 10:50:38', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (92, 0, 'BENJAMIN\nMUTHOMI', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 26500 for BENJAMIN\nMUTHOMI, ADM 042 has been processed successfuly at 13:51:27 on 27/05/2024. Your fee balance is kes. 32000. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-05-27 10:51:28', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (93, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for JULIE SAGA HANS ADM 001 is KSHS 62000 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:58:20', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (94, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for SALIM. N. MWAKIKOI ADM 002 is KSHS 40000 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:58:21', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (95, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for EMMANUEL MWANGI ADM 003 is KSHS 39000 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:58:22', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (96, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for BLESSING LUYAI ADM 004 is KSHS 22000 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:58:23', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (97, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for LIAM KIRUHI KAMWERU ADM 005 is KSHS 42000 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:58:24', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (98, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for ESTHER MUENI ADM 006 is KSHS 0 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:58:26', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (99, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for JUMA SWALEH ADM 007 is KSHS 0 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:58:27', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (100, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for MARYLNE NJOKI ADM 008 is KSHS 0 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:58:28', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (101, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for MICHAEL FREDRICK ADM 009 is KSHS 67000 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:58:29', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (102, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for N’NJEMA ISABEL ADM 011 is KSHS 19000 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:58:30', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (103, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for YUSUF MWINYI ADM 012 is KSHS 32000 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:58:31', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (104, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for ALI WASILWA PAKIA ADM 013 is KSHS 22000 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:58:33', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (105, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for RICHARD MSOMI ADM 014 is KSHS 32000 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:58:34', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (106, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for ISSA HAMAD ADM 015 is KSHS 2000 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:58:35', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (107, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for ALI SAID ADM 016 is KSHS 42000 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:58:36', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (108, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for RANDANI KASSIM ADM 017 is KSHS 3500 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:58:37', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (109, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for ALMASI MALAU ADM 018 is KSHS 20000 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:58:38', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (110, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for BRIAN KIOKO ADM 019 is KSHS 17000 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:58:40', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (111, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for ZAINAB SALIM ADM 020 is KSHS 22000 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:58:41', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (112, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for DELPHINE KHALAI ADM 021 is KSHS 32000 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:58:42', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (113, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for ISAACK MULEI ADM 022 is KSHS 17000 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:58:43', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (114, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for YOHANN’S MUGO ADM 023 is KSHS 0 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:58:44', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (115, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for TYRESE KITHUNGA ADM 024 is KSHS 0 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:58:46', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (116, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for YVONNE KAMENE ADM 025 is KSHS 37000 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:58:47', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (117, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for WENDY NDUKU ADM 026 is KSHS 0 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:58:48', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (118, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for CHELSEA JULIA ADM 027 is KSHS 0 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:58:49', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (119, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for SHAUN MATHEKA ADM 028 is KSHS 11000 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:58:50', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (120, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for ASHLEY NELIMA ADM 029 is KSHS 32000 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:58:52', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (121, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for VANESSA WANGO ADM 030 is KSHS 0 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:58:53', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (122, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for OPRAH WANGARE ADM 031 is KSHS 22000 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:58:54', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (123, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for ROBIN  BAYA EDWIN MISTANZE ADM 032 is KSHS 7000 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:58:55', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (124, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for LIONELL KADIEDA ADM 033 is KSHS 0 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:58:56', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (125, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for SANDRA NASIKE ADM 034 is KSHS 25000 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:58:57', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (126, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for LOUIS KITSAO ADM 035 is KSHS 0 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:58:59', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (127, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for FORTUNE KAITHYA ADM 036 is KSHS 12000 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:59:00', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (128, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for KHADIJA JUMA ADM 037 is KSHS 41300 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:59:01', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (129, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for ADELIGHT FURAHA ADM 038 is KSHS 12000 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:59:02', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (130, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for SASHA PEARL ADM 039 is KSHS 47000 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:59:03', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (131, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for SEMIGIL KOOME ADM 040 is KSHS 39000 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:59:05', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (132, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for SULEIMANABDALLAH ADM 041 is KSHS 54900 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:59:06', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (133, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for BENJAMIN\nMUTHOMI ADM 042 is KSHS 32000 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:59:07', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (134, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for KHERI MWANGAZA ADM 043 is KSHS 54000 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:59:08', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (135, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for ISMAILMGANDI ADM 044 is KSHS 67000 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:59:09', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (136, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for LISSY IVY ADM 045 is KSHS 47000 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:59:10', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (137, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for LINDA MAUA ADM 046 is KSHS 5000 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:59:12', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (138, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for LATIFFA BRIGIT MATASA ADM 047 is KSHS 22000 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:59:13', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (139, 0, '', 'Automated', 1, 0, 'Dear Parent/ Guardian. The fees balance for RAINER KIMILU ADM 048 is KSHS 42000 . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:59:14', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (140, 3, 'JULIE SAGA HANS ,SALIM. N. MWAKIKOI ,EMMANUEL MWANGI ,BLESSING LUYAI ,LIAM KIRUHI KAMWERU ,ESTHER MUENI ,JUMA SWALEH ,MARYLNE NJOKI ,MICHAEL FREDRICK ,N’NJEMA ISABEL ,YUSUF MWINYI ,ALI WASILWA PAKIA ,RICHARD MSOMI ,ISSA HAMAD ,ALI SAID ,RANDANI KASSIM ,ALMASI MALAU ,BRIAN KIOKO ,ZAINAB SALIM ,DELPHINE KHALAI ,ISAACK MULEI ,YOHANN’S MUGO ,TYRESE KITHUNGA ,YVONNE KAMENE ,WENDY NDUKU ,CHELSEA JULIA ,SHAUN MATHEKA ,ASHLEY NELIMA ,VANESSA WANGO ,OPRAH WANGARE ,ROBIN  BAYA EDWIN MISTANZE ,LIONELL KADIEDA ,SANDRA NASIKE ,LOUIS KITSAO ,FORTUNE KAITHYA ,KHADIJA JUMA ,ADELIGHT FURAHA ,SASHA PEARL ,SEMIGIL KOOME ,SULEIMANABDALLAH ,BENJAMIN\nMUTHOMI ,KHERI MWANGAZA ,ISMAILMGANDI ,LISSY IVY ,LINDA MAUA ,LATIFFA BRIGIT MATASA ,RAINER KIMILU ,', 'Sms', 1, 2, 'Dear Parent/ Guardian. The fees balance for [name] ADM [register_no] is KSHS [balance] . Ignore if you have cleared. For queries contact our office +254 723821682 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:59:15', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (141, 0, 'ALI WASILWA PAKIA', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 10000 for ALI WASILWA PAKIA, ADM 013 has been processed successfuly at 13:59:13 on 04/06/2024. Your fee balance is kes. 12000. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-06-04 10:59:15', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (142, 0, 'LIAM KIRUHI KAMWERU', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 22000 for LIAM KIRUHI KAMWERU, ADM 005 has been processed successfuly at 14:24:34 on 04/06/2024. Your fee balance is kes. 20000. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-06-04 11:24:35', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (143, 0, 'RAINER KIMILU', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 20000 for RAINER KIMILU, ADM 048 has been processed successfuly at 14:29:41 on 04/06/2024. Your fee balance is kes. 22000. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-06-04 11:29:42', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (144, 0, 'ASHLEY NELIMA', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 22000 for ASHLEY NELIMA, ADM 029 has been processed successfuly at 14:33:02 on 04/06/2024. Your fee balance is kes. 10000. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-06-04 11:33:02', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (145, 0, 'ALI SAID', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 42000 for ALI SAID, ADM 016 has been processed successfuly at 14:34:25 on 04/06/2024. Your fee balance is kes. 0. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-06-04 11:34:26', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (146, 0, 'ZAINAB SALIM', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 22000 for ZAINAB SALIM, ADM 020 has been processed successfuly at 14:36:11 on 04/06/2024. Your fee balance is kes. 0. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-06-04 11:36:12', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (147, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:04', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (148, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:06', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (149, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:07', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (150, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:08', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (151, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:09', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (152, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:11', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (153, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:12', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (154, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:13', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (155, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:14', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (156, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:16', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (157, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:17', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (158, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:18', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (159, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:19', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (160, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:21', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (161, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:22', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (162, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:23', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (163, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:24', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (164, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:26', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (165, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:27', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (166, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:28', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (167, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:29', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (168, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:31', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (169, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:32', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (170, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:33', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (171, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:34', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (172, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:36', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (173, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:37', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (174, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:38', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (175, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:39', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (176, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:41', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (177, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:42', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (178, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:43', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (179, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:44', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (180, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:46', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (181, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:47', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (182, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:48', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (183, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:49', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (184, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:50', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (185, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:52', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (186, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:53', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (187, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:54', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (188, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:55', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (189, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:57', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (190, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:58', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (191, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:45:59', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (192, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:46:00', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (193, 0, '', 'Automated', 1, 0, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:46:02', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (194, 3, 'JULIE SAGA HANS ,SALIM. N. MWAKIKOI ,EMMANUEL MWANGI ,BLESSING LUYAI ,LIAM KIRUHI KAMWERU ,ESTHER MUENI ,JUMA SWALEH ,MARYLNE NJOKI ,MICHAEL FREDRICK ,N’NJEMA ISABEL ,YUSUF MWINYI ,ALI WASILWA PAKIA ,RICHARD MSOMI ,ISSA HAMAD ,ALI SAID ,RANDANI KASSIM ,ALMASI MALAU ,BRIAN KIOKO ,ZAINAB SALIM ,DELPHINE KHALAI ,ISAACK MULEI ,YOHANN’S MUGO ,TYRESE KITHUNGA ,YVONNE KAMENE ,WENDY NDUKU ,CHELSEA JULIA ,SHAUN MATHEKA ,ASHLEY NELIMA ,VANESSA WANGO ,OPRAH WANGARE ,ROBIN  BAYA EDWIN MISTANZE ,LIONELL KADIEDA ,SANDRA NASIKE ,LOUIS KITSAO ,FORTUNE KAITHYA ,KHADIJA JUMA ,ADELIGHT FURAHA ,SASHA PEARL ,SEMIGIL KOOME ,SULEIMANABDALLAH ,BENJAMIN\nMUTHOMI ,KHERI MWANGAZA ,ISMAILMGANDI ,LISSY IVY ,LINDA MAUA ,LATIFFA BRIGIT MATASA ,RAINER KIMILU ,', 'Sms', 1, 2, 'Good evening dear parent/guardian. This is to humbly remind you that we shall have  our class meetings this Saturday 8/6/24  starting  at 9:00am. Those with fee arrears are requested to clear before then.\r\nParents to students in boarding are allowed to carry food for them .\r\nBest regards', '2024-06-06 13:46:02', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (195, 0, 'ISSA HAMAD', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 2000 for ISSA HAMAD, ADM 015 has been processed successfuly at 12:44:08 on 07/06/2024. Your fee balance is kes. 0. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-06-07 09:44:09', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (196, 0, 'BRIAN KIOKO', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 17000 for BRIAN KIOKO, ADM 019 has been processed successfuly at 12:46:00 on 07/06/2024. Your fee balance is kes. 0. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-06-07 09:46:01', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (197, 0, 'BENJAMIN\nMUTHOMI', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 10000 for BENJAMIN\nMUTHOMI, ADM 042 has been processed successfuly at 12:48:22 on 07/06/2024. Your fee balance is kes. 22000. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-06-07 09:48:23', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (198, 0, 'KHERI MWANGAZA', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 15000 for KHERI MWANGAZA, ADM 043 has been processed successfuly at 12:52:17 on 07/06/2024. Your fee balance is kes. 39000. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-06-07 09:52:18', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (199, 0, 'SULEIMANABDALLAH', 'Automated', 1, 0, ' Dear Guardian, your fee payment of kes 4000 for SULEIMANABDALLAH, ADM 041 has been processed successfuly at 13:05:28 on 07/06/2024. Your fee balance is kes. 50900. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-06-07 10:05:28', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (200, 0, 'ALMASI MALAU', 'Automated', 1, 1, 'Dear Guardian, the account for ALMASI MALAU , ADM 018 has been credited with 200 at 12:37:53 on 10/06/2024. For queries contact our office +254 796 047 282 AVEON JUNIOR SEC. Powered by Skooly.', '2024-06-10 09:37:54', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (201, 0, 'JULIE SAGA HANS', 'Automated', 1, 1, 'Dear Guardian, your child JULIE SAGA HANS adm 001 has checked in at school at 16:48:57 on 12/06/2024 . Thanks', '2024-06-12 13:48:58', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (202, 0, 'JULIE SAGA HANS', 'Automated', 1, 1, 'Dear Guardian, your child JULIE SAGA HANS adm 001 has checked in at school at 20:03:47 on 12/06/2024 . Thanks', '2024-06-12 17:03:48', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (203, 0, 'JULIE SAGA HANS', 'Automated', 1, 1, 'Dear Guardian, your child JULIE SAGA HANS adm 001 has checked in at school at 20:08:22 on 12/06/2024 . Thanks', '2024-06-12 17:08:22', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (204, 0, 'JULIE SAGA HANS', 'Automated', 1, 0, ' Dear Guardian, the fee balance for JULIE SAGA HANS, ADM 001  is kes. 62000. For queries contact our office +254 721 368123 HILLSIDE  JUNIOR SEC. Powered by Skooly.', '2024-06-12 17:15:52', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (205, 0, 'JULIE SAGA HANS', 'Automated', 1, 1, 'Dear Guardian, your child JULIE SAGA HANS adm 001 has checked in at school at 20:16:42 on 12/06/2024 . Thanks', '2024-06-12 17:16:43', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (206, 0, 'JULIE SAGA HANS', 'Automated', 1, 1, 'Dear Guardian,  your child JULIE SAGA HANS adm 001 has checked out of school at 20:17:01 on 12/06/2024Thanks', '2024-06-12 17:17:03', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (207, 0, 'JULIE SAGA HANS', 'Automated', 1, 0, 'Dear Guardian, your child JULIE SAGA HANS adm 001 has checked in at school at 20:18:36 on 12/06/2024 . Powered by Skooly. ', '2024-06-12 17:18:37', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (208, 0, 'JULIE SAGA HANS', 'Automated', 1, 0, 'Dear Guardian,  your child JULIE SAGA HANS adm 1 has checked out of school at 20:18:43 on 12/06/2024. Powered by Skooly.', '2024-06-12 17:18:44', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (209, 0, 'JULIE SAGA HANS', 'Automated', 1, 1, 'Dear Guardian, your child JULIE SAGA HANS adm 001 has checked in at school at 20:28:11 on 12/06/2024 . Thanks', '2024-06-12 17:28:12', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (210, 0, 'JULIE SAGA HANS', 'Automated', 1, 1, 'Dear Guardian, your child JULIE SAGA HANS adm 001 has checked in at school at 20:29:16 on 12/06/2024 . Thanks', '2024-06-12 17:29:16', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (211, 0, 'JULIE SAGA HANS', 'Automated', 1, 1, 'Dear Guardian,  your child JULIE SAGA HANS adm 001 has checked out of school at 20:29:30 on 12/06/2024Thanks', '2024-06-12 17:29:31', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (212, 0, 'SALIM. N. MWAKIKOI', 'Automated', 1, 1, 'Dear Guardian, your child SALIM. N. MWAKIKOI adm 002 has checked in at school at 20:34:28 on 12/06/2024 . Thanks', '2024-06-12 17:34:29', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (213, 0, 'SALIM. N. MWAKIKOI', 'Automated', 1, 1, 'Dear Guardian,  your child SALIM. N. MWAKIKOI adm 002 has checked out of school at 20:35:02 on 12/06/2024Thanks', '2024-06-12 17:35:03', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (214, 0, 'SALIM. N. MWAKIKOI', 'Automated', 1, 1, 'Dear Guardian,  your child SALIM. N. MWAKIKOI adm 002 has checked out of school at 20:35:54 on 12/06/2024Thanks', '2024-06-12 17:35:55', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (215, 0, 'N’NJEMA ISABEL', 'Automated', 1, 0, 'Dear Guardian,  your child N’NJEMA ISABEL adm 011 has checked out of school at 21:15:29 on 12/06/2024. Powered by Skooly.', '2024-06-12 18:15:29', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (216, 0, 'N’NJEMA ISABEL', 'Automated', 1, 0, 'Dear Guardian, your child N’NJEMA ISABEL adm 011 has checked in at school at 21:15:41 on 12/06/2024 . Powered by Skooly. ', '2024-06-12 18:15:41', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (217, 0, 'Elisha Mwamburi', 'Automated', 1, 0, 'Dear Parent, we are delighted to welcome Elisha Mwamburi, ADM No. 049, to our HILLSIDE  JUNIOR SEC and we look forward to learning ,exploring and growing together.We are committed to making it an enriching experience. For queries kindly contact our office number +254 721 368123 HILLSIDE  JUNIOR SEC. Powered by Skooly.', '2024-06-13 13:26:16', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (218, 0, 'Grace Mwamburi', 'Automated', 1, 0, 'Dear Guardian, a new invoice of kes. 20500 for Grace Mwamburi, ADM 049 has been created at 16:50:12 on 13/06/2024 and your current balance is Kes 82000. Please pay on time to avoid inconvinience. For queries contact our office +254 721 368123 HILLSIDE  JUNIOR SEC. Powered by Skooly.', '2024-06-13 13:50:12', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (219, 0, 'Grace Mwamburi', 'Automated', 1, 0, 'Dear Guardian, a new invoice of kes. 20500 for Grace Mwamburi, ADM 049 has been created at 16:50:13 on 13/06/2024 and your current balance is Kes 82000. Please pay on time to avoid inconvinience. For queries contact our office +254 721 368123 HILLSIDE  JUNIOR SEC. Powered by Skooly.', '2024-06-13 13:50:13', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (220, 0, 'Grace Mwamburi', 'Automated', 1, 0, 'Dear Guardian, a new invoice of kes. 20500 for Grace Mwamburi, ADM 049 has been created at 16:50:14 on 13/06/2024 and your current balance is Kes 82000. Please pay on time to avoid inconvinience. For queries contact our office +254 721 368123 HILLSIDE  JUNIOR SEC. Powered by Skooly.', '2024-06-13 13:50:14', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (221, 0, 'JULIE SAGA HANS', 'Automated', 1, 1, 'Dear Guardian, the account for JULIE SAGA HANS , ADM 001 has been credited with 1000 at 14:03:58 on 16/06/2024. For queries contact our office +254 721 368123 HILLSIDE  JUNIOR SEC. Powered by Skooly.', '2024-06-16 11:03:59', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (222, 0, 'Elisha Mwamburi', 'Automated', 1, 1, 'Dear Guardian, the account for Elisha Mwamburi , ADM 049 has been credited with 2000 at 14:22:34 on 16/06/2024. For queries contact our office +254 721 368123 HILLSIDE  JUNIOR SEC. Powered by Skooly.', '2024-06-16 11:22:34', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (223, 0, 'JONES KIPCHIRCHIR', 'Automated', 1, 1, 'Dear Guardian, the account for JONES KIPCHIRCHIR , ADM 052 has been credited with 100 at 14:31:25 on 16/06/2024. For queries contact our office +254 721 368123 HILLSIDE  JUNIOR SEC. Powered by Skooly.', '2024-06-16 11:31:26', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (224, 0, 'JONES KIPCHIRCHIR', 'Automated', 1, 1, 'Dear Guardian, the account for JONES KIPCHIRCHIR , ADM 052 has been credited with 1000 at 14:36:26 on 16/06/2024. For queries contact our office +254 721 368123 HILLSIDE  JUNIOR SEC. Powered by Skooly.', '2024-06-16 11:36:26', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (225, 0, 'JONES KIPCHIRCHIR', 'Automated', 1, 1, 'Dear Guardian, the account for JONES KIPCHIRCHIR , ADM 052 has been credited with 1000 at 14:43:08 on 16/06/2024. For queries contact our office +254 721 368123 HILLSIDE  JUNIOR SEC. Powered by Skooly.', '2024-06-16 11:43:08', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (226, 0, 'JONES KIPCHIRCHIR', 'Automated', 1, 1, 'Dear Guardian, your child JONES KIPCHIRCHIR adm 052 has checked in at school at 15:24:54 on 16/06/2024 . Thanks', '2024-06-16 12:24:55', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (227, 0, 'JONES KIPCHIRCHIR', 'Automated', 1, 0, ' Dear Guardian, the fee balance for JONES KIPCHIRCHIR, ADM 052  is kes. 500. For queries contact our office +254 721 368123 HILLSIDE  JUNIOR SEC. Powered by Skooly.', '2024-06-16 12:30:23', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (228, 0, 'JONES KIPCHIRCHIR', 'Automated', 1, 1, 'Dear Guardian, the account for JONES KIPCHIRCHIR , ADM 052 has been credited with 1000 at 15:49:46 on 16/06/2024. For queries contact our office +254 721 368123 HILLSIDE  JUNIOR SEC. Powered by Skooly.', '2024-06-16 12:49:47', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (229, 0, 'JONES KIPCHIRCHIR', 'Automated', 1, 0, ' Dear Guardian, the fee balance for JONES KIPCHIRCHIR, ADM 052  is kes. 400. For queries contact our office +254 721 368123 HILLSIDE  JUNIOR SEC. Powered by Skooly.', '2024-06-16 12:52:48', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (230, 0, 'JULIE SAGA HANS', 'Automated', 1, 1, 'Dear Guardian, the account for JULIE SAGA HANS , ADM 001 has been credited with 2000 at 15:58:56 on 16/06/2024. For queries contact our office +254 721 368123 HILLSIDE  JUNIOR SEC. Powered by Skooly.', '2024-06-16 12:58:58', '2024');
INSERT INTO `mailandsms` (`mailandsmsID`, `usertypeID`, `users`, `type`, `senderusertypeID`, `senderID`, `message`, `create_date`, `year`) VALUES (231, 0, 'SALIM. N. MWAKIKOI', 'Automated', 1, 1, 'Dear Guardian, the account for SALIM. N. MWAKIKOI , ADM 002 has been credited with 1000 at 20:59:03 on 19/06/2024. For queries contact our office +254 721 368123 HILLSIDE  JUNIOR SEC. Powered by Skooly.', '2024-06-19 17:59:04', '2024');


#
# TABLE STRUCTURE FOR: mailandsmstemplate
#

DROP TABLE IF EXISTS `mailandsmstemplate`;

CREATE TABLE `mailandsmstemplate` (
  `mailandsmstemplateID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `type` varchar(10) NOT NULL,
  `template` text NOT NULL,
  `create_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`mailandsmstemplateID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `mailandsmstemplate` (`mailandsmstemplateID`, `name`, `usertypeID`, `type`, `template`, `create_date`) VALUES (1, 'FEES BALANCE REMINDER', 3, 'sms', 'Dear Parent/ Guardian. Please clear the fees balance of [name] ADM [register_no] with a balance of KSHS [balance] to avoid your child being sent home. Ignore if you have cleared. For queries contact our office +254 796 047 282 AVEON SCHOOLS. Powered by SKOOLY.', '2023-03-31 02:54:10');
INSERT INTO `mailandsmstemplate` (`mailandsmstemplateID`, `name`, `usertypeID`, `type`, `template`, `create_date`) VALUES (2, 'FEE BALANCE', 3, 'sms', 'Dear Parent/ Guardian. The fees balance for [name] ADM [register_no] is KSHS [balance] . Ignore if you have cleared. For queries contact our office +254 796 047 282 AVEON SCHOOLS. Powered by SKOOLY.', '2024-06-03 10:10:15');


#
# TABLE STRUCTURE FOR: mailandsmstemplatetag
#

DROP TABLE IF EXISTS `mailandsmstemplatetag`;

CREATE TABLE `mailandsmstemplatetag` (
  `mailandsmstemplatetagID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `usertypeID` int(11) NOT NULL,
  `tagname` varchar(128) NOT NULL,
  `mailandsmstemplatetag_extra` varchar(255) DEFAULT NULL,
  `create_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`mailandsmstemplatetagID`)
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=utf8;

INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (1, 1, '[name]', NULL, '2016-12-10 14:36:33');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (2, 1, '[dob]', NULL, '2016-12-10 14:37:31');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (3, 1, '[gender]', NULL, '2016-12-10 14:37:31');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (4, 1, '[religion]', NULL, '2016-12-10 14:39:51');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (5, 1, '[email]', NULL, '2016-12-10 14:39:51');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (6, 1, '[phone]', NULL, '2016-12-10 14:39:51');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (7, 1, '[address]', NULL, '2016-12-10 14:39:51');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (8, 1, '[jod]', NULL, '2016-12-10 14:39:51');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (9, 1, '[username]', NULL, '2016-12-10 14:39:51');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (10, 2, '[name]', NULL, '2016-12-10 14:40:50');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (11, 2, '[designation]', NULL, '2016-12-10 14:43:27');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (12, 2, '[dob]', NULL, '2016-12-10 14:46:21');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (13, 2, '[gender]', NULL, '2016-12-10 14:46:21');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (14, 2, '[religion]', NULL, '2016-12-10 14:46:21');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (15, 2, '[email]', NULL, '2016-12-10 14:46:21');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (16, 2, '[phone]', NULL, '2016-12-10 14:46:21');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (17, 2, '[address]', NULL, '2016-12-10 14:46:21');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (18, 2, '[jod]', NULL, '2016-12-10 14:46:21');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (19, 2, '[username]', NULL, '2016-12-10 14:46:21');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (20, 3, '[name]', NULL, '2016-12-10 14:47:09');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (21, 3, '[dob]', NULL, '2016-12-10 14:55:54');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (22, 3, '[gender]', NULL, '2016-12-10 14:55:54');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (23, 3, '[blood_group]', NULL, '2016-12-10 14:55:54');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (24, 3, '[religion]', NULL, '2016-12-10 14:55:54');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (25, 3, '[email]', NULL, '2016-12-10 14:55:54');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (26, 3, '[phone]', NULL, '2016-12-10 14:55:54');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (27, 3, '[address]', NULL, '2016-12-10 14:55:54');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (28, 3, '[state]', NULL, '2017-02-11 12:21:49');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (29, 3, '[country]', NULL, '2017-02-11 12:21:27');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (30, 3, '[class]', NULL, '2016-12-18 15:34:20');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (31, 3, '[section]', NULL, '2016-12-10 14:55:54');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (32, 3, '[group]', NULL, '2016-12-10 14:55:54');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (33, 3, '[optional_subject]', NULL, '2016-12-10 14:55:54');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (34, 3, '[register_no]', NULL, '2017-02-11 12:21:27');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (35, 3, '[roll]', NULL, '2017-02-11 12:22:56');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (36, 3, '[extra_curricular_activities]', NULL, '2017-02-11 12:22:56');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (37, 3, '[remarks]', NULL, '2017-02-11 12:22:56');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (38, 3, '[username]', NULL, '2016-12-10 14:55:54');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (39, 3, '[result_table]', NULL, '2016-12-10 14:55:54');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (40, 4, '[name]', NULL, '2016-12-10 14:57:31');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (41, 4, '[father\'s_name]', NULL, '2016-12-10 15:04:19');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (42, 4, '[mother\'s_name]', NULL, '2016-12-10 15:04:19');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (43, 4, '[father\'s_profession]', NULL, '2016-12-10 15:04:19');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (44, 4, '[mother\'s_profession]', NULL, '2016-12-10 15:04:19');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (45, 4, '[email]', NULL, '2016-12-10 15:04:19');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (46, 4, '[phone]', NULL, '2016-12-10 15:04:19');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (47, 4, '[address]', NULL, '2016-12-10 15:04:19');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (48, 4, '[username]', NULL, '2016-12-10 15:04:19');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (49, 1, '[date]', NULL, '2018-05-11 04:12:12');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (50, 2, '[date]', NULL, '2018-05-11 04:12:27');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (51, 3, '[date]', NULL, '2018-05-11 04:12:36');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (52, 4, '[date]', NULL, '2018-05-11 04:12:49');
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES (53, 3, '[balance]', NULL, '2018-05-11 04:12:36');


#
# TABLE STRUCTURE FOR: maininvoice
#

DROP TABLE IF EXISTS `maininvoice`;

CREATE TABLE `maininvoice` (
  `maininvoiceID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `maininvoiceschoolyearID` int(11) NOT NULL,
  `maininvoiceschooltermID` int(11) DEFAULT NULL,
  `maininvoiceclassesID` int(11) NOT NULL,
  `maininvoicestudentID` int(11) NOT NULL,
  `maininvoiceuserID` int(11) DEFAULT NULL,
  `maininvoiceusertypeID` int(11) DEFAULT NULL,
  `maininvoiceuname` varchar(60) DEFAULT NULL,
  `maininvoicedate` date NOT NULL,
  `maininvoicecreate_date` date NOT NULL,
  `maininvoiceday` varchar(20) DEFAULT NULL,
  `maininvoicemonth` varchar(20) DEFAULT NULL,
  `maininvoiceyear` year(4) NOT NULL,
  `maininvoicestatus` int(11) DEFAULT NULL,
  `maininvoicedeleted_at` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`maininvoiceID`)
) ENGINE=InnoDB AUTO_INCREMENT=59 DEFAULT CHARSET=utf8;

INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (1, 4, 2, 9, 3, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (2, 4, 2, 9, 5, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (3, 4, 2, 9, 6, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (4, 4, 2, 9, 7, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (5, 4, 2, 9, 26, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (6, 4, 2, 9, 22, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 1, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (7, 4, 2, 9, 27, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (8, 4, 2, 9, 31, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 1, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (9, 4, 2, 9, 32, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 1, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (10, 4, 2, 9, 35, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (11, 4, 2, 9, 38, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 1, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (12, 4, 2, 9, 41, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 1, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (13, 4, 2, 9, 48, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 1, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (14, 4, 2, 10, 13, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 1, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (15, 4, 2, 10, 1, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (16, 4, 2, 10, 46, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 1, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (17, 4, 2, 10, 15, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (18, 4, 2, 10, 19, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (19, 4, 2, 10, 13, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 0);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (20, 4, 2, 9, 10, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 1, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (21, 4, 2, 9, 16, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (22, 4, 2, 9, 28, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 1, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (23, 4, 2, 9, 42, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 1, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (24, 4, 2, 9, 8, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (25, 4, 2, 9, 14, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (26, 4, 2, 9, 23, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (27, 4, 2, 9, 24, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (28, 4, 2, 9, 36, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 1, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (29, 4, 2, 9, 2, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (30, 4, 2, 9, 39, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 1, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (31, 4, 2, 9, 40, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 1, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (32, 4, 2, 10, 9, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (33, 4, 2, 9, 33, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 2, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (34, 4, 2, 9, 44, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 0, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (35, 4, 2, 9, 45, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-22', '22', '03', '2024', 1, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (36, 4, 2, 9, 17, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 1, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (37, 4, 2, 9, 20, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (38, 4, 2, 9, 34, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 1, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (39, 4, 2, 10, 4, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (40, 4, 2, 10, 11, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (41, 4, 2, 10, 18, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 1, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (42, 4, 2, 9, 47, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 1, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (43, 4, 2, 9, 30, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (44, 4, 2, 9, 37, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 1, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (45, 4, 2, 9, 21, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 1, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (46, 4, 2, 9, 25, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 1, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (47, 4, 2, 9, 29, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 1, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (48, 4, 2, 9, 12, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 1, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (49, 4, 2, 9, 43, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 1, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (50, 4, 3, 10, 9, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (51, 4, 3, 9, 3, 1, 5, 'JOSEPH WAMBUA', '2024-03-28', '2024-03-25', '25', '03', '2024', 2, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (56, 4, 1, 10, 52, 1, 1, 'Skooly', '2024-06-14', '2024-06-14', '14', '06', '2024', 1, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (57, 4, 1, 9, 53, 1, 1, 'Skooly', '2024-06-14', '2024-06-14', '14', '06', '2024', 2, 1);
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceschooltermID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES (58, 4, 2, 9, 54, 1, 1, 'Skooly', '2024-06-16', '2024-06-16', '16', '06', '2024', 1, 1);


#
# TABLE STRUCTURE FOR: make_payment
#

DROP TABLE IF EXISTS `make_payment`;

CREATE TABLE `make_payment` (
  `make_paymentID` int(11) NOT NULL AUTO_INCREMENT,
  `month` text NOT NULL,
  `gross_salary` text NOT NULL,
  `total_deduction` text NOT NULL,
  `net_salary` text NOT NULL,
  `payment_amount` text NOT NULL,
  `payment_method` int(11) NOT NULL,
  `comments` text,
  `templateID` int(11) NOT NULL,
  `salaryID` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `userID` int(11) NOT NULL,
  `schoolyearID` int(11) DEFAULT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_username` varchar(60) NOT NULL,
  `create_usertype` varchar(60) NOT NULL,
  `total_hours` text,
  PRIMARY KEY (`make_paymentID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `make_payment` (`make_paymentID`, `month`, `gross_salary`, `total_deduction`, `net_salary`, `payment_amount`, `payment_method`, `comments`, `templateID`, `salaryID`, `usertypeID`, `userID`, `schoolyearID`, `create_date`, `modify_date`, `create_userID`, `create_username`, `create_usertype`, `total_hours`) VALUES (1, '06-2024', '3000', '800', '13700', '5000', 1, '', 1, 1, 2, 33, 4, '2024-06-18 11:35:26', '2024-06-18 11:35:26', 1, 'skooly', 'Admin', NULL);


#
# TABLE STRUCTURE FOR: manage_salary
#

DROP TABLE IF EXISTS `manage_salary`;

CREATE TABLE `manage_salary` (
  `manage_salaryID` int(11) NOT NULL AUTO_INCREMENT,
  `userID` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `salary` int(11) NOT NULL,
  `template` int(11) NOT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_username` varchar(60) NOT NULL,
  `create_usertype` varchar(60) NOT NULL,
  PRIMARY KEY (`manage_salaryID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `manage_salary` (`manage_salaryID`, `userID`, `usertypeID`, `salary`, `template`, `create_date`, `modify_date`, `create_userID`, `create_username`, `create_usertype`) VALUES (1, 9, 11, 1, 1, '2024-03-08 11:40:32', '2024-03-08 11:40:32', 2, 'admin', 'Admin');
INSERT INTO `manage_salary` (`manage_salaryID`, `userID`, `usertypeID`, `salary`, `template`, `create_date`, `modify_date`, `create_userID`, `create_username`, `create_usertype`) VALUES (2, 8, 11, 1, 1, '2024-03-08 11:40:52', '2024-03-08 11:40:52', 2, 'admin', 'Admin');
INSERT INTO `manage_salary` (`manage_salaryID`, `userID`, `usertypeID`, `salary`, `template`, `create_date`, `modify_date`, `create_userID`, `create_username`, `create_usertype`) VALUES (3, 33, 2, 1, 1, '2024-06-18 11:08:44', '2024-06-18 11:08:44', 1, 'skooly', 'Admin');


#
# TABLE STRUCTURE FOR: mark
#

DROP TABLE IF EXISTS `mark`;

CREATE TABLE `mark` (
  `markID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `schoolyearID` int(11) NOT NULL,
  `examID` int(11) NOT NULL,
  `exam` varchar(60) NOT NULL,
  `studentID` int(11) NOT NULL,
  `classesID` int(11) NOT NULL,
  `subjectID` int(11) NOT NULL,
  `subject` varchar(60) NOT NULL,
  `year` year(4) NOT NULL,
  `create_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL DEFAULT '0',
  `create_usertypeID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`markID`)
) ENGINE=InnoDB AUTO_INCREMENT=434 DEFAULT CHARSET=utf8;

INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (1, 4, 1, 'FIRST TERM 2024', 1, 10, 121, 'MATHS', '2024', '2024-03-06 21:07:49', 1, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (2, 4, 1, 'FIRST TERM 2024', 4, 10, 121, 'MATHS', '2024', '2024-03-06 21:07:49', 1, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (3, 4, 1, 'FIRST TERM 2024', 9, 10, 121, 'MATHS', '2024', '2024-03-06 21:07:49', 1, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (4, 4, 1, 'FIRST TERM 2024', 11, 10, 121, 'MATHS', '2024', '2024-03-06 21:07:49', 1, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (5, 4, 1, 'FIRST TERM 2024', 13, 10, 121, 'MATHS', '2024', '2024-03-06 21:07:49', 1, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (6, 4, 1, 'FIRST TERM 2024', 15, 10, 121, 'MATHS', '2024', '2024-03-06 21:07:49', 1, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (7, 4, 1, 'FIRST TERM 2024', 18, 10, 121, 'MATHS', '2024', '2024-03-06 21:07:49', 1, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (8, 4, 1, 'FIRST TERM 2024', 19, 10, 121, 'MATHS', '2024', '2024-03-06 21:07:49', 1, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (9, 4, 1, 'FIRST TERM 2024', 46, 10, 121, 'MATHS', '2024', '2024-03-06 21:07:49', 1, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (10, 4, 1, 'FIRST TERM 2024', 49, 10, 121, 'MATHS', '2024', '2024-03-06 21:07:49', 1, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (11, 4, 1, 'FIRST TERM 2024', 2, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (12, 4, 1, 'FIRST TERM 2024', 3, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (13, 4, 1, 'FIRST TERM 2024', 5, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (14, 4, 1, 'FIRST TERM 2024', 6, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (15, 4, 1, 'FIRST TERM 2024', 7, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (16, 4, 1, 'FIRST TERM 2024', 8, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (17, 4, 1, 'FIRST TERM 2024', 10, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (18, 4, 1, 'FIRST TERM 2024', 12, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (19, 4, 1, 'FIRST TERM 2024', 14, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (20, 4, 1, 'FIRST TERM 2024', 16, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (21, 4, 1, 'FIRST TERM 2024', 17, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (22, 4, 1, 'FIRST TERM 2024', 20, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (23, 4, 1, 'FIRST TERM 2024', 21, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (24, 4, 1, 'FIRST TERM 2024', 22, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (25, 4, 1, 'FIRST TERM 2024', 23, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (26, 4, 1, 'FIRST TERM 2024', 24, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (27, 4, 1, 'FIRST TERM 2024', 25, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (28, 4, 1, 'FIRST TERM 2024', 26, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (29, 4, 1, 'FIRST TERM 2024', 27, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (30, 4, 1, 'FIRST TERM 2024', 28, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (31, 4, 1, 'FIRST TERM 2024', 29, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (32, 4, 1, 'FIRST TERM 2024', 30, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (33, 4, 1, 'FIRST TERM 2024', 31, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (34, 4, 1, 'FIRST TERM 2024', 32, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (35, 4, 1, 'FIRST TERM 2024', 33, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (36, 4, 1, 'FIRST TERM 2024', 34, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (37, 4, 1, 'FIRST TERM 2024', 35, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (38, 4, 1, 'FIRST TERM 2024', 36, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (39, 4, 1, 'FIRST TERM 2024', 37, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (40, 4, 1, 'FIRST TERM 2024', 38, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (41, 4, 1, 'FIRST TERM 2024', 39, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (42, 4, 1, 'FIRST TERM 2024', 40, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (43, 4, 1, 'FIRST TERM 2024', 41, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (44, 4, 1, 'FIRST TERM 2024', 42, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (45, 4, 1, 'FIRST TERM 2024', 43, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (46, 4, 1, 'FIRST TERM 2024', 44, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (47, 4, 1, 'FIRST TERM 2024', 45, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (48, 4, 1, 'FIRST TERM 2024', 47, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (49, 4, 1, 'FIRST TERM 2024', 48, 9, 54, 'INTERGRATED SCIENCE', '2024', '2024-03-08 11:30:19', 2, 1);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (50, 4, 1, 'FIRST TERM 2024', 1, 10, 124, 'KISWAHILI', '2024', '2024-03-14 07:45:37', 30, 2);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (51, 4, 1, 'FIRST TERM 2024', 4, 10, 124, 'KISWAHILI', '2024', '2024-03-14 07:45:37', 30, 2);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (52, 4, 1, 'FIRST TERM 2024', 9, 10, 124, 'KISWAHILI', '2024', '2024-03-14 07:45:37', 30, 2);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (53, 4, 1, 'FIRST TERM 2024', 11, 10, 124, 'KISWAHILI', '2024', '2024-03-14 07:45:37', 30, 2);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (54, 4, 1, 'FIRST TERM 2024', 13, 10, 124, 'KISWAHILI', '2024', '2024-03-14 07:45:37', 30, 2);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (55, 4, 1, 'FIRST TERM 2024', 15, 10, 124, 'KISWAHILI', '2024', '2024-03-14 07:45:37', 30, 2);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (56, 4, 1, 'FIRST TERM 2024', 18, 10, 124, 'KISWAHILI', '2024', '2024-03-14 07:45:37', 30, 2);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (57, 4, 1, 'FIRST TERM 2024', 19, 10, 124, 'KISWAHILI', '2024', '2024-03-14 07:45:37', 30, 2);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (58, 4, 1, 'FIRST TERM 2024', 46, 10, 124, 'KISWAHILI', '2024', '2024-03-14 07:45:37', 30, 2);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (59, 4, 1, 'FIRST TERM 2024', 2, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (60, 4, 1, 'FIRST TERM 2024', 3, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (61, 4, 1, 'FIRST TERM 2024', 5, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (62, 4, 1, 'FIRST TERM 2024', 6, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (63, 4, 1, 'FIRST TERM 2024', 7, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (64, 4, 1, 'FIRST TERM 2024', 8, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (65, 4, 1, 'FIRST TERM 2024', 10, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (66, 4, 1, 'FIRST TERM 2024', 12, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (67, 4, 1, 'FIRST TERM 2024', 14, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (68, 4, 1, 'FIRST TERM 2024', 16, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (69, 4, 1, 'FIRST TERM 2024', 17, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (70, 4, 1, 'FIRST TERM 2024', 20, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (71, 4, 1, 'FIRST TERM 2024', 21, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (72, 4, 1, 'FIRST TERM 2024', 22, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (73, 4, 1, 'FIRST TERM 2024', 23, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (74, 4, 1, 'FIRST TERM 2024', 24, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (75, 4, 1, 'FIRST TERM 2024', 25, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (76, 4, 1, 'FIRST TERM 2024', 26, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (77, 4, 1, 'FIRST TERM 2024', 27, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (78, 4, 1, 'FIRST TERM 2024', 28, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (79, 4, 1, 'FIRST TERM 2024', 29, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (80, 4, 1, 'FIRST TERM 2024', 30, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (81, 4, 1, 'FIRST TERM 2024', 31, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (82, 4, 1, 'FIRST TERM 2024', 32, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (83, 4, 1, 'FIRST TERM 2024', 33, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (84, 4, 1, 'FIRST TERM 2024', 34, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (85, 4, 1, 'FIRST TERM 2024', 35, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (86, 4, 1, 'FIRST TERM 2024', 36, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (87, 4, 1, 'FIRST TERM 2024', 37, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (88, 4, 1, 'FIRST TERM 2024', 38, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (89, 4, 1, 'FIRST TERM 2024', 39, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (90, 4, 1, 'FIRST TERM 2024', 40, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (91, 4, 1, 'FIRST TERM 2024', 41, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (92, 4, 1, 'FIRST TERM 2024', 42, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (93, 4, 1, 'FIRST TERM 2024', 43, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (94, 4, 1, 'FIRST TERM 2024', 44, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (95, 4, 1, 'FIRST TERM 2024', 45, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (96, 4, 1, 'FIRST TERM 2024', 47, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (97, 4, 1, 'FIRST TERM 2024', 48, 9, 47, 'ENGLISH', '2024', '2024-03-14 07:54:32', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (98, 4, 1, 'FIRST TERM 2024', 1, 10, 127, 'RELIGIOUS', '2024', '2024-03-14 08:01:26', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (99, 4, 1, 'FIRST TERM 2024', 4, 10, 127, 'RELIGIOUS', '2024', '2024-03-14 08:01:26', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (100, 4, 1, 'FIRST TERM 2024', 9, 10, 127, 'RELIGIOUS', '2024', '2024-03-14 08:01:26', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (101, 4, 1, 'FIRST TERM 2024', 11, 10, 127, 'RELIGIOUS', '2024', '2024-03-14 08:01:26', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (102, 4, 1, 'FIRST TERM 2024', 13, 10, 127, 'RELIGIOUS', '2024', '2024-03-14 08:01:26', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (103, 4, 1, 'FIRST TERM 2024', 15, 10, 127, 'RELIGIOUS', '2024', '2024-03-14 08:01:26', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (104, 4, 1, 'FIRST TERM 2024', 18, 10, 127, 'RELIGIOUS', '2024', '2024-03-14 08:01:26', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (105, 4, 1, 'FIRST TERM 2024', 19, 10, 127, 'RELIGIOUS', '2024', '2024-03-14 08:01:26', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (106, 4, 1, 'FIRST TERM 2024', 46, 10, 127, 'RELIGIOUS', '2024', '2024-03-14 08:01:26', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (107, 4, 1, 'FIRST TERM 2024', 2, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (108, 4, 1, 'FIRST TERM 2024', 3, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (109, 4, 1, 'FIRST TERM 2024', 5, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (110, 4, 1, 'FIRST TERM 2024', 6, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (111, 4, 1, 'FIRST TERM 2024', 7, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (112, 4, 1, 'FIRST TERM 2024', 8, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (113, 4, 1, 'FIRST TERM 2024', 10, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (114, 4, 1, 'FIRST TERM 2024', 12, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (115, 4, 1, 'FIRST TERM 2024', 14, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (116, 4, 1, 'FIRST TERM 2024', 16, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (117, 4, 1, 'FIRST TERM 2024', 17, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (118, 4, 1, 'FIRST TERM 2024', 20, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (119, 4, 1, 'FIRST TERM 2024', 21, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (120, 4, 1, 'FIRST TERM 2024', 22, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (121, 4, 1, 'FIRST TERM 2024', 23, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (122, 4, 1, 'FIRST TERM 2024', 24, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (123, 4, 1, 'FIRST TERM 2024', 25, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (124, 4, 1, 'FIRST TERM 2024', 26, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (125, 4, 1, 'FIRST TERM 2024', 27, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (126, 4, 1, 'FIRST TERM 2024', 28, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (127, 4, 1, 'FIRST TERM 2024', 29, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (128, 4, 1, 'FIRST TERM 2024', 30, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (129, 4, 1, 'FIRST TERM 2024', 31, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (130, 4, 1, 'FIRST TERM 2024', 32, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (131, 4, 1, 'FIRST TERM 2024', 33, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (132, 4, 1, 'FIRST TERM 2024', 34, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (133, 4, 1, 'FIRST TERM 2024', 35, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (134, 4, 1, 'FIRST TERM 2024', 36, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (135, 4, 1, 'FIRST TERM 2024', 37, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (136, 4, 1, 'FIRST TERM 2024', 38, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (137, 4, 1, 'FIRST TERM 2024', 39, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (138, 4, 1, 'FIRST TERM 2024', 40, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (139, 4, 1, 'FIRST TERM 2024', 41, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (140, 4, 1, 'FIRST TERM 2024', 42, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (141, 4, 1, 'FIRST TERM 2024', 43, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (142, 4, 1, 'FIRST TERM 2024', 44, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (143, 4, 1, 'FIRST TERM 2024', 45, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (144, 4, 1, 'FIRST TERM 2024', 47, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (145, 4, 1, 'FIRST TERM 2024', 48, 9, 51, 'SOCIAL STUDIES', '2024', '2024-03-14 08:08:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (146, 4, 1, 'FIRST TERM 2024', 2, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (147, 4, 1, 'FIRST TERM 2024', 3, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (148, 4, 1, 'FIRST TERM 2024', 5, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (149, 4, 1, 'FIRST TERM 2024', 6, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (150, 4, 1, 'FIRST TERM 2024', 7, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (151, 4, 1, 'FIRST TERM 2024', 8, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (152, 4, 1, 'FIRST TERM 2024', 10, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (153, 4, 1, 'FIRST TERM 2024', 12, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (154, 4, 1, 'FIRST TERM 2024', 14, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (155, 4, 1, 'FIRST TERM 2024', 16, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (156, 4, 1, 'FIRST TERM 2024', 17, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (157, 4, 1, 'FIRST TERM 2024', 20, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (158, 4, 1, 'FIRST TERM 2024', 21, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (159, 4, 1, 'FIRST TERM 2024', 22, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (160, 4, 1, 'FIRST TERM 2024', 23, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (161, 4, 1, 'FIRST TERM 2024', 24, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (162, 4, 1, 'FIRST TERM 2024', 25, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (163, 4, 1, 'FIRST TERM 2024', 26, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (164, 4, 1, 'FIRST TERM 2024', 27, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (165, 4, 1, 'FIRST TERM 2024', 28, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (166, 4, 1, 'FIRST TERM 2024', 29, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (167, 4, 1, 'FIRST TERM 2024', 30, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (168, 4, 1, 'FIRST TERM 2024', 31, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (169, 4, 1, 'FIRST TERM 2024', 32, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (170, 4, 1, 'FIRST TERM 2024', 33, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (171, 4, 1, 'FIRST TERM 2024', 34, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (172, 4, 1, 'FIRST TERM 2024', 35, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (173, 4, 1, 'FIRST TERM 2024', 36, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (174, 4, 1, 'FIRST TERM 2024', 37, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (175, 4, 1, 'FIRST TERM 2024', 38, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (176, 4, 1, 'FIRST TERM 2024', 39, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (177, 4, 1, 'FIRST TERM 2024', 40, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (178, 4, 1, 'FIRST TERM 2024', 41, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (179, 4, 1, 'FIRST TERM 2024', 42, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (180, 4, 1, 'FIRST TERM 2024', 43, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (181, 4, 1, 'FIRST TERM 2024', 44, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (182, 4, 1, 'FIRST TERM 2024', 45, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (183, 4, 1, 'FIRST TERM 2024', 47, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (184, 4, 1, 'FIRST TERM 2024', 48, 9, 52, 'RELIGIOUS', '2024', '2024-03-14 08:37:25', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (185, 4, 1, 'FIRST TERM 2024', 2, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (186, 4, 1, 'FIRST TERM 2024', 3, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (187, 4, 1, 'FIRST TERM 2024', 5, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (188, 4, 1, 'FIRST TERM 2024', 6, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (189, 4, 1, 'FIRST TERM 2024', 7, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (190, 4, 1, 'FIRST TERM 2024', 8, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (191, 4, 1, 'FIRST TERM 2024', 10, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (192, 4, 1, 'FIRST TERM 2024', 12, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (193, 4, 1, 'FIRST TERM 2024', 14, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (194, 4, 1, 'FIRST TERM 2024', 16, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (195, 4, 1, 'FIRST TERM 2024', 17, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (196, 4, 1, 'FIRST TERM 2024', 20, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (197, 4, 1, 'FIRST TERM 2024', 21, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (198, 4, 1, 'FIRST TERM 2024', 22, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (199, 4, 1, 'FIRST TERM 2024', 23, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (200, 4, 1, 'FIRST TERM 2024', 24, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (201, 4, 1, 'FIRST TERM 2024', 25, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (202, 4, 1, 'FIRST TERM 2024', 26, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (203, 4, 1, 'FIRST TERM 2024', 27, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (204, 4, 1, 'FIRST TERM 2024', 28, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (205, 4, 1, 'FIRST TERM 2024', 29, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (206, 4, 1, 'FIRST TERM 2024', 30, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (207, 4, 1, 'FIRST TERM 2024', 31, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (208, 4, 1, 'FIRST TERM 2024', 32, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (209, 4, 1, 'FIRST TERM 2024', 33, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (210, 4, 1, 'FIRST TERM 2024', 34, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (211, 4, 1, 'FIRST TERM 2024', 35, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (212, 4, 1, 'FIRST TERM 2024', 36, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (213, 4, 1, 'FIRST TERM 2024', 37, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (214, 4, 1, 'FIRST TERM 2024', 38, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (215, 4, 1, 'FIRST TERM 2024', 39, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (216, 4, 1, 'FIRST TERM 2024', 40, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (217, 4, 1, 'FIRST TERM 2024', 41, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (218, 4, 1, 'FIRST TERM 2024', 42, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (219, 4, 1, 'FIRST TERM 2024', 43, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (220, 4, 1, 'FIRST TERM 2024', 44, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (221, 4, 1, 'FIRST TERM 2024', 45, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (222, 4, 1, 'FIRST TERM 2024', 47, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (223, 4, 1, 'FIRST TERM 2024', 48, 9, 49, 'KISWAHILI', '2024', '2024-03-14 09:06:29', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (224, 4, 1, 'FIRST TERM 2024', 2, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (225, 4, 1, 'FIRST TERM 2024', 3, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (226, 4, 1, 'FIRST TERM 2024', 5, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (227, 4, 1, 'FIRST TERM 2024', 6, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (228, 4, 1, 'FIRST TERM 2024', 7, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (229, 4, 1, 'FIRST TERM 2024', 8, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (230, 4, 1, 'FIRST TERM 2024', 10, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (231, 4, 1, 'FIRST TERM 2024', 12, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (232, 4, 1, 'FIRST TERM 2024', 14, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (233, 4, 1, 'FIRST TERM 2024', 16, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (234, 4, 1, 'FIRST TERM 2024', 17, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (235, 4, 1, 'FIRST TERM 2024', 20, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (236, 4, 1, 'FIRST TERM 2024', 21, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (237, 4, 1, 'FIRST TERM 2024', 22, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (238, 4, 1, 'FIRST TERM 2024', 23, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (239, 4, 1, 'FIRST TERM 2024', 24, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (240, 4, 1, 'FIRST TERM 2024', 25, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (241, 4, 1, 'FIRST TERM 2024', 26, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (242, 4, 1, 'FIRST TERM 2024', 27, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (243, 4, 1, 'FIRST TERM 2024', 28, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (244, 4, 1, 'FIRST TERM 2024', 29, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (245, 4, 1, 'FIRST TERM 2024', 30, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (246, 4, 1, 'FIRST TERM 2024', 31, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (247, 4, 1, 'FIRST TERM 2024', 32, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (248, 4, 1, 'FIRST TERM 2024', 33, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (249, 4, 1, 'FIRST TERM 2024', 34, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (250, 4, 1, 'FIRST TERM 2024', 35, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (251, 4, 1, 'FIRST TERM 2024', 36, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (252, 4, 1, 'FIRST TERM 2024', 37, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (253, 4, 1, 'FIRST TERM 2024', 38, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (254, 4, 1, 'FIRST TERM 2024', 39, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (255, 4, 1, 'FIRST TERM 2024', 40, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (256, 4, 1, 'FIRST TERM 2024', 41, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (257, 4, 1, 'FIRST TERM 2024', 42, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (258, 4, 1, 'FIRST TERM 2024', 43, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (259, 4, 1, 'FIRST TERM 2024', 44, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (260, 4, 1, 'FIRST TERM 2024', 45, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (261, 4, 1, 'FIRST TERM 2024', 47, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (262, 4, 1, 'FIRST TERM 2024', 48, 9, 158, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 09:23:05', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (263, 4, 1, 'FIRST TERM 2024', 2, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (264, 4, 1, 'FIRST TERM 2024', 3, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (265, 4, 1, 'FIRST TERM 2024', 5, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (266, 4, 1, 'FIRST TERM 2024', 6, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (267, 4, 1, 'FIRST TERM 2024', 7, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (268, 4, 1, 'FIRST TERM 2024', 8, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (269, 4, 1, 'FIRST TERM 2024', 10, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (270, 4, 1, 'FIRST TERM 2024', 12, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (271, 4, 1, 'FIRST TERM 2024', 14, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (272, 4, 1, 'FIRST TERM 2024', 16, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (273, 4, 1, 'FIRST TERM 2024', 17, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (274, 4, 1, 'FIRST TERM 2024', 20, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (275, 4, 1, 'FIRST TERM 2024', 21, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (276, 4, 1, 'FIRST TERM 2024', 22, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (277, 4, 1, 'FIRST TERM 2024', 23, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (278, 4, 1, 'FIRST TERM 2024', 24, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (279, 4, 1, 'FIRST TERM 2024', 25, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (280, 4, 1, 'FIRST TERM 2024', 26, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (281, 4, 1, 'FIRST TERM 2024', 27, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (282, 4, 1, 'FIRST TERM 2024', 28, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (283, 4, 1, 'FIRST TERM 2024', 29, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (284, 4, 1, 'FIRST TERM 2024', 30, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (285, 4, 1, 'FIRST TERM 2024', 31, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (286, 4, 1, 'FIRST TERM 2024', 32, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (287, 4, 1, 'FIRST TERM 2024', 33, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (288, 4, 1, 'FIRST TERM 2024', 34, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (289, 4, 1, 'FIRST TERM 2024', 35, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (290, 4, 1, 'FIRST TERM 2024', 36, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (291, 4, 1, 'FIRST TERM 2024', 37, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (292, 4, 1, 'FIRST TERM 2024', 38, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (293, 4, 1, 'FIRST TERM 2024', 39, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (294, 4, 1, 'FIRST TERM 2024', 40, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (295, 4, 1, 'FIRST TERM 2024', 41, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (296, 4, 1, 'FIRST TERM 2024', 42, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (297, 4, 1, 'FIRST TERM 2024', 43, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (298, 4, 1, 'FIRST TERM 2024', 44, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (299, 4, 1, 'FIRST TERM 2024', 45, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (300, 4, 1, 'FIRST TERM 2024', 47, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (301, 4, 1, 'FIRST TERM 2024', 48, 9, 46, 'MATHS', '2024', '2024-03-14 09:24:10', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (302, 4, 1, 'FIRST TERM 2024', 2, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (303, 4, 1, 'FIRST TERM 2024', 3, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (304, 4, 1, 'FIRST TERM 2024', 5, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (305, 4, 1, 'FIRST TERM 2024', 6, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (306, 4, 1, 'FIRST TERM 2024', 7, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (307, 4, 1, 'FIRST TERM 2024', 8, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (308, 4, 1, 'FIRST TERM 2024', 10, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (309, 4, 1, 'FIRST TERM 2024', 12, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (310, 4, 1, 'FIRST TERM 2024', 14, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (311, 4, 1, 'FIRST TERM 2024', 16, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (312, 4, 1, 'FIRST TERM 2024', 17, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (313, 4, 1, 'FIRST TERM 2024', 20, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (314, 4, 1, 'FIRST TERM 2024', 21, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (315, 4, 1, 'FIRST TERM 2024', 22, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (316, 4, 1, 'FIRST TERM 2024', 23, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (317, 4, 1, 'FIRST TERM 2024', 24, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (318, 4, 1, 'FIRST TERM 2024', 25, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (319, 4, 1, 'FIRST TERM 2024', 26, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (320, 4, 1, 'FIRST TERM 2024', 27, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (321, 4, 1, 'FIRST TERM 2024', 28, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (322, 4, 1, 'FIRST TERM 2024', 29, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (323, 4, 1, 'FIRST TERM 2024', 30, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (324, 4, 1, 'FIRST TERM 2024', 31, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (325, 4, 1, 'FIRST TERM 2024', 32, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (326, 4, 1, 'FIRST TERM 2024', 33, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (327, 4, 1, 'FIRST TERM 2024', 34, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (328, 4, 1, 'FIRST TERM 2024', 35, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (329, 4, 1, 'FIRST TERM 2024', 36, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (330, 4, 1, 'FIRST TERM 2024', 37, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (331, 4, 1, 'FIRST TERM 2024', 38, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (332, 4, 1, 'FIRST TERM 2024', 39, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (333, 4, 1, 'FIRST TERM 2024', 40, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (334, 4, 1, 'FIRST TERM 2024', 41, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (335, 4, 1, 'FIRST TERM 2024', 42, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (336, 4, 1, 'FIRST TERM 2024', 43, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (337, 4, 1, 'FIRST TERM 2024', 44, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (338, 4, 1, 'FIRST TERM 2024', 45, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (339, 4, 1, 'FIRST TERM 2024', 47, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (340, 4, 1, 'FIRST TERM 2024', 48, 9, 155, 'PRE TECHNICAL', '2024', '2024-03-14 11:03:39', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (341, 4, 1, 'FIRST TERM 2024', 1, 10, 128, 'INTEGRATED SCIENCE', '2024', '2024-03-14 11:46:01', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (342, 4, 1, 'FIRST TERM 2024', 4, 10, 128, 'INTEGRATED SCIENCE', '2024', '2024-03-14 11:46:01', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (343, 4, 1, 'FIRST TERM 2024', 9, 10, 128, 'INTEGRATED SCIENCE', '2024', '2024-03-14 11:46:01', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (344, 4, 1, 'FIRST TERM 2024', 11, 10, 128, 'INTEGRATED SCIENCE', '2024', '2024-03-14 11:46:01', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (345, 4, 1, 'FIRST TERM 2024', 13, 10, 128, 'INTEGRATED SCIENCE', '2024', '2024-03-14 11:46:01', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (346, 4, 1, 'FIRST TERM 2024', 15, 10, 128, 'INTEGRATED SCIENCE', '2024', '2024-03-14 11:46:01', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (347, 4, 1, 'FIRST TERM 2024', 18, 10, 128, 'INTEGRATED SCIENCE', '2024', '2024-03-14 11:46:01', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (348, 4, 1, 'FIRST TERM 2024', 19, 10, 128, 'INTEGRATED SCIENCE', '2024', '2024-03-14 11:46:01', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (349, 4, 1, 'FIRST TERM 2024', 46, 10, 128, 'INTEGRATED SCIENCE', '2024', '2024-03-14 11:46:01', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (350, 4, 1, 'FIRST TERM 2024', 1, 10, 126, 'SOCIAL STUDIES', '2024', '2024-03-14 12:21:01', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (351, 4, 1, 'FIRST TERM 2024', 4, 10, 126, 'SOCIAL STUDIES', '2024', '2024-03-14 12:21:01', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (352, 4, 1, 'FIRST TERM 2024', 9, 10, 126, 'SOCIAL STUDIES', '2024', '2024-03-14 12:21:01', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (353, 4, 1, 'FIRST TERM 2024', 11, 10, 126, 'SOCIAL STUDIES', '2024', '2024-03-14 12:21:01', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (354, 4, 1, 'FIRST TERM 2024', 13, 10, 126, 'SOCIAL STUDIES', '2024', '2024-03-14 12:21:01', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (355, 4, 1, 'FIRST TERM 2024', 15, 10, 126, 'SOCIAL STUDIES', '2024', '2024-03-14 12:21:01', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (356, 4, 1, 'FIRST TERM 2024', 18, 10, 126, 'SOCIAL STUDIES', '2024', '2024-03-14 12:21:01', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (357, 4, 1, 'FIRST TERM 2024', 19, 10, 126, 'SOCIAL STUDIES', '2024', '2024-03-14 12:21:01', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (358, 4, 1, 'FIRST TERM 2024', 46, 10, 126, 'SOCIAL STUDIES', '2024', '2024-03-14 12:21:01', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (359, 4, 1, 'FIRST TERM 2024', 1, 10, 129, 'PRE TECHNICAL', '2024', '2024-03-14 12:33:37', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (360, 4, 1, 'FIRST TERM 2024', 4, 10, 129, 'PRE TECHNICAL', '2024', '2024-03-14 12:33:37', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (361, 4, 1, 'FIRST TERM 2024', 9, 10, 129, 'PRE TECHNICAL', '2024', '2024-03-14 12:33:37', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (362, 4, 1, 'FIRST TERM 2024', 11, 10, 129, 'PRE TECHNICAL', '2024', '2024-03-14 12:33:37', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (363, 4, 1, 'FIRST TERM 2024', 13, 10, 129, 'PRE TECHNICAL', '2024', '2024-03-14 12:33:37', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (364, 4, 1, 'FIRST TERM 2024', 15, 10, 129, 'PRE TECHNICAL', '2024', '2024-03-14 12:33:37', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (365, 4, 1, 'FIRST TERM 2024', 18, 10, 129, 'PRE TECHNICAL', '2024', '2024-03-14 12:33:37', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (366, 4, 1, 'FIRST TERM 2024', 19, 10, 129, 'PRE TECHNICAL', '2024', '2024-03-14 12:33:37', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (367, 4, 1, 'FIRST TERM 2024', 46, 10, 129, 'PRE TECHNICAL', '2024', '2024-03-14 12:33:37', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (368, 4, 1, 'FIRST TERM 2024', 1, 10, 160, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 15:36:33', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (369, 4, 1, 'FIRST TERM 2024', 4, 10, 160, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 15:36:33', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (370, 4, 1, 'FIRST TERM 2024', 9, 10, 160, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 15:36:33', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (371, 4, 1, 'FIRST TERM 2024', 11, 10, 160, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 15:36:33', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (372, 4, 1, 'FIRST TERM 2024', 13, 10, 160, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 15:36:33', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (373, 4, 1, 'FIRST TERM 2024', 15, 10, 160, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 15:36:33', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (374, 4, 1, 'FIRST TERM 2024', 18, 10, 160, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 15:36:33', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (375, 4, 1, 'FIRST TERM 2024', 19, 10, 160, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 15:36:33', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (376, 4, 1, 'FIRST TERM 2024', 46, 10, 160, 'CREATIVE ARTS & SPORTS', '2024', '2024-03-14 15:36:33', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (377, 4, 1, 'FIRST TERM 2024', 2, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (378, 4, 1, 'FIRST TERM 2024', 3, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (379, 4, 1, 'FIRST TERM 2024', 5, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (380, 4, 1, 'FIRST TERM 2024', 6, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (381, 4, 1, 'FIRST TERM 2024', 7, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (382, 4, 1, 'FIRST TERM 2024', 8, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (383, 4, 1, 'FIRST TERM 2024', 10, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (384, 4, 1, 'FIRST TERM 2024', 12, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (385, 4, 1, 'FIRST TERM 2024', 14, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (386, 4, 1, 'FIRST TERM 2024', 16, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (387, 4, 1, 'FIRST TERM 2024', 17, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (388, 4, 1, 'FIRST TERM 2024', 20, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (389, 4, 1, 'FIRST TERM 2024', 21, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (390, 4, 1, 'FIRST TERM 2024', 22, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (391, 4, 1, 'FIRST TERM 2024', 23, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (392, 4, 1, 'FIRST TERM 2024', 24, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (393, 4, 1, 'FIRST TERM 2024', 25, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (394, 4, 1, 'FIRST TERM 2024', 26, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (395, 4, 1, 'FIRST TERM 2024', 27, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (396, 4, 1, 'FIRST TERM 2024', 28, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (397, 4, 1, 'FIRST TERM 2024', 29, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (398, 4, 1, 'FIRST TERM 2024', 30, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (399, 4, 1, 'FIRST TERM 2024', 31, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (400, 4, 1, 'FIRST TERM 2024', 32, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (401, 4, 1, 'FIRST TERM 2024', 33, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (402, 4, 1, 'FIRST TERM 2024', 34, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (403, 4, 1, 'FIRST TERM 2024', 35, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (404, 4, 1, 'FIRST TERM 2024', 36, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (405, 4, 1, 'FIRST TERM 2024', 37, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (406, 4, 1, 'FIRST TERM 2024', 38, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (407, 4, 1, 'FIRST TERM 2024', 39, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (408, 4, 1, 'FIRST TERM 2024', 40, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (409, 4, 1, 'FIRST TERM 2024', 41, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (410, 4, 1, 'FIRST TERM 2024', 42, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (411, 4, 1, 'FIRST TERM 2024', 43, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (412, 4, 1, 'FIRST TERM 2024', 44, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (413, 4, 1, 'FIRST TERM 2024', 45, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (414, 4, 1, 'FIRST TERM 2024', 47, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (415, 4, 1, 'FIRST TERM 2024', 48, 9, 156, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 05:57:49', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (416, 4, 1, 'FIRST TERM 2024', 1, 10, 122, 'ENGLISH', '2024', '2024-03-15 08:11:27', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (417, 4, 1, 'FIRST TERM 2024', 4, 10, 122, 'ENGLISH', '2024', '2024-03-15 08:11:27', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (418, 4, 1, 'FIRST TERM 2024', 9, 10, 122, 'ENGLISH', '2024', '2024-03-15 08:11:27', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (419, 4, 1, 'FIRST TERM 2024', 11, 10, 122, 'ENGLISH', '2024', '2024-03-15 08:11:27', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (420, 4, 1, 'FIRST TERM 2024', 13, 10, 122, 'ENGLISH', '2024', '2024-03-15 08:11:27', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (421, 4, 1, 'FIRST TERM 2024', 15, 10, 122, 'ENGLISH', '2024', '2024-03-15 08:11:27', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (422, 4, 1, 'FIRST TERM 2024', 18, 10, 122, 'ENGLISH', '2024', '2024-03-15 08:11:27', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (423, 4, 1, 'FIRST TERM 2024', 19, 10, 122, 'ENGLISH', '2024', '2024-03-15 08:11:27', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (424, 4, 1, 'FIRST TERM 2024', 46, 10, 122, 'ENGLISH', '2024', '2024-03-15 08:11:27', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (425, 4, 1, 'FIRST TERM 2024', 1, 10, 159, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 13:07:00', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (426, 4, 1, 'FIRST TERM 2024', 4, 10, 159, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 13:07:00', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (427, 4, 1, 'FIRST TERM 2024', 9, 10, 159, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 13:07:00', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (428, 4, 1, 'FIRST TERM 2024', 11, 10, 159, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 13:07:00', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (429, 4, 1, 'FIRST TERM 2024', 13, 10, 159, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 13:07:00', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (430, 4, 1, 'FIRST TERM 2024', 15, 10, 159, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 13:07:00', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (431, 4, 1, 'FIRST TERM 2024', 18, 10, 159, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 13:07:00', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (432, 4, 1, 'FIRST TERM 2024', 19, 10, 159, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 13:07:00', 11, 12);
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES (433, 4, 1, 'FIRST TERM 2024', 46, 10, 159, 'AGRICULTURE/NUTRITION', '2024', '2024-03-15 13:07:00', 11, 12);


#
# TABLE STRUCTURE FOR: markpercentage
#

DROP TABLE IF EXISTS `markpercentage`;

CREATE TABLE `markpercentage` (
  `markpercentageID` int(11) NOT NULL AUTO_INCREMENT,
  `markpercentagetype` varchar(100) NOT NULL,
  `percentage` double NOT NULL,
  `examID` int(11) DEFAULT NULL,
  `classesID` int(11) DEFAULT NULL,
  `subjectID` int(11) DEFAULT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_username` varchar(60) NOT NULL,
  `create_usertype` varchar(60) NOT NULL,
  PRIMARY KEY (`markpercentageID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `markpercentage` (`markpercentageID`, `markpercentagetype`, `percentage`, `examID`, `classesID`, `subjectID`, `create_date`, `modify_date`, `create_userID`, `create_username`, `create_usertype`) VALUES (1, 'OPENER ASSESSMENT', '100', NULL, NULL, NULL, '2017-01-05 06:11:54', '2024-03-08 11:32:31', 1, 'admin', 'Admin');
INSERT INTO `markpercentage` (`markpercentageID`, `markpercentagetype`, `percentage`, `examID`, `classesID`, `subjectID`, `create_date`, `modify_date`, `create_userID`, `create_username`, `create_usertype`) VALUES (2, 'MID-TERM ASSESSMENT', '100', NULL, NULL, NULL, '2024-02-29 11:33:26', '2024-03-08 11:31:58', 1, 'skooly', 'Admin');
INSERT INTO `markpercentage` (`markpercentageID`, `markpercentagetype`, `percentage`, `examID`, `classesID`, `subjectID`, `create_date`, `modify_date`, `create_userID`, `create_username`, `create_usertype`) VALUES (3, 'END OF TERM ASSESSMENT', '100', NULL, NULL, NULL, '2024-02-29 11:33:45', '2024-03-08 11:32:17', 1, 'skooly', 'Admin');


#
# TABLE STRUCTURE FOR: markrelation
#

DROP TABLE IF EXISTS `markrelation`;

CREATE TABLE `markrelation` (
  `markrelationID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `markID` int(11) NOT NULL,
  `markpercentageID` int(11) NOT NULL,
  `mark` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`markrelationID`)
) ENGINE=InnoDB AUTO_INCREMENT=1300 DEFAULT CHARSET=utf8;

INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1, 1, 1, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (2, 1, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (3, 1, 3, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (4, 2, 1, '34');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (5, 2, 2, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (6, 2, 3, '20');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (7, 3, 1, '8');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (8, 3, 2, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (9, 3, 3, '14');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (10, 4, 1, '86');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (11, 4, 2, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (12, 4, 3, '94');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (13, 5, 1, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (14, 5, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (15, 5, 3, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (16, 6, 1, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (17, 6, 2, '83');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (18, 6, 3, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (19, 7, 1, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (20, 7, 2, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (21, 7, 3, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (22, 8, 1, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (23, 8, 2, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (24, 8, 3, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (25, 9, 1, '0');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (26, 9, 2, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (27, 9, 3, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (28, 10, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (29, 10, 2, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (30, 10, 3, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (31, 11, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (32, 11, 2, '95');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (33, 11, 3, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (34, 12, 1, '73');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (35, 12, 2, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (36, 12, 3, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (37, 13, 1, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (38, 13, 2, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (39, 13, 3, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (40, 14, 1, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (41, 14, 2, '45');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (42, 14, 3, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (43, 15, 1, '86');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (44, 15, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (45, 15, 3, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (46, 16, 1, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (47, 16, 2, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (48, 16, 3, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (49, 17, 1, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (50, 17, 2, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (51, 17, 3, '16');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (52, 18, 1, '42');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (53, 18, 2, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (54, 18, 3, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (55, 19, 1, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (56, 19, 2, '93');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (57, 19, 3, '100');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (58, 20, 1, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (59, 20, 2, '93');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (60, 20, 3, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (61, 21, 1, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (62, 21, 2, '93');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (63, 21, 3, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (64, 22, 1, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (65, 22, 2, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (66, 22, 3, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (67, 23, 1, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (68, 23, 2, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (69, 23, 3, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (70, 24, 1, '29');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (71, 24, 2, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (72, 24, 3, '39');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (73, 25, 1, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (74, 25, 2, '77');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (75, 25, 3, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (76, 26, 1, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (77, 26, 2, '97');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (78, 26, 3, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (79, 27, 1, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (80, 27, 2, '45');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (81, 27, 3, '32');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (82, 28, 1, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (83, 28, 2, '77');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (84, 28, 3, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (85, 29, 1, '92');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (86, 29, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (87, 29, 3, '91');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (88, 30, 1, '36');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (89, 30, 2, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (90, 30, 3, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (91, 31, 1, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (92, 31, 2, '45');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (93, 31, 3, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (94, 32, 1, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (95, 32, 2, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (96, 32, 3, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (97, 33, 1, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (98, 33, 2, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (99, 33, 3, '32');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (100, 34, 1, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (101, 34, 2, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (102, 34, 3, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (103, 35, 1, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (104, 35, 2, '79');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (105, 35, 3, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (106, 36, 1, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (107, 36, 2, '77');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (108, 36, 3, '86');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (109, 37, 1, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (110, 37, 2, '96');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (111, 37, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (112, 38, 1, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (113, 38, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (114, 38, 3, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (115, 39, 1, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (116, 39, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (117, 39, 3, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (118, 40, 1, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (119, 40, 2, '83');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (120, 40, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (121, 41, 1, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (122, 41, 2, '45');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (123, 41, 3, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (124, 42, 1, '1');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (125, 42, 2, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (126, 42, 3, '2');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (127, 43, 1, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (128, 43, 2, '57');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (129, 43, 3, '16');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (130, 44, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (131, 44, 2, '65');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (132, 44, 3, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (133, 45, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (134, 45, 2, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (135, 45, 3, '16');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (136, 46, 1, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (137, 46, 2, '97');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (138, 46, 3, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (139, 47, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (140, 47, 2, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (141, 47, 3, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (142, 48, 1, '0');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (143, 48, 2, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (144, 48, 3, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (145, 49, 1, '0');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (146, 49, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (147, 49, 3, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (148, 50, 1, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (149, 50, 2, '53');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (150, 50, 3, '67');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (151, 51, 1, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (152, 51, 2, '30');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (153, 51, 3, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (154, 52, 1, '28');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (155, 52, 2, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (156, 52, 3, '41');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (157, 53, 1, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (158, 53, 2, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (159, 53, 3, '77');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (160, 54, 1, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (161, 54, 2, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (162, 54, 3, '77');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (163, 55, 1, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (164, 55, 2, '55');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (165, 55, 3, '86');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (166, 56, 1, '28');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (167, 56, 2, '65');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (168, 56, 3, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (169, 57, 1, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (170, 57, 2, '97');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (171, 57, 3, '89');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (172, 58, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (173, 58, 2, '65');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (174, 58, 3, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (175, 59, 1, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (176, 59, 2, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (177, 59, 3, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (178, 60, 1, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (179, 60, 2, '53');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (180, 60, 3, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (181, 61, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (182, 61, 2, '43');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (183, 61, 3, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (184, 62, 1, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (185, 62, 2, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (186, 62, 3, '51');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (187, 63, 1, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (188, 63, 2, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (189, 63, 3, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (190, 64, 1, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (191, 64, 2, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (192, 64, 3, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (193, 65, 1, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (194, 65, 2, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (195, 65, 3, '42');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (196, 66, 1, '28');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (197, 66, 2, '53');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (198, 66, 3, '20');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (199, 67, 1, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (200, 67, 2, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (201, 67, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (202, 68, 1, '94');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (203, 68, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (204, 68, 3, '63');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (205, 69, 1, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (206, 69, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (207, 69, 3, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (208, 70, 1, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (209, 70, 2, '83');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (210, 70, 3, '65');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (211, 71, 1, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (212, 71, 2, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (213, 71, 3, '37');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (214, 72, 1, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (215, 72, 2, '28');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (216, 72, 3, '29');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (217, 73, 1, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (218, 73, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (219, 73, 3, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (220, 74, 1, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (221, 74, 2, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (222, 74, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (223, 75, 1, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (224, 75, 2, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (225, 75, 3, '29');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (226, 76, 1, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (227, 76, 2, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (228, 76, 3, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (229, 77, 1, '92');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (230, 77, 2, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (231, 77, 3, '79');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (232, 78, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (233, 78, 2, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (234, 78, 3, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (235, 79, 1, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (236, 79, 2, '87');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (237, 79, 3, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (238, 80, 1, '36');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (239, 80, 2, '45');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (240, 80, 3, '37');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (241, 81, 1, '30');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (242, 81, 2, '35');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (243, 81, 3, '31');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (244, 82, 1, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (245, 82, 2, '35');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (246, 82, 3, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (247, 83, 1, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (248, 83, 2, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (249, 83, 3, '71');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (250, 84, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (251, 84, 2, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (252, 84, 3, '57');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (253, 85, 1, '73');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (254, 85, 2, '57');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (255, 85, 3, '57');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (256, 86, 1, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (257, 86, 2, '93');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (258, 86, 3, '49');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (259, 87, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (260, 87, 2, '93');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (261, 87, 3, '2');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (262, 88, 1, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (263, 88, 2, '57');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (264, 88, 3, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (265, 89, 1, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (266, 89, 2, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (267, 89, 3, '55');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (268, 90, 1, '4');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (269, 90, 2, '12');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (270, 90, 3, '8');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (271, 91, 1, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (272, 91, 2, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (273, 91, 3, '35');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (274, 92, 1, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (275, 92, 2, '47');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (276, 92, 3, '59');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (277, 93, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (278, 93, 2, '38');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (279, 93, 3, '26');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (280, 94, 1, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (281, 94, 2, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (282, 94, 3, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (283, 95, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (284, 95, 2, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (285, 95, 3, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (286, 96, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (287, 96, 2, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (288, 96, 3, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (289, 97, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (290, 97, 2, '77');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (291, 97, 3, '31');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (292, 98, 1, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (293, 98, 2, '87');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (294, 98, 3, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (295, 99, 1, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (296, 99, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (297, 99, 3, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (298, 100, 1, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (299, 100, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (300, 100, 3, '45');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (301, 101, 1, '73');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (302, 101, 2, '87');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (303, 101, 3, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (304, 102, 1, '79');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (305, 102, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (306, 102, 3, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (307, 103, 1, '86');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (308, 103, 2, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (309, 103, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (310, 104, 1, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (311, 104, 2, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (312, 104, 3, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (313, 105, 1, '79');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (314, 105, 2, '93');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (315, 105, 3, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (316, 106, 1, '63');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (317, 106, 2, '87');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (318, 106, 3, '94');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (319, 107, 1, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (320, 107, 2, '65');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (321, 107, 3, '32');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (322, 108, 1, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (323, 108, 2, '83');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (324, 108, 3, '47');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (325, 109, 1, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (326, 109, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (327, 109, 3, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (328, 110, 1, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (329, 110, 2, '93');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (330, 110, 3, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (331, 111, 1, '69');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (332, 111, 2, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (333, 111, 3, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (334, 112, 1, '53');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (335, 112, 2, '83');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (336, 112, 3, '36');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (337, 113, 1, '42');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (338, 113, 2, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (339, 113, 3, '32');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (340, 114, 1, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (341, 114, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (342, 114, 3, '15');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (343, 115, 1, '91');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (344, 115, 2, '93');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (345, 115, 3, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (346, 116, 1, '94');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (347, 116, 2, '92');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (348, 116, 3, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (349, 117, 1, '83');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (350, 117, 2, '87');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (351, 117, 3, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (352, 118, 1, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (353, 118, 2, '83');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (354, 118, 3, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (355, 119, 1, '63');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (356, 119, 2, '83');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (357, 119, 3, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (358, 120, 1, '35');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (359, 120, 2, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (360, 120, 3, '5');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (361, 121, 1, '89');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (362, 121, 2, '93');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (363, 121, 3, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (364, 122, 1, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (365, 122, 2, '95');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (366, 122, 3, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (367, 123, 1, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (368, 123, 2, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (369, 123, 3, '28');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (370, 124, 1, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (371, 124, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (372, 124, 3, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (373, 125, 1, '87');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (374, 125, 2, '83');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (375, 125, 3, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (376, 126, 1, '1');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (377, 126, 2, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (378, 126, 3, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (379, 127, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (380, 127, 2, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (381, 127, 3, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (382, 128, 1, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (383, 128, 2, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (384, 128, 3, '20');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (385, 129, 1, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (386, 129, 2, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (387, 129, 3, '16');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (388, 130, 1, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (389, 130, 2, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (390, 130, 3, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (391, 131, 1, '94');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (392, 131, 2, '87');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (393, 131, 3, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (394, 132, 1, '75');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (395, 132, 2, '83');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (396, 132, 3, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (397, 133, 1, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (398, 133, 2, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (399, 133, 3, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (400, 134, 1, '67');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (401, 134, 2, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (402, 134, 3, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (403, 135, 1, '63');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (404, 135, 2, '79');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (405, 135, 3, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (406, 136, 1, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (407, 136, 2, '95');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (408, 136, 3, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (409, 137, 1, '69');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (410, 137, 2, '75');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (411, 137, 3, '24');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (412, 138, 1, '4');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (413, 138, 2, '1');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (414, 138, 3, '2');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (415, 139, 1, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (416, 139, 2, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (417, 139, 3, '32');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (418, 140, 1, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (419, 140, 2, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (420, 140, 3, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (421, 141, 1, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (422, 141, 2, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (423, 141, 3, '12');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (424, 142, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (425, 142, 2, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (426, 142, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (427, 143, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (428, 143, 2, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (429, 143, 3, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (430, 144, 1, '1');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (431, 144, 2, '75');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (432, 144, 3, '45');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (433, 145, 1, '1');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (434, 145, 2, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (435, 145, 3, '36');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (436, 146, 1, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (437, 146, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (438, 146, 3, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (439, 147, 1, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (440, 147, 2, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (441, 147, 3, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (442, 148, 1, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (443, 148, 2, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (444, 148, 3, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (445, 149, 1, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (446, 149, 2, '69');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (447, 149, 3, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (448, 150, 1, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (449, 150, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (450, 150, 3, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (451, 151, 1, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (452, 151, 2, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (453, 151, 3, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (454, 152, 1, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (455, 152, 2, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (456, 152, 3, '34');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (457, 153, 1, '20');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (458, 153, 2, '75');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (459, 153, 3, '36');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (460, 154, 1, '94');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (461, 154, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (462, 154, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (463, 155, 1, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (464, 155, 2, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (465, 155, 3, '98');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (466, 156, 1, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (467, 156, 2, '95');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (468, 156, 3, '86');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (469, 157, 1, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (470, 157, 2, '92');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (471, 157, 3, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (472, 158, 1, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (473, 158, 2, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (474, 158, 3, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (475, 159, 1, '30');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (476, 159, 2, '63');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (477, 159, 3, '5');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (478, 160, 1, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (479, 160, 2, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (480, 160, 3, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (481, 161, 1, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (482, 161, 2, '79');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (483, 161, 3, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (484, 162, 1, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (485, 162, 2, '69');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (486, 162, 3, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (487, 163, 1, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (488, 163, 2, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (489, 163, 3, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (490, 164, 1, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (491, 164, 2, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (492, 164, 3, '86');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (493, 165, 1, '1');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (494, 165, 2, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (495, 165, 3, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (496, 166, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (497, 166, 2, '71');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (498, 166, 3, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (499, 167, 1, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (500, 167, 2, '69');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (501, 167, 3, '38');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (502, 168, 1, '30');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (503, 168, 2, '69');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (504, 168, 3, '32');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (505, 169, 1, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (506, 169, 2, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (507, 169, 3, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (508, 170, 1, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (509, 170, 2, '79');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (510, 170, 3, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (511, 171, 1, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (512, 171, 2, '79');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (513, 171, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (514, 172, 1, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (515, 172, 2, '73');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (516, 172, 3, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (517, 173, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (518, 173, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (519, 173, 3, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (520, 174, 1, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (521, 174, 2, '75');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (522, 174, 3, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (523, 175, 1, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (524, 175, 2, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (525, 175, 3, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (526, 176, 1, '34');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (527, 176, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (528, 176, 3, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (529, 177, 1, '10');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (530, 177, 2, '59');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (531, 177, 3, '5');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (532, 178, 1, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (533, 178, 2, '73');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (534, 178, 3, '32');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (535, 179, 1, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (536, 179, 2, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (537, 179, 3, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (538, 180, 1, '0');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (539, 180, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (540, 180, 3, '22');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (541, 181, 1, '86');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (542, 181, 2, '75');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (543, 181, 3, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (544, 182, 1, '1');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (545, 182, 2, '1');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (546, 182, 3, '71');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (547, 183, 1, '1');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (548, 183, 2, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (549, 183, 3, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (550, 184, 1, '1');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (551, 184, 2, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (552, 184, 3, '30');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (553, 185, 1, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (554, 185, 2, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (555, 185, 3, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (556, 186, 1, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (557, 186, 2, '69');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (558, 186, 3, '47');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (559, 187, 1, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (560, 187, 2, '49');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (561, 187, 3, '51');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (562, 188, 1, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (563, 188, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (564, 188, 3, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (565, 189, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (566, 189, 2, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (567, 189, 3, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (568, 190, 1, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (569, 190, 2, '69');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (570, 190, 3, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (571, 191, 1, '20');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (572, 191, 2, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (573, 191, 3, '36');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (574, 192, 1, '12');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (575, 192, 2, '59');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (576, 192, 3, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (577, 193, 1, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (578, 193, 2, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (579, 193, 3, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (580, 194, 1, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (581, 194, 2, '89');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (582, 194, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (583, 195, 1, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (584, 195, 2, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (585, 195, 3, '69');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (586, 196, 1, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (587, 196, 2, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (588, 196, 3, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (589, 197, 1, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (590, 197, 2, '69');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (591, 197, 3, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (592, 198, 1, '30');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (593, 198, 2, '59');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (594, 198, 3, '28');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (595, 199, 1, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (596, 199, 2, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (597, 199, 3, '67');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (598, 200, 1, '86');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (599, 200, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (600, 200, 3, '83');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (601, 201, 1, '28');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (602, 201, 2, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (603, 201, 3, '51');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (604, 202, 1, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (605, 202, 2, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (606, 202, 3, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (607, 203, 1, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (608, 203, 2, '79');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (609, 203, 3, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (610, 204, 1, '1');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (611, 204, 2, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (612, 204, 3, '47');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (613, 205, 1, '55');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (614, 205, 2, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (615, 205, 3, '65');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (616, 206, 1, '38');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (617, 206, 2, '63');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (618, 206, 3, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (619, 207, 1, '18');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (620, 207, 2, '42');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (621, 207, 3, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (622, 208, 1, '42');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (623, 208, 2, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (624, 208, 3, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (625, 209, 1, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (626, 209, 2, '79');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (627, 209, 3, '61');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (628, 210, 1, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (629, 210, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (630, 210, 3, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (631, 211, 1, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (632, 211, 2, '79');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (633, 211, 3, '73');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (634, 212, 1, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (635, 212, 2, '75');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (636, 212, 3, '63');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (637, 213, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (638, 213, 2, '65');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (639, 213, 3, '63');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (640, 214, 1, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (641, 214, 2, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (642, 214, 3, '71');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (643, 215, 1, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (644, 215, 2, '69');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (645, 215, 3, '51');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (646, 216, 1, '1');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (647, 216, 2, '5');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (648, 216, 3, '4');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (649, 217, 1, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (650, 217, 2, '45');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (651, 217, 3, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (652, 218, 1, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (653, 218, 2, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (654, 218, 3, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (655, 219, 1, '6');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (656, 219, 2, '38');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (657, 219, 3, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (658, 220, 1, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (659, 220, 2, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (660, 220, 3, '61');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (661, 221, 1, '0');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (662, 221, 2, '0');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (663, 221, 3, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (664, 222, 1, '1');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (665, 222, 2, '65');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (666, 222, 3, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (667, 223, 1, '1');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (668, 223, 2, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (669, 223, 3, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (670, 224, 1, '42');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (671, 224, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (672, 224, 3, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (673, 225, 1, '26');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (674, 225, 2, '75');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (675, 225, 3, '34');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (676, 226, 1, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (677, 226, 2, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (678, 226, 3, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (679, 227, 1, '59');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (680, 227, 2, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (681, 227, 3, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (682, 228, 1, '75');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (683, 228, 2, '91');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (684, 228, 3, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (685, 229, 1, '30');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (686, 229, 2, '83');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (687, 229, 3, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (688, 230, 1, '30');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (689, 230, 2, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (690, 230, 3, '36');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (691, 231, 1, '12');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (692, 231, 2, '42');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (693, 231, 3, '32');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (694, 232, 1, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (695, 232, 2, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (696, 232, 3, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (697, 233, 1, '71');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (698, 233, 2, '98');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (699, 233, 3, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (700, 234, 1, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (701, 234, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (702, 234, 3, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (703, 235, 1, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (704, 235, 2, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (705, 235, 3, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (706, 236, 1, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (707, 236, 2, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (708, 236, 3, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (709, 237, 1, '25');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (710, 237, 2, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (711, 237, 3, '30');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (712, 238, 1, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (713, 238, 2, '91');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (714, 238, 3, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (715, 239, 1, '55');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (716, 239, 2, '83');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (717, 239, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (718, 240, 1, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (719, 240, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (720, 240, 3, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (721, 241, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (722, 241, 2, '75');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (723, 241, 3, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (724, 242, 1, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (725, 242, 2, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (726, 242, 3, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (727, 243, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (728, 243, 2, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (729, 243, 3, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (730, 244, 1, '41');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (731, 244, 2, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (732, 244, 3, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (733, 245, 1, '42');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (734, 245, 2, '75');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (735, 245, 3, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (736, 246, 1, '32');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (737, 246, 2, '63');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (738, 246, 3, '36');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (739, 247, 1, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (740, 247, 2, '57');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (741, 247, 3, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (742, 248, 1, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (743, 248, 2, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (744, 248, 3, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (745, 249, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (746, 249, 2, '86');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (747, 249, 3, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (748, 250, 1, '61');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (749, 250, 2, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (750, 250, 3, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (751, 251, 1, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (752, 251, 2, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (753, 251, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (754, 252, 1, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (755, 252, 2, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (756, 252, 3, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (757, 253, 1, '47');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (758, 253, 2, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (759, 253, 3, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (760, 254, 1, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (761, 254, 2, '53');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (762, 254, 3, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (763, 255, 1, '2');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (764, 255, 2, '42');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (765, 255, 3, '4');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (766, 256, 1, '32');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (767, 256, 2, '63');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (768, 256, 3, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (769, 257, 1, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (770, 257, 2, '87');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (771, 257, 3, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (772, 258, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (773, 258, 2, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (774, 258, 3, '28');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (775, 259, 1, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (776, 259, 2, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (777, 259, 3, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (778, 260, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (779, 260, 2, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (780, 260, 3, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (781, 261, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (782, 261, 2, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (783, 261, 3, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (784, 262, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (785, 262, 2, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (786, 262, 3, '34');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (787, 263, 1, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (788, 263, 2, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (789, 263, 3, '26');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (790, 264, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (791, 264, 2, '73');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (792, 264, 3, '28');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (793, 265, 1, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (794, 265, 2, '33');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (795, 265, 3, '22');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (796, 266, 1, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (797, 266, 2, '55');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (798, 266, 3, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (799, 267, 1, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (800, 267, 2, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (801, 267, 3, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (802, 268, 1, '42');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (803, 268, 2, '83');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (804, 268, 3, '12');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (805, 269, 1, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (806, 269, 2, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (807, 269, 3, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (808, 270, 1, '8');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (809, 270, 2, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (810, 270, 3, '2');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (811, 271, 1, '92');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (812, 271, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (813, 271, 3, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (814, 272, 1, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (815, 272, 2, '81');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (816, 272, 3, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (817, 273, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (818, 273, 2, '83');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (819, 273, 3, '42');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (820, 274, 1, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (821, 274, 2, '42');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (822, 274, 3, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (823, 275, 1, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (824, 275, 2, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (825, 275, 3, '8');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (826, 276, 1, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (827, 276, 2, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (828, 276, 3, '42');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (829, 277, 1, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (830, 277, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (831, 277, 3, '38');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (832, 278, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (833, 278, 2, '75');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (834, 278, 3, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (835, 279, 1, '28');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (836, 279, 2, '67');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (837, 279, 3, '20');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (838, 280, 1, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (839, 280, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (840, 280, 3, '28');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (841, 281, 1, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (842, 281, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (843, 281, 3, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (844, 282, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (845, 282, 2, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (846, 282, 3, '6');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (847, 283, 1, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (848, 283, 2, '33');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (849, 283, 3, '34');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (850, 284, 1, '28');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (851, 284, 2, '79');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (852, 284, 3, '12');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (853, 285, 1, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (854, 285, 2, '93');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (855, 285, 3, '14');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (856, 286, 1, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (857, 286, 2, '30');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (858, 286, 3, '42');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (859, 287, 1, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (860, 287, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (861, 287, 3, '42');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (862, 288, 1, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (863, 288, 2, '95');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (864, 288, 3, '38');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (865, 289, 1, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (866, 289, 2, '83');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (867, 289, 3, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (868, 290, 1, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (869, 290, 2, '71');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (870, 290, 3, '30');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (871, 291, 1, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (872, 291, 2, '71');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (873, 291, 3, '24');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (874, 292, 1, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (875, 292, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (876, 292, 3, '26');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (877, 293, 1, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (878, 293, 2, '79');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (879, 293, 3, '22');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (880, 294, 1, '1');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (881, 294, 2, '20');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (882, 294, 3, '2');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (883, 295, 1, '38');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (884, 295, 2, '75');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (885, 295, 3, '20');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (886, 296, 1, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (887, 296, 2, '99');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (888, 296, 3, '24');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (889, 297, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (890, 297, 2, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (891, 297, 3, '24');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (892, 298, 1, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (893, 298, 2, '63');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (894, 298, 3, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (895, 299, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (896, 299, 2, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (897, 299, 3, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (898, 300, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (899, 300, 2, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (900, 300, 3, '34');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (901, 301, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (902, 301, 2, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (903, 301, 3, '10');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (904, 302, 1, '53');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (905, 302, 2, '94');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (906, 302, 3, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (907, 303, 1, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (908, 303, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (909, 303, 3, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (910, 304, 1, '65');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (911, 304, 2, '93');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (912, 304, 3, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (913, 305, 1, '57');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (914, 305, 2, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (915, 305, 3, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (916, 306, 1, '67');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (917, 306, 2, '67');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (918, 306, 3, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (919, 307, 1, '41');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (920, 307, 2, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (921, 307, 3, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (922, 308, 1, '35');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (923, 308, 2, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (924, 308, 3, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (925, 309, 1, '29');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (926, 309, 2, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (927, 309, 3, '38');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (928, 310, 1, '91');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (929, 310, 2, '93');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (930, 310, 3, '92');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (931, 311, 1, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (932, 311, 2, '67');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (933, 311, 3, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (934, 312, 1, '69');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (935, 312, 2, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (936, 312, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (937, 313, 1, '65');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (938, 313, 2, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (939, 313, 3, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (940, 314, 1, '57');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (941, 314, 2, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (942, 314, 3, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (943, 315, 1, '33');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (944, 315, 2, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (945, 315, 3, '26');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (946, 316, 1, '79');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (947, 316, 2, '97');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (948, 316, 3, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (949, 317, 1, '73');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (950, 317, 2, '94');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (951, 317, 3, '86');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (952, 318, 1, '55');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (953, 318, 2, '75');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (954, 318, 3, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (955, 319, 1, '67');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (956, 319, 2, '67');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (957, 319, 3, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (958, 320, 1, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (959, 320, 2, '97');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (960, 320, 3, '96');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (961, 321, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (962, 321, 2, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (963, 321, 3, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (964, 322, 1, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (965, 322, 2, '67');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (966, 322, 3, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (967, 323, 1, '32');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (968, 323, 2, '67');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (969, 323, 3, '36');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (970, 324, 1, '32');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (971, 324, 2, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (972, 324, 3, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (973, 325, 1, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (974, 325, 2, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (975, 325, 3, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (976, 326, 1, '67');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (977, 326, 2, '67');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (978, 326, 3, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (979, 327, 1, '75');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (980, 327, 2, '67');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (981, 327, 3, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (982, 328, 1, '96');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (983, 328, 2, '95');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (984, 328, 3, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (985, 329, 1, '71');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (986, 329, 2, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (987, 329, 3, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (988, 330, 1, '61');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (989, 330, 2, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (990, 330, 3, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (991, 331, 1, '55');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (992, 331, 2, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (993, 331, 3, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (994, 332, 1, '51');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (995, 332, 2, '95');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (996, 332, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (997, 333, 1, '3');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (998, 333, 2, '29');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (999, 333, 3, '2');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1000, 334, 1, '35');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1001, 334, 2, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1002, 334, 3, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1003, 335, 1, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1004, 335, 2, '96');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1005, 335, 3, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1006, 336, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1007, 336, 2, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1008, 336, 3, '32');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1009, 337, 1, '69');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1010, 337, 2, '96');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1011, 337, 3, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1012, 338, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1013, 338, 2, '96');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1014, 338, 3, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1015, 339, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1016, 339, 2, '96');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1017, 339, 3, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1018, 340, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1019, 340, 2, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1020, 340, 3, '42');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1021, 341, 1, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1022, 341, 2, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1023, 341, 3, '86');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1024, 342, 1, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1025, 342, 2, '55');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1026, 342, 3, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1027, 343, 1, '32');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1028, 343, 2, '55');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1029, 343, 3, '42');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1030, 344, 1, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1031, 344, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1032, 344, 3, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1033, 345, 1, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1034, 345, 2, '86');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1035, 345, 3, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1036, 346, 1, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1037, 346, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1038, 346, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1039, 347, 1, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1040, 347, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1041, 347, 3, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1042, 348, 1, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1043, 348, 2, '86');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1044, 348, 3, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1045, 349, 1, '0');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1046, 349, 2, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1047, 349, 3, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1048, 350, 1, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1049, 350, 2, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1050, 350, 3, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1051, 351, 1, '38');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1052, 351, 2, '81');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1053, 351, 3, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1054, 352, 1, '36');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1055, 352, 2, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1056, 352, 3, '22');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1057, 353, 1, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1058, 353, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1059, 353, 3, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1060, 354, 1, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1061, 354, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1062, 354, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1063, 355, 1, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1064, 355, 2, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1065, 355, 3, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1066, 356, 1, '2');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1067, 356, 2, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1068, 356, 3, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1069, 357, 1, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1070, 357, 2, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1071, 357, 3, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1072, 358, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1073, 358, 2, '96');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1074, 358, 3, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1075, 359, 1, '86');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1076, 359, 2, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1077, 359, 3, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1078, 360, 1, '32');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1079, 360, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1080, 360, 3, '20');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1081, 361, 1, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1082, 361, 2, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1083, 361, 3, '20');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1084, 362, 1, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1085, 362, 2, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1086, 362, 3, '38');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1087, 363, 1, '92');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1088, 363, 2, '81');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1089, 363, 3, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1090, 364, 1, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1091, 364, 2, '91');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1092, 364, 3, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1093, 365, 1, '42');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1094, 365, 2, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1095, 365, 3, '26');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1096, 366, 1, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1097, 366, 2, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1098, 366, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1099, 367, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1100, 367, 2, '98');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1101, 367, 3, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1102, 368, 1, '86');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1103, 368, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1104, 368, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1105, 369, 1, '39');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1106, 369, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1107, 369, 3, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1108, 370, 1, '39');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1109, 370, 2, '98');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1110, 370, 3, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1111, 371, 1, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1112, 371, 2, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1113, 371, 3, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1114, 372, 1, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1115, 372, 2, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1116, 372, 3, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1117, 373, 1, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1118, 373, 2, '79');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1119, 373, 3, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1120, 374, 1, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1121, 374, 2, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1122, 374, 3, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1123, 375, 1, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1124, 375, 2, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1125, 375, 3, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1126, 376, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1127, 376, 2, '95');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1128, 376, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1129, 377, 1, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1130, 377, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1131, 377, 3, '56');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1132, 378, 1, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1133, 378, 2, '77');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1134, 378, 3, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1135, 379, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1136, 379, 2, '77');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1137, 379, 3, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1138, 380, 1, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1139, 380, 2, '87');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1140, 380, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1141, 381, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1142, 381, 2, '83');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1143, 381, 3, '64');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1144, 382, 1, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1145, 382, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1146, 382, 3, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1147, 383, 1, '32');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1148, 383, 2, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1149, 383, 3, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1150, 384, 1, '16');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1151, 384, 2, '67');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1152, 384, 3, '20');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1153, 385, 1, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1154, 385, 2, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1155, 385, 3, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1156, 386, 1, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1157, 386, 2, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1158, 386, 3, '92');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1159, 387, 1, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1160, 387, 2, '92');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1161, 387, 3, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1162, 388, 1, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1163, 388, 2, '87');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1164, 388, 3, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1165, 389, 1, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1166, 389, 2, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1167, 389, 3, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1168, 390, 1, '28');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1169, 390, 2, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1170, 390, 3, '18');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1171, 391, 1, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1172, 391, 2, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1173, 391, 3, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1174, 392, 1, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1175, 392, 2, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1176, 392, 3, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1177, 393, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1178, 393, 2, '75');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1179, 393, 3, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1180, 394, 1, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1181, 394, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1182, 394, 3, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1183, 395, 1, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1184, 395, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1185, 395, 3, '92');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1186, 396, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1187, 396, 2, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1188, 396, 3, '40');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1189, 397, 1, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1190, 397, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1191, 397, 3, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1192, 398, 1, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1193, 398, 2, '73');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1194, 398, 3, '26');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1195, 399, 1, '30');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1196, 399, 2, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1197, 399, 3, '34');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1198, 400, 1, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1199, 400, 2, '67');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1200, 400, 3, '62');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1201, 401, 1, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1202, 401, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1203, 401, 3, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1204, 402, 1, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1205, 402, 2, '73');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1206, 402, 3, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1207, 403, 1, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1208, 403, 2, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1209, 403, 3, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1210, 404, 1, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1211, 404, 2, '92');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1212, 404, 3, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1213, 405, 1, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1214, 405, 2, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1215, 405, 3, '66');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1216, 406, 1, '70');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1217, 406, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1218, 406, 3, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1219, 407, 1, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1220, 407, 2, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1221, 407, 3, '48');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1222, 408, 1, '2');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1223, 408, 2, '42');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1224, 408, 3, '6');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1225, 409, 1, '28');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1226, 409, 2, '67');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1227, 409, 3, '50');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1228, 410, 1, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1229, 410, 2, '78');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1230, 410, 3, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1231, 411, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1232, 411, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1233, 411, 3, '18');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1234, 412, 1, '55');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1235, 412, 2, '77');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1236, 412, 3, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1237, 413, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1238, 413, 2, '67');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1239, 413, 3, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1240, 414, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1241, 414, 2, '73');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1242, 414, 3, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1243, 415, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1244, 415, 2, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1245, 415, 3, '32');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1246, 416, 1, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1247, 416, 2, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1248, 416, 3, '63');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1249, 417, 1, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1250, 417, 2, '77');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1251, 417, 3, '47');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1252, 418, 1, '28');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1253, 418, 2, '75');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1254, 418, 3, '41');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1255, 419, 1, '60');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1256, 419, 2, '83');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1257, 419, 3, '61');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1258, 420, 1, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1259, 420, 2, '90');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1260, 420, 3, '58');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1261, 421, 1, '46');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1262, 421, 2, '77');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1263, 421, 3, '52');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1264, 422, 1, '28');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1265, 422, 2, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1266, 422, 3, '29');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1267, 423, 1, '88');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1268, 423, 2, '93');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1269, 423, 3, '74');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1270, 424, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1271, 424, 2, '95');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1272, 424, 3, '61');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1273, 425, 1, '69');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1274, 425, 2, '87');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1275, 425, 3, '76');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1276, 426, 1, '44');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1277, 426, 2, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1278, 426, 3, '54');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1279, 427, 1, '36');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1280, 427, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1281, 427, 3, '32');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1282, 428, 1, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1283, 428, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1284, 428, 3, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1285, 429, 1, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1286, 429, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1287, 429, 3, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1288, 430, 1, '72');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1289, 430, 2, '87');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1290, 430, 3, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1291, 431, 1, '47');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1292, 431, 2, '80');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1293, 431, 3, '68');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1294, 432, 1, '82');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1295, 432, 2, '83');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1296, 432, 3, '84');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1297, 433, 1, NULL);
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1298, 433, 2, '85');
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES (1299, 433, 3, '82');


#
# TABLE STRUCTURE FOR: marksetting
#

DROP TABLE IF EXISTS `marksetting`;

CREATE TABLE `marksetting` (
  `marksettingID` int(11) NOT NULL AUTO_INCREMENT,
  `examID` int(11) NOT NULL DEFAULT '0',
  `classesID` int(11) NOT NULL DEFAULT '0',
  `subjectID` int(11) DEFAULT '0',
  `marktypeID` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`marksettingID`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `marksetting` (`marksettingID`, `examID`, `classesID`, `subjectID`, `marktypeID`) VALUES (4, 1, 0, 0, 0);


#
# TABLE STRUCTURE FOR: marksettingrelation
#

DROP TABLE IF EXISTS `marksettingrelation`;

CREATE TABLE `marksettingrelation` (
  `marksettingrelationID` int(11) NOT NULL AUTO_INCREMENT,
  `marktypeID` int(11) NOT NULL DEFAULT '0',
  `marksettingID` int(11) NOT NULL DEFAULT '0',
  `markpercentageID` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`marksettingrelationID`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

INSERT INTO `marksettingrelation` (`marksettingrelationID`, `marktypeID`, `marksettingID`, `markpercentageID`) VALUES (7, 0, 4, 1);
INSERT INTO `marksettingrelation` (`marksettingrelationID`, `marktypeID`, `marksettingID`, `markpercentageID`) VALUES (8, 0, 4, 2);
INSERT INTO `marksettingrelation` (`marksettingrelationID`, `marktypeID`, `marksettingID`, `markpercentageID`) VALUES (9, 0, 4, 3);


#
# TABLE STRUCTURE FOR: media
#

DROP TABLE IF EXISTS `media`;

CREATE TABLE `media` (
  `mediaID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userID` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `mcategoryID` int(11) NOT NULL DEFAULT '0',
  `file_name` varchar(255) NOT NULL,
  `file_name_display` varchar(255) NOT NULL,
  PRIMARY KEY (`mediaID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: media_category
#

DROP TABLE IF EXISTS `media_category`;

CREATE TABLE `media_category` (
  `mcategoryID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userID` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `folder_name` varchar(255) NOT NULL,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`mcategoryID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: media_gallery
#

DROP TABLE IF EXISTS `media_gallery`;

CREATE TABLE `media_gallery` (
  `media_galleryID` int(11) NOT NULL AUTO_INCREMENT,
  `media_gallery_type` int(11) NOT NULL,
  `file_type` varchar(40) DEFAULT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `file_original_name` varchar(255) DEFAULT NULL,
  `file_title` text NOT NULL,
  `file_size` varchar(40) DEFAULT NULL,
  `file_width_height` varchar(40) DEFAULT NULL,
  `file_upload_date` datetime DEFAULT NULL,
  `file_caption` text,
  `file_alt_text` varchar(255) DEFAULT NULL,
  `file_description` text,
  `file_length` varchar(128) DEFAULT NULL,
  `file_artist` varchar(128) DEFAULT NULL,
  `file_album` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`media_galleryID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: media_share
#

DROP TABLE IF EXISTS `media_share`;

CREATE TABLE `media_share` (
  `shareID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `classesID` int(11) NOT NULL DEFAULT '0',
  `public` int(11) NOT NULL,
  `file_or_folder` int(11) NOT NULL,
  `item_id` int(11) NOT NULL,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`shareID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: menu
#

DROP TABLE IF EXISTS `menu`;

CREATE TABLE `menu` (
  `menuID` int(11) NOT NULL AUTO_INCREMENT,
  `menuName` varchar(128) NOT NULL,
  `link` varchar(512) NOT NULL,
  `icon` varchar(128) DEFAULT NULL,
  `pullRight` text,
  `status` int(11) NOT NULL DEFAULT '1',
  `parentID` int(11) NOT NULL DEFAULT '0',
  `priority` int(11) NOT NULL DEFAULT '1000',
  PRIMARY KEY (`menuID`)
) ENGINE=InnoDB AUTO_INCREMENT=211 DEFAULT CHARSET=utf8;

INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (1, 'dashboard', 'dashboard', 'fa-laptop', '', 1, 0, 10000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (2, 'student', 'student', 'icon-student', NULL, 1, 0, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (3, 'parents', 'parents', 'fa-user', NULL, 1, 0, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (4, 'teacher', 'teacher', 'icon-teacher', NULL, 1, 0, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (5, 'user', 'user', 'fa-users', NULL, 1, 0, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (6, 'main_academic', '#', 'icon-academicmain', '', 1, 0, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (7, 'main_attendance', '#', 'icon-attendance', NULL, 1, 0, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (8, 'main_exam', '#', 'icon-exam', NULL, 1, 0, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (9, 'main_mark', '#', 'icon-markmain', NULL, 1, 0, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (10, 'conversation', 'conversation', 'fa-envelope', NULL, 1, 0, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (11, 'media', 'media', 'fa-film', NULL, 1, 0, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (12, 'mailandsms', '#', 'icon-mailandsms', '', 1, 0, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (13, 'main_library', '#', 'icon-library', '', 1, 0, 390);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (14, 'main_transport', '#', 'icon-bus', '', 1, 0, 350);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (15, 'main_hostel', '#', 'icon-hhostel', '', 1, 0, 320);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (16, 'main_account', '#', 'icon-account', '', 1, 0, 280);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (17, 'main_announcement', '#', 'icon-noticemain', '', 1, 0, 230);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (18, 'main_report', '#', 'fa-clipboard', '', 1, 0, 190);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (19, 'visitorinfo', 'visitorinfo', 'icon-visitorinfo', '', 1, 0, 150);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (20, 'main_administrator', '#', 'icon-administrator', '', 1, 0, 140);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (21, 'main_settings', '#', 'fa-gavel', '', 1, 0, 30);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (22, 'classes', 'classes', 'fa-sitemap', NULL, 1, 6, 5000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (23, 'section', 'section', 'fa-star', '', 1, 6, 4500);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (24, 'subject', 'subject', 'icon-subject', '', 1, 6, 4000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (25, 'routine', 'routine', 'icon-routine', NULL, 1, 6, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (26, 'syllabus', 'syllabus', 'icon-syllabus', NULL, 1, 6, 3500);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (27, 'assignment', 'assignment', 'icon-assignment', NULL, 1, 6, 3000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (28, 'sattendance', 'sattendance', 'icon-sattendance', NULL, 1, 7, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (29, 'tattendance', 'tattendance', 'icon-tattendance', NULL, 1, 7, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (30, 'exam', 'exam', 'fa-pencil', NULL, 1, 8, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (31, 'examschedule', 'examschedule', 'fa-puzzle-piece', NULL, 1, 8, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (32, 'grade', 'grade', 'fa-signal', NULL, 1, 8, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (33, 'eattendance', 'eattendance', 'icon-eattendance', NULL, 1, 8, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (34, 'mark', 'mark', 'fa-flask', NULL, 1, 9, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (35, 'markpercentage', 'markpercentage', 'icon-markpercentage', NULL, 1, 9, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (36, 'promotion', 'promotion', 'icon-promotion', NULL, 1, 9, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (37, 'notice', 'notice', 'fa-calendar', '', 1, 17, 220);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (38, 'event', 'event', 'fa-calendar-check-o', '', 1, 17, 210);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (39, 'holiday', 'holiday', 'icon-holiday', '', 1, 17, 200);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (40, 'classreport', 'classesreport', 'icon-classreport', '', 1, 18, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (41, 'attendancereport', 'attendancereport', 'icon-attendancereport', '', 1, 18, 940);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (42, 'studentreport', 'studentreport', 'icon-studentreport', '', 1, 18, 990);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (43, 'schoolyear', 'schoolyear', 'fa fa-calendar-plus-o', '', 1, 20, 130);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (44, 'mailandsmstemplate', 'mailandsmstemplate', 'icon-template', '', 1, 12, 100);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (45, 'backup', 'backup', 'fa-download', '', 1, 20, 80);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (46, 'systemadmin', 'systemadmin', 'icon-systemadmin', '', 1, 20, 120);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (47, 'resetpassword', 'resetpassword', 'icon-reset_password', '', 1, 20, 110);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (48, 'permission', 'permission', 'icon-permission', '', 1, 20, 60);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (49, 'usertype', 'usertype', 'icon-role', '', 1, 20, 70);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (50, 'setting', 'setting', 'fa-gears', '', 1, 21, 30);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (51, 'paymentsettings', 'paymentsettings', 'icon-paymentsettings', '', 1, 21, 20);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (52, 'smssettings', 'smssettings', 'fa-wrench', '', 1, 21, 10);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (53, 'invoice', 'invoice', 'icon-invoice', '', 1, 16, 260);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (54, 'paymenthistory', 'paymenthistory', 'icon-payment', '', 1, 16, 250);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (55, 'transport', 'transport', 'icon-sbus', '', 1, 14, 340);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (56, 'member', 'tmember', 'icon-member', '', 1, 14, 330);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (57, 'hostel', 'hostel', 'icon-hostel', '', 1, 15, 310);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (58, 'category', 'category', 'fa-leaf', '', 1, 15, 300);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (59, 'member', 'hmember', 'icon-member', '', 1, 15, 290);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (60, 'feetypes', 'feetypes', 'icon-feetypes', '', 1, 16, 270);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (61, 'expense', 'expense', 'icon-expense', '', 1, 16, 240);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (62, 'member', 'lmember', 'icon-member', '', 1, 13, 380);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (63, 'books', 'book', 'icon-lbooks', '', 1, 13, 370);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (64, 'issue', 'issue', 'icon-issue', '', 1, 13, 360);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (65, 'import', 'bulkimport', 'fa-upload', '', 1, 20, 90);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (66, 'update', 'update', 'fa-refresh', '', 1, 20, 50);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (67, 'main_child', '#', 'fa-child', '', 1, 0, 430);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (68, 'activitiescategory', 'activitiescategory', 'fa-pagelines', '', 1, 67, 420);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (69, 'activities', 'activities', 'fa-fighter-jet', '', 1, 67, 410);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (70, 'childcare', 'childcare', 'fa-wheelchair', '', 1, 67, 400);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (71, 'uattendance', 'uattendance', 'fa-user-secret', NULL, 1, 7, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (72, 'studentgroup', 'studentgroup', 'fa-object-group', '', 1, 20, 129);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (73, 'vendor', 'vendor', 'fa-rss', '', 1, 92, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (74, 'location', 'location', 'fa-newspaper-o', '', 1, 92, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (75, 'asset_category', 'asset_category', 'fa-life-ring', '', 1, 92, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (76, 'asset', 'asset', 'fa-fax', '', 1, 92, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (77, 'complain', 'complain', 'fa-commenting', '', 1, 20, 128);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (78, 'question_group', 'question_group', 'fa-question-circle', '', 1, 84, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (79, 'question_level', 'question_level', 'fa-level-up', '', 1, 84, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (80, 'question_bank', 'question_bank', 'fa-qrcode', '', 1, 84, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (81, 'online_exam', 'online_exam', 'fa-slideshare', '', 1, 84, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (82, 'instruction', 'instruction', 'fa-map-signs', '', 1, 84, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (83, 'take_exam', 'take_exam', 'fa-user-secret', '', 1, 84, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (84, 'main_online_exam', '#', 'fa-graduation-cap', '', 1, 0, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (85, 'certificatereport', 'certificatereport', 'fa-diamond', '', 1, 18, 860);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (86, 'certificate_template', 'certificate_template', 'fa-certificate', '', 1, 20, 128);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (87, 'main_payroll', '#', 'fa-usd', NULL, 1, 0, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (88, 'salary_template', 'salary_template', 'fa-calculator', '', 1, 87, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (89, 'hourly_template', 'hourly_template', 'fa fa-clock-o', '', 1, 87, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (90, 'manage_salary', 'manage_salary', 'fa-beer', '', 1, 87, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (91, 'make_payment', 'make_payment', 'fa-money', '', 1, 87, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (92, 'main_asset_management', '#', 'fa-archive', NULL, 1, 0, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (93, 'asset_assignment', 'asset_assignment', 'fa-plug', '', 1, 92, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (94, 'purchase', 'purchase', 'fa-cart-plus', '', 1, 92, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (95, 'main_frontend', '#', 'fa-home', '', 1, 0, 40);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (96, 'pages', 'pages', 'fa-connectdevelop', '', 1, 95, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (97, 'frontend_setting', 'frontend_setting', 'fa-asterisk', '', 1, 21, 25);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (98, 'routinereport', 'routinereport', 'iniicon-routinereport', '', 1, 18, 960);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (99, 'examschedulereport', 'examschedulereport', 'iniicon-examschedulereport', '', 1, 18, 950);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (100, 'feesreport', 'feesreport', 'iniicon-feesreport', '', 1, 18, 850);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (101, 'duefeesreport', 'duefeesreport', 'iniicon-duefeesreport', '', 1, 18, 840);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (102, 'balancefeesreport', 'balancefeesreport', 'iniicon-balancefeesreport', '', 1, 18, 830);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (103, 'transactionreport', 'transactionreport', 'iniicon-transactionreport', '', 1, 18, 820);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (104, 'sociallink', 'sociallink', 'iniicon-sociallink', '', 1, 20, 109);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (105, 'idcardreport', 'idcardreport', 'iniicon-idcardreport', '', 1, 18, 980);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (106, 'admitcardreport', 'admitcardreport', 'iniicon-admitcardreport', '', 1, 18, 970);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (107, 'studentfinereport', 'studentfinereport', 'iniicon-studentfinereport', '', 1, 18, 810);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (108, 'attendanceoverviewreport', 'attendanceoverviewreport', 'iniicon-attendanceoverviewreport', '', 1, 18, 930);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (109, 'income', 'income', 'iniicon-income', '', 1, 16, 239);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (110, 'global_payment', 'global_payment', 'fa-balance-scale', '', 1, 16, 238);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (111, 'terminalreport', 'terminalreport', 'iniicon-terminalreport', '', 1, 18, 920);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (112, 'tabulationsheetreport', 'tabulationsheetreport', 'iniicon-tabulationsheetreport', '', 1, 18, 900);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (113, 'marksheetreport', 'marksheetreport', 'iniicon-marksheetreport', '', 1, 18, 890);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (114, 'meritstagereport', 'meritstagereport', 'iniicon-meritstagereport', '', 1, 18, 910);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (115, 'progresscardreport', 'progresscardreport', 'iniicon-progresscardreport', '', 1, 18, 880);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (116, 'onlineexamreport', 'onlineexamreport', 'iniicon-onlineexamreport', '', 1, 18, 870);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (117, 'main_inventory', '#', 'iniicon-maininventory', '', 1, 0, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (118, 'productcategory', 'productcategory', 'iniicon-productcategory', '', 1, 117, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (119, 'product', 'product', 'iniicon-product', '', 1, 117, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (120, 'productwarehouse', 'productwarehouse', 'iniicon-productwarehouse', '', 1, 117, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (121, 'productsupplier', 'productsupplier', 'iniicon-productsupplier', '', 1, 117, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (122, 'productpurchase', 'productpurchase', 'iniicon-productpurchase', '', 1, 117, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (123, 'productsale', 'productsale', 'iniicon-productsale', '', 1, 117, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (124, 'main_leaveapplication', '#', 'iniicon-mainleaveapplication', '', 1, 0, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (125, 'leavecategory', 'leavecategory', 'iniicon-leavecategory', '', 1, 124, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (126, 'leaveassign', 'leaveassign', 'iniicon-leaveassign', '', 1, 124, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (127, 'leaveapply', 'leaveapply', 'iniicon-leaveapply', '', 1, 124, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (128, 'leaveapplication', 'leaveapplication', 'iniicon-leaveapplication', '', 1, 124, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (129, 'librarybooksreport', 'librarybooksreport', 'iniicon-librarybooksreport', '', 1, 18, 925);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (130, 'searchpaymentfeesreport', 'searchpaymentfeesreport', 'iniicon-searchpaymentfeesreport', '', 1, 18, 852);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (131, 'salaryreport', 'salaryreport', 'iniicon-salaryreport', '', 1, 18, 805);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (132, 'productpurchasereport', 'productpurchasereport', 'iniicon-productpurchasereport', '', 1, 18, 854);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (133, 'productsalereport', 'productsalereport', 'iniicon-productsalereport', '', 1, 18, 853);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (134, 'leaveapplicationreport', 'leaveapplicationreport', 'iniicon-leaveapplicationreport', '', 1, 18, 855);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (135, 'posts', 'posts', 'fa-thumb-tack', '', 1, 95, 1005);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (136, 'posts_categories', 'posts_categories', 'fa-anchor', '', 1, 95, 1010);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (137, 'menu', 'frontendmenu', 'iniicon-fmenu', '', 1, 95, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (138, 'librarycardreport', 'librarycardreport', 'iniicon-librarycardreport', '', 1, 18, 924);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (139, 'librarybookissuereport', 'librarybookissuereport', 'iniicon-librarybookissuereport', '', 1, 18, 923);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (140, 'onlineexamquestionreport', 'onlineexamquestionreport', 'iniicon-onlineexamquestionreport', '', 1, 18, 865);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (141, 'ebooks', 'ebooks', 'iniicon-ebook', '', 1, 13, 350);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (142, 'accountledgerreport', 'accountledgerreport', 'iniicon-accountledgerreport', '', 1, 18, 800);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (143, 'onlineadmission', 'onlineadmission', 'iniicon-onlineadmission', '', 1, 0, 160);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (144, 'emailsetting', 'emailsetting', 'iniicon-ini-emailsetting', '', 1, 21, 5);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (145, 'onlineadmissionreport', 'onlineadmissionreport', 'iniicon-onlineadmissionreport', '', 1, 18, 863);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (146, 'marksetting', 'marksetting', 'fa-futbol-o', '', 1, 21, 4);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (147, 'studentsessionreport', 'studentsessionreport', 'fa-recycle', '', 1, 18, 876);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (148, 'overtime', 'overtime', 'fa-retweet', '', 1, 87, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (149, 'overtimereport', 'overtimereport', 'fa-gg-circle', NULL, 1, 18, 808);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (150, 'addons', 'addons', 'fa-crosshairs', '', 1, 20, 55);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (151, 'main_sponsorship', '#', 'fa-gg-circle', '', 1, 0, 300);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (152, 'candidate', 'candidate', 'fa-odnoklassniki', NULL, 1, 151, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (153, 'sponsor', 'sponsor', 'fa-odnoklassniki', '', 1, 151, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (154, 'sponsorship', 'sponsorship', 'fa fa-gg', '', 1, 151, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (155, 'sponsorshipreport', 'sponsorshipreport', 'fa fa-safari', '', 1, 18, 995);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (156, 'onlineexamquestionanswerreport', 'onlineexamquestionanswerreport', 'fa-sticky-note-o', '', 1, 18, 864);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (157, 'Clock In/Out', 'attendance', 'fa-check', '', 1, 7, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (158, 'Student Attendance Report', 'student_attendance_report', 'icon-studentreport', NULL, 1, 18, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (159, 'Teacher Attendance Report', 'teacher_attendance_report', 'icon-attendancereport', '', 1, 18, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (160, 'User Attendance Report', 'user_attendance_report', 'icon-attendancereport', NULL, 1, 18, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (161, 'Scan ID', 'qrcode_attendance', 'fa-qrcode', NULL, 1, 7, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (162, 'Mpesa Transactions', 'mpesa', 'fa-money', NULL, 1, 16, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (163, 'Vendor Purchase Report', 'vendorpurchasereport', 'fa-life-ring', NULL, 1, 117, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (164, 'Item Purchase Report', 'itempurchasereport', 'fa-flag-o', NULL, 1, 117, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (165, 'Category Purchase Report', 'categorypurchasereport', 'fa-crosshairs', NULL, 1, 117, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (166, 'Item Sale Report', 'itemsalereport', 'fa-cart-plus', NULL, 1, 117, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (167, 'Category Sale Report', 'categorysalereport', 'fa-shopping-cart', NULL, 1, 117, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (168, 'Wallet Transactions', 'wallet', 'fa-credit-card', NULL, 1, 16, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (169, 'Meal Card', 'lunch', 'fa-cutlery', NULL, 1, 171, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (170, 'Price Settings', 'lunchsetting', 'fa-cog', NULL, 1, 171, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (171, 'Meals', '#', 'fa-cutlery', NULL, 1, 0, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (172, 'Meal Logs', 'lunchlogs', 'fa-exchange', NULL, 1, 171, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (205, 'School Term', 'schoolterm', 'fa fa-book', '', 1, 20, 130);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (206, 'Take Student Photo', 'studentids', 'fa-camera', NULL, 1, 0, 1000);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (207, 'cbcterminalreport', 'cbcterminalreport', 'iniicon-terminalreport', '', 1, 18, 921);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (208, 'sendsms', 'sendsms', 'icon-mailandsms', '', 1, 12, 1001);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (209, 'smsreport', 'mailandsms', 'fa-file', '', 1, 12, 1001);
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES (210, 'studentleaveout', 'studentleaveout', 'fa-users', '', 1, 124, 1000);


#
# TABLE STRUCTURE FOR: migrations
#

DROP TABLE IF EXISTS `migrations`;

CREATE TABLE `migrations` (
  `version` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `migrations` (`version`) VALUES (1);


#
# TABLE STRUCTURE FOR: mpesa_logs
#

DROP TABLE IF EXISTS `mpesa_logs`;

CREATE TABLE `mpesa_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `referenceNO` varchar(20) DEFAULT NULL,
  `TransID` varchar(20) DEFAULT NULL,
  `TransAmount` double(10,2) DEFAULT NULL,
  `BillRefNumber` varchar(50) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `TransTime` timestamp NULL DEFAULT NULL,
  `name` text,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: notice
#

DROP TABLE IF EXISTS `notice`;

CREATE TABLE `notice` (
  `noticeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(128) NOT NULL,
  `notice` text NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  `date` date NOT NULL,
  `create_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `create_userID` int(11) NOT NULL DEFAULT '0',
  `create_usertypeID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`noticeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: online_exam
#

DROP TABLE IF EXISTS `online_exam`;

CREATE TABLE `online_exam` (
  `onlineExamID` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(512) NOT NULL,
  `description` text,
  `classID` int(11) DEFAULT '0',
  `sectionID` int(11) DEFAULT '0',
  `studentGroupID` int(11) DEFAULT '0',
  `subjectID` int(11) DEFAULT '0',
  `userTypeID` int(11) DEFAULT '0',
  `instructionID` int(11) DEFAULT '0',
  `examStatus` varchar(11) NOT NULL,
  `schoolYearID` int(11) NOT NULL,
  `examTypeNumber` int(11) DEFAULT NULL,
  `startDateTime` datetime DEFAULT NULL,
  `endDateTime` datetime DEFAULT NULL,
  `duration` int(11) DEFAULT '0',
  `random` int(11) DEFAULT '0',
  `public` int(11) DEFAULT '0',
  `status` int(11) DEFAULT '1',
  `markType` int(11) NOT NULL,
  `negativeMark` int(11) DEFAULT '0',
  `bonusMark` int(11) DEFAULT '0',
  `point` int(11) DEFAULT '0',
  `percentage` int(11) DEFAULT '0',
  `showMarkAfterExam` int(11) DEFAULT '0',
  `judge` int(11) DEFAULT '1' COMMENT 'Auto Judge = 1, Manually Judge = 0',
  `paid` int(11) DEFAULT '0' COMMENT '0 = Unpaid, 1 = Paid',
  `validDays` int(11) DEFAULT '0',
  `cost` int(11) DEFAULT '0',
  `img` varchar(512) DEFAULT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  `published` int(11) NOT NULL,
  PRIMARY KEY (`onlineExamID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: online_exam_question
#

DROP TABLE IF EXISTS `online_exam_question`;

CREATE TABLE `online_exam_question` (
  `onlineExamQuestionID` int(11) NOT NULL AUTO_INCREMENT,
  `onlineExamID` int(11) NOT NULL,
  `questionID` int(11) DEFAULT NULL,
  PRIMARY KEY (`onlineExamQuestionID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: online_exam_type
#

DROP TABLE IF EXISTS `online_exam_type`;

CREATE TABLE `online_exam_type` (
  `onlineExamTypeID` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(512) DEFAULT NULL,
  `examTypeNumber` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`onlineExamTypeID`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `online_exam_type` (`onlineExamTypeID`, `title`, `examTypeNumber`, `status`) VALUES (1, 'Date , Time and Duration', 5, 1);
INSERT INTO `online_exam_type` (`onlineExamTypeID`, `title`, `examTypeNumber`, `status`) VALUES (2, 'Date and Duration', 4, 1);
INSERT INTO `online_exam_type` (`onlineExamTypeID`, `title`, `examTypeNumber`, `status`) VALUES (3, 'Only Date', 3, 0);
INSERT INTO `online_exam_type` (`onlineExamTypeID`, `title`, `examTypeNumber`, `status`) VALUES (4, 'Only Duration', 2, 1);
INSERT INTO `online_exam_type` (`onlineExamTypeID`, `title`, `examTypeNumber`, `status`) VALUES (5, 'None', 1, 0);


#
# TABLE STRUCTURE FOR: online_exam_user_answer
#

DROP TABLE IF EXISTS `online_exam_user_answer`;

CREATE TABLE `online_exam_user_answer` (
  `onlineExamUserAnswerID` int(11) NOT NULL AUTO_INCREMENT,
  `onlineExamQuestionID` int(11) NOT NULL,
  `onlineExamRegisteredUserID` int(11) DEFAULT NULL,
  `onlineExamID` int(11) NOT NULL,
  `examtimeID` int(11) NOT NULL,
  `userID` int(11) DEFAULT NULL,
  PRIMARY KEY (`onlineExamUserAnswerID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: online_exam_user_answer_option
#

DROP TABLE IF EXISTS `online_exam_user_answer_option`;

CREATE TABLE `online_exam_user_answer_option` (
  `onlineExamUserAnswerOptionID` int(11) NOT NULL AUTO_INCREMENT,
  `questionID` int(11) NOT NULL,
  `optionID` int(11) DEFAULT NULL,
  `typeID` int(11) NOT NULL,
  `text` text,
  `time` datetime NOT NULL,
  `onlineExamID` int(11) NOT NULL,
  `examtimeID` int(11) NOT NULL,
  `userID` int(11) NOT NULL,
  PRIMARY KEY (`onlineExamUserAnswerOptionID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: online_exam_user_status
#

DROP TABLE IF EXISTS `online_exam_user_status`;

CREATE TABLE `online_exam_user_status` (
  `onlineExamUserStatus` int(11) NOT NULL AUTO_INCREMENT,
  `onlineExamID` int(11) NOT NULL,
  `duration` int(11) NOT NULL,
  `score` int(11) NOT NULL,
  `totalQuestion` int(11) NOT NULL,
  `totalAnswer` int(11) NOT NULL,
  `nagetiveMark` int(11) NOT NULL,
  `time` datetime NOT NULL,
  `userID` int(11) NOT NULL,
  `classesID` int(11) DEFAULT NULL,
  `sectionID` int(11) DEFAULT NULL,
  `examtimeID` int(11) DEFAULT NULL,
  `totalCurrectAnswer` int(11) DEFAULT NULL,
  `totalMark` varchar(40) DEFAULT NULL,
  `totalObtainedMark` int(11) DEFAULT NULL,
  `totalPercentage` double DEFAULT NULL,
  `statusID` int(11) DEFAULT NULL,
  PRIMARY KEY (`onlineExamUserStatus`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: onlineadmission
#

DROP TABLE IF EXISTS `onlineadmission`;

CREATE TABLE `onlineadmission` (
  `onlineadmissionID` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `sex` varchar(10) DEFAULT NULL,
  `religion` varchar(25) DEFAULT NULL,
  `email` varchar(40) DEFAULT NULL,
  `phone` tinytext,
  `address` varchar(200) DEFAULT NULL,
  `classesID` int(11) DEFAULT NULL,
  `bloodgroup` varchar(5) DEFAULT NULL,
  `country` varchar(128) DEFAULT NULL,
  `photo` varchar(200) DEFAULT NULL,
  `document` varchar(200) DEFAULT NULL,
  `schoolyearID` int(11) DEFAULT NULL,
  `create_date` datetime DEFAULT NULL,
  `modify_date` datetime DEFAULT NULL,
  `studentID` int(11) NOT NULL DEFAULT '0',
  `status` int(11) DEFAULT '0' COMMENT '0 = New, 1=Approved, 2 = Waiting, 3 = Declined',
  PRIMARY KEY (`onlineadmissionID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: overtime
#

DROP TABLE IF EXISTS `overtime`;

CREATE TABLE `overtime` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` datetime NOT NULL,
  `hours` int(11) NOT NULL,
  `amount` double NOT NULL,
  `total_amount` double DEFAULT '0',
  `userID` int(11) NOT NULL,
  `user_table` varchar(40) NOT NULL DEFAULT 'ABCD',
  `usertypeID` int(11) NOT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: pages
#

DROP TABLE IF EXISTS `pages`;

CREATE TABLE `pages` (
  `pagesID` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(128) DEFAULT NULL,
  `url` varchar(250) DEFAULT NULL,
  `content` text,
  `status` int(11) DEFAULT NULL COMMENT '1 => active, 2 => draft, 3 => trash, 4 => review  ',
  `visibility` int(11) DEFAULT NULL COMMENT '1 => public 2 => protected 3 => private ',
  `publish_date` datetime DEFAULT NULL,
  `parentID` int(11) NOT NULL DEFAULT '0',
  `pageorder` int(11) NOT NULL DEFAULT '0',
  `template` varchar(250) DEFAULT NULL,
  `featured_image` varchar(11) DEFAULT NULL,
  `create_date` datetime DEFAULT NULL,
  `modify_date` datetime DEFAULT NULL,
  `create_userID` int(11) DEFAULT NULL,
  `create_username` varchar(60) DEFAULT NULL,
  `create_usertypeID` int(11) DEFAULT NULL,
  `password` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`pagesID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: parents
#

DROP TABLE IF EXISTS `parents`;

CREATE TABLE `parents` (
  `parentsID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL,
  `father_name` varchar(60) NOT NULL,
  `mother_name` varchar(60) NOT NULL,
  `father_profession` varchar(40) NOT NULL,
  `mother_profession` varchar(40) NOT NULL,
  `email` varchar(40) DEFAULT NULL,
  `phone` tinytext,
  `address` text,
  `photo` varchar(200) DEFAULT NULL,
  `username` varchar(40) NOT NULL,
  `password` varchar(128) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_username` varchar(60) NOT NULL,
  `create_usertype` varchar(60) NOT NULL,
  `active` int(11) NOT NULL,
  PRIMARY KEY (`parentsID`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `parents` (`parentsID`, `name`, `father_name`, `mother_name`, `father_profession`, `mother_profession`, `email`, `phone`, `address`, `photo`, `username`, `password`, `usertypeID`, `create_date`, `modify_date`, `create_userID`, `create_username`, `create_usertype`, `active`) VALUES (1, 'JAMES AMANI', '', '', '', '', '', '', '', 'default.png', '000001', '2a9e7c6e018e4127eac13315302c2a9a31e15a4d8c8f8024cf2cf993b1ae8d18bf866fd6d4f91f03000116c66d137d4dbb78b6fb4d726cf685192b66cffb5a08', 4, '2024-04-28 08:24:43', '2024-04-28 08:24:43', 1, 'skooly', 'Admin', 1);
INSERT INTO `parents` (`parentsID`, `name`, `father_name`, `mother_name`, `father_profession`, `mother_profession`, `email`, `phone`, `address`, `photo`, `username`, `password`, `usertypeID`, `create_date`, `modify_date`, `create_userID`, `create_username`, `create_usertype`, `active`) VALUES (2, 'PETER MORGAN', '', '', '', '', '', '', '', 'default.png', 'PETERTM', '29a45ca4e381a282457600684fe73359bc5ab93d47f4bc3b9e4905b355d6e8c3e34fd7b7f7f378cbdc10d588360326c894fc2dd8e7fc2be584851fada428fe0f', 4, '2024-04-28 08:42:54', '2024-04-28 08:42:54', 1, 'skooly', 'Admin', 1);
INSERT INTO `parents` (`parentsID`, `name`, `father_name`, `mother_name`, `father_profession`, `mother_profession`, `email`, `phone`, `address`, `photo`, `username`, `password`, `usertypeID`, `create_date`, `modify_date`, `create_userID`, `create_username`, `create_usertype`, `active`) VALUES (3, 'Damaris Hope', '', '', '', '', '', '791215031', '', 'default.png', 'Dama', 'cc95c682b4851df253c32c702df374e368175286e508994df4f7ae27de7b2974ee8f1094155d0f7e0fb03f7fc2c3380270a6734cf0ebd85fad519b81ee13f0ec', 4, '2024-06-14 06:46:39', '2024-06-14 06:47:25', 1, 'skooly', 'Admin', 1);
INSERT INTO `parents` (`parentsID`, `name`, `father_name`, `mother_name`, `father_profession`, `mother_profession`, `email`, `phone`, `address`, `photo`, `username`, `password`, `usertypeID`, `create_date`, `modify_date`, `create_userID`, `create_username`, `create_usertype`, `active`) VALUES (4, 'MARY KIPKOECH', 'KIPKALYAS KONES', 'MARY KIPKOECH', 'BUSINESS', 'NURSE', '', '0721234123', 'NYALI', 'default.png', '0721234123', 'fe9c5e66d9cc1f8040965fb696b9056e8045ab95e9acf4f4d8efd3f655094786a046a220e8cb8f4d293805b4c4fd1ce1aafd1944016e4c4777061c3ae7ccb071', 4, '2024-06-16 01:32:06', '2024-06-16 01:32:06', 1, 'skooly', 'Admin', 1);


#
# TABLE STRUCTURE FOR: payment
#

DROP TABLE IF EXISTS `payment`;

CREATE TABLE `payment` (
  `paymentID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `schoolyearID` int(11) NOT NULL,
  `invoiceID` int(11) NOT NULL,
  `studentID` int(11) NOT NULL,
  `paymentamount` double DEFAULT NULL,
  `paymenttype` varchar(128) NOT NULL,
  `paymentdate` date NOT NULL,
  `paymentday` varchar(11) NOT NULL,
  `paymentmonth` varchar(10) NOT NULL,
  `paymentyear` year(4) NOT NULL,
  `userID` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `uname` varchar(60) NOT NULL,
  `transactionID` text,
  `globalpaymentID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`paymentID`)
) ENGINE=InnoDB AUTO_INCREMENT=209 DEFAULT CHARSET=utf8;

INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (1, 4, 92, 2, NULL, 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET5033943766350179497', 1);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (2, 4, 93, 2, '13000', 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET8519179937206292211', 1);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (3, 4, 94, 2, '5000', 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET9260749036753122869', 1);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (4, 4, 95, 2, '2000', 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET2024256315949145401', 1);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (5, 4, 60, 10, NULL, 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET4346402886210739241', 2);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (6, 4, 61, 10, '2100', 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET9244027014260470313', 2);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (7, 4, 62, 10, '2000', 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET7433483125802422029', 2);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (8, 4, 84, 24, '35000', 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET7252063764343103621', 3);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (9, 4, 85, 24, '25000', 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET3265826443587301831', 3);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (10, 4, 86, 24, '5000', 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET7483845838835265167', 3);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (11, 4, 87, 24, '2000', 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET3214550057176441586', 3);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (12, 4, 135, 47, NULL, 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET4169269661425748208', 4);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (13, 4, 136, 47, '2500', 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET7953860244732237882', 4);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (14, 4, 137, 47, '2000', 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET4794086352785616914', 4);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (15, 4, 1, 3, '35000', 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET1229856519353498501', 5);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (16, 4, 2, 3, '5000', 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET1232336268733216017', 5);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (17, 4, 3, 3, '2000', 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET3098356018061454268', 5);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (18, 4, 104, 9, '35000', 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET8601376691209691728', 6);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (19, 4, 105, 9, '25000', 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET1718388828533826562', 6);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (20, 4, 106, 9, '5000', 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET1428280816319887408', 6);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (21, 4, 107, 9, '2000', 'Cheque', '2024-03-25', '25', '03', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET4301941440340176924', 6);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (22, 4, 138, 30, '23000', 'Cheque', '2024-05-02', '02', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET6452367251505350207', 10);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (23, 4, 139, 30, '25000', 'Cheque', '2024-05-02', '02', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET9698777016241482364', 10);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (24, 4, 140, 30, '2000', 'Cheque', '2024-05-02', '02', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET9914600554241495083', 10);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (25, 4, 7, 6, '14000', 'Cheque', '2024-05-02', '02', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET2097826500575484737', 11);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (26, 4, 8, 6, '5000', 'Cheque', '2024-05-02', '02', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET1536552138813166354', 11);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (27, 4, 9, 6, '2000', 'Cheque', '2024-05-02', '02', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET3744388932145619022', 11);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (28, 4, 214, 39, NULL, 'Cheque', '2024-05-02', '02', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET9378676256884431446', 12);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (29, 4, 215, 39, '13000', 'Cheque', '2024-05-02', '02', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET6979703682197330436', 12);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (30, 4, 216, 39, '5000', 'Cheque', '2024-05-02', '02', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET7409481492012308449', 12);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (31, 4, 217, 39, '2000', 'Cheque', '2024-05-02', '02', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET6028298973118761784', 12);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (32, 4, 10, 7, '18000', 'Cheque', '2024-05-02', '02', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET7006134285690089342', 13);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (33, 4, 11, 7, '5000', 'Cheque', '2024-05-02', '02', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET9890747493838213456', 13);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (34, 4, 12, 7, '2000', 'Cheque', '2024-05-02', '02', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET7787056026038821449', 13);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (35, 4, 92, 2, '25000', 'Cheque', '2024-05-02', '02', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET5410072094293661144', 14);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (36, 4, 93, 2, '12000', 'Cheque', '2024-05-02', '02', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET8058797600801464892', 14);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (37, 4, 218, 33, '35000', 'Cheque', '2024-05-02', '02', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET8069409150973801338', 15);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (38, 4, 219, 33, '25000', 'Cheque', '2024-05-02', '02', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET1651019355609859362', 15);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (39, 4, 220, 33, '5000', 'Cheque', '2024-05-02', '02', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET4472599338798199940', 15);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (40, 4, 221, 33, '2000', 'Cheque', '2024-05-02', '02', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET2991438047769563080', 15);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (41, 4, 222, 33, '3000', 'Cheque', '2024-05-02', '02', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET9632657784477947228', 15);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (42, 4, 179, 12, NULL, 'Cheque', '2024-05-02', '02', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET2691025733041973869', 16);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (43, 4, 180, 12, NULL, 'Cheque', '2024-05-02', '02', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET6265558563480650862', 16);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (44, 4, 181, 12, NULL, 'Cheque', '2024-05-02', '02', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET8402250604284891247', 16);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (45, 4, 182, 12, '15500', 'Cheque', '2024-05-02', '02', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET4558212378824357068', 16);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (46, 4, 72, 8, '35000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET1614509835271037619', 17);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (47, 4, 73, 8, '25000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET7046304915973466928', 17);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (48, 4, 74, 8, '5000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET6740627050285632814', 17);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (49, 4, 75, 8, '2000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET7425596860379183937', 17);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (50, 4, 179, 12, '3000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET6783297118306912522', 18);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (51, 4, 180, 12, '25000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET5873591717509111205', 18);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (52, 4, 181, 12, '2000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET8279069509938893528', 18);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (53, 4, 76, 14, '3000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET9836239399861040048', 19);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (54, 4, 77, 14, '25000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET3848920210856885550', 19);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (55, 4, 78, 14, '5000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET6053003800681822399', 19);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (56, 4, 79, 14, '2000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET1374249128915050542', 19);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (57, 4, 183, 17, '31500', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET6073672521095649448', 20);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (58, 4, 184, 17, '2000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET4328146931154142225', 20);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (59, 4, 185, 17, '1500', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET1518692269289722599', 20);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (60, 4, 144, 21, '3000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET4149739569048755963', 21);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (61, 4, 145, 21, '25000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET7161044358313401775', 21);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (62, 4, 146, 21, '2000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET6217667263431947738', 21);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (63, 4, 16, 22, '8000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET6491432836576780466', 22);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (64, 4, 17, 22, '5000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET6830762338132586008', 22);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (65, 4, 18, 22, '2000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET9573749974605882443', 22);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (66, 4, 80, 23, '35000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET2066093214460726224', 23);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (67, 4, 81, 23, '25000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET9207541796707853737', 23);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (68, 4, 82, 23, '5000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET7204491488463963928', 23);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (69, 4, 83, 23, '2000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET8311560782110738606', 23);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (70, 4, 13, 26, '35000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET7566019389831106903', 24);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (71, 4, 14, 26, '5000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET4366379282083676276', 24);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (72, 4, 15, 26, '2000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET7329906931961464491', 24);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (73, 4, 19, 27, '35000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET2298881617739719760', 25);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (74, 4, 20, 27, '5000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET8464832592589245755', 25);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (75, 4, 21, 27, '2000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET9987829326927025573', 25);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (76, 4, 138, 30, '12000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET7185906222167354560', 26);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (77, 4, 124, 34, '10000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET4385105555464818058', 27);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (78, 4, 125, 34, '2000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET8965788887160123952', 27);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (79, 4, 88, 36, '23000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET8207017773111105063', 28);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (80, 4, 89, 36, '25000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET7369196510818322659', 28);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (81, 4, 90, 36, '5000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET7629873726258190153', 28);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (82, 4, 91, 36, '2000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET9266717540138187786', 28);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (83, 4, 190, 37, NULL, 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET7901937045882711695', 29);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (84, 4, 191, 37, '18700', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET6629706752077738665', 29);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (85, 4, 192, 37, '2000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET2067356015467698262', 29);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (86, 4, 193, 37, '21000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET9759795161157999930', 29);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (87, 4, 135, 47, '13000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET7070445336314195283', 30);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (88, 4, 136, 47, '22500', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET4298536156853849262', 30);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (89, 4, 122, 20, '13000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET4120645684112164286', 31);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (90, 4, 123, 20, '2000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET7400722860958344096', 31);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (91, 4, 159, 25, NULL, 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET2799810076590640767', 32);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (92, 4, 160, 25, '23000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET7889006220167209274', 32);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (93, 4, 161, 25, '2000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET2038102562647943401', 32);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (94, 4, 162, 25, '5000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET2581027403884952240', 32);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (95, 4, 150, 29, '3000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET5517452394601584906', 33);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (96, 4, 151, 29, '25000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET1878633299683716328', 33);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (97, 4, 152, 29, '2000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET1680488677287520495', 33);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (98, 4, 22, 31, '13000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET4027812953057511478', 34);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (99, 4, 23, 31, '5000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET8363471405723517562', 34);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (100, 4, 24, 31, '2000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET9972017670170867279', 34);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (101, 4, 163, 32, '28000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET6694025685201904244', 35);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (102, 4, 164, 32, '5000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET5536212279558991782', 35);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (103, 4, 165, 32, '2000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET3945583214624427970', 35);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (104, 4, 166, 32, '6500', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET3897452479432673637', 35);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (105, 4, 28, 35, '10000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET1189784859700112493', 36);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (106, 4, 29, 35, '5000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET2446688235821129328', 36);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (107, 4, 30, 35, '2000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET8077763844090320910', 36);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (108, 4, 31, 38, '23000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET8192414719614765161', 37);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (109, 4, 32, 38, '5000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET4277215346375499716', 37);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (110, 4, 33, 38, '2000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET2829319081961818418', 37);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (111, 4, 100, 40, NULL, 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET7949234779177799703', 38);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (112, 4, 101, 40, '21000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET2132570262479179527', 38);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (113, 4, 102, 40, '5000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET3412909486366709820', 38);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (114, 4, 103, 40, '2000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET4795678765289114505', 38);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (115, 4, 167, 41, NULL, 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET9252284912341993540', 39);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (116, 4, 168, 41, NULL, 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET1691900305170788364', 39);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (117, 4, 169, 41, NULL, 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET6457588678127445343', 39);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (118, 4, 170, 41, '8000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET1108007446031675850', 39);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (119, 4, 175, 43, NULL, 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET5248250649584884877', 40);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (120, 4, 176, 43, NULL, 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET4206017882991367590', 40);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (121, 4, 177, 43, NULL, 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET3334493749407877146', 40);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (122, 4, 178, 43, '10000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET9267072141332327971', 40);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (123, 4, 116, 45, NULL, 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET4046849135260858165', 41);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (124, 4, 117, 45, '13000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET1389958649604494182', 41);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (125, 4, 118, 45, '5000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET2847094873912932576', 41);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (126, 4, 119, 45, '2000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET4274778779516155745', 41);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (127, 4, 40, 13, '13000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET2030540854966176258', 42);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (128, 4, 41, 13, '6000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET6916062498799085675', 42);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (129, 4, 42, 13, '2000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET7129052653467068438', 42);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (130, 4, 51, 15, '33000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET8517658631080859561', 43);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (131, 4, 52, 15, '5000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET6415465020846519229', 43);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (132, 4, 53, 15, '2000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET7730592531206402133', 43);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (133, 4, 54, 19, '18000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET5195171389170620267', 44);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (134, 4, 55, 19, '5000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET1713838404124783075', 44);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (135, 4, 56, 19, '2000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET4799931107223611682', 44);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (136, 4, 228, 18, '15000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET3272739349643921637', 45);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (137, 4, 229, 18, '25000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET6101421904844265351', 45);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (138, 4, 230, 18, '2000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET5461427365726623734', 45);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (139, 4, 231, 1, NULL, 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET5050579871509175630', 46);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (140, 4, 232, 1, NULL, 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET9790527443990554696', 46);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (141, 4, 233, 1, '5000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET7471862466955717859', 46);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (142, 4, 234, 1, NULL, 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET4374310611899572541', 46);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (143, 4, 235, 11, '16000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET3417674935793239080', 47);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (144, 4, 236, 11, '25000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET5928662155288124004', 47);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (145, 4, 237, 11, '2000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET2003214504826678002', 47);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (146, 4, 238, 11, '2000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET1031923260094887684', 47);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (147, 4, 239, 42, '3000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET9523089123714125849', 48);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (148, 4, 240, 42, '2000', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET4690741261077497872', 48);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (149, 4, 241, 42, '21500', 'Cheque', '2024-05-27', '27', '05', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET9252279823864002762', 48);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (150, 4, 7, 6, '21000', 'Cheque', '2024-06-03', '03', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET9578923853250331133', 49);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (152, 4, 10, 7, '17000', 'Cheque', '2024-06-03', '03', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET1374123252476068722', 51);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (153, 4, 16, 22, '10000', 'Cheque', '2024-06-03', '03', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET8466561249458685992', 52);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (154, 4, 242, 28, '24000', 'Cheque', '2024-06-03', '03', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET2092773308516367470', 53);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (155, 4, 243, 28, '2000', 'Cheque', '2024-06-03', '03', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET1057975222964454667', 53);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (156, 4, 244, 28, '7500', 'Cheque', '2024-06-03', '03', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET2149767892384172293', 53);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (157, 4, 245, 28, '25000', 'Cheque', '2024-06-03', '03', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET8730200286336411067', 53);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (158, 4, 246, 28, '5000', 'Cheque', '2024-06-03', '03', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET1366312409457593351', 53);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (159, 4, 247, 28, '8500', 'Cheque', '2024-06-03', '03', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET3480894844576920730', 53);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (160, 4, 126, 4, '13000', 'Cheque', '2024-06-03', '03', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET2483640810646089033', 54);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (161, 4, 127, 4, '25000', 'Cheque', '2024-06-03', '03', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET6406941985834558763', 54);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (162, 4, 128, 4, '2000', 'Cheque', '2024-06-03', '03', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET6749219831105527829', 54);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (163, 4, 201, 46, '30000', 'Cheque', '2024-06-03', '03', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET6162038496099249863', 55);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (164, 4, 202, 46, '25000', 'Cheque', '2024-06-03', '03', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET7168282355746952678', 55);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (165, 4, 203, 46, '5000', 'Cheque', '2024-06-03', '03', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET7523428239948033236', 55);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (166, 4, 204, 46, '2000', 'Cheque', '2024-06-03', '03', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET7059091414653322580', 55);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (167, 4, 28, 35, '25000', 'Cheque', '2024-06-03', '03', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET8364055048180425260', 56);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (168, 4, 40, 13, '10000', 'Cheque', '2024-06-04', '04', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET9615524265023068529', 57);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (169, 4, 4, 5, '15000', 'Cheque', '2024-06-04', '04', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET7971888473316037589', 58);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (170, 4, 5, 5, '5000', 'Cheque', '2024-06-04', '04', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET8534667917776438583', 58);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (171, 4, 6, 5, '2000', 'Cheque', '2024-06-04', '04', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET3032505605561339390', 58);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (172, 4, 37, 48, '13000', 'Cheque', '2024-06-04', '04', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET5295935886823391574', 59);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (173, 4, 38, 48, '5000', 'Cheque', '2024-06-04', '04', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET2965785825581380826', 59);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (174, 4, 39, 48, '2000', 'Cheque', '2024-06-04', '04', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET9902352477070482026', 59);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (175, 4, 150, 29, '22000', 'Cheque', '2024-06-04', '04', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET2680549195856473272', 60);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (176, 4, 63, 16, '35000', 'Cheque', '2024-06-04', '04', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET3308874330880157968', 61);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (177, 4, 64, 16, '5000', 'Cheque', '2024-06-04', '04', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET7156893088251019124', 61);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (178, 4, 65, 16, '2000', 'Cheque', '2024-06-04', '04', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET3385297059110045385', 61);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (179, 4, 122, 20, '22000', 'Cheque', '2024-06-04', '04', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET6281863794153011915', 62);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (180, 4, 51, 15, '2000', 'Cheque', '2024-06-07', '07', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET8131839141624935240', 63);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (181, 4, 54, 19, '17000', 'Cheque', '2024-06-07', '07', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET2430698179050822040', 64);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (182, 4, 239, 42, '10000', 'Cheque', '2024-06-07', '07', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET5629925815387175152', 65);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (183, 4, 175, 43, NULL, 'Cheque', '2024-06-07', '07', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET6709435513698001760', 66);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (184, 4, 176, 43, '1000', 'Cheque', '2024-06-07', '07', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET7902258665289803287', 66);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (185, 4, 177, 43, '2000', 'Cheque', '2024-06-07', '07', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET4667817613636302412', 66);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (186, 4, 178, 43, '12000', 'Cheque', '2024-06-07', '07', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET8140712388211188204', 66);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (187, 4, 167, 41, NULL, 'Cheque', '2024-06-07', '07', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET3749211725943177782', 67);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (188, 4, 168, 41, NULL, 'Cheque', '2024-06-07', '07', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET4365180305513629443', 67);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (189, 4, 169, 41, NULL, 'Cheque', '2024-06-07', '07', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET1843141795762612387', 67);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (190, 4, 170, 41, '4000', 'Cheque', '2024-06-07', '07', '06', '2024', 1, 5, 'JOSEPH WAMBUA', 'CASHANDCHEQUEANDWALLET9915665189624827264', 67);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (195, 4, 4, 5, '20000', 'Cheque', '2024-06-13', '13', '06', '2024', 1, 1, 'Skooly', 'CASHANDCHEQUEANDWALLET6456181812137064142', 69);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (196, 4, 126, 4, NULL, 'Cheque', '2024-06-13', '13', '06', '2024', 1, 1, 'Skooly', 'CASHANDCHEQUEANDWALLET4001720454929812718', 70);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (197, 4, 264, 52, '5000', 'Cheque', '2024-06-14', '14', '06', '2024', 1, 1, 'Skooly', 'CASHANDCHEQUEANDWALLET4515277529028692600', 71);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (198, 4, 265, 52, '1000', 'Cheque', '2024-06-14', '14', '06', '2024', 1, 1, 'Skooly', 'CASHANDCHEQUEANDWALLET4954603742792779456', 71);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (199, 4, 266, 52, '2000', 'Cheque', '2024-06-14', '14', '06', '2024', 1, 1, 'Skooly', 'CASHANDCHEQUEANDWALLET4295758472305627260', 71);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (200, 4, 267, 52, NULL, 'Cheque', '2024-06-14', '14', '06', '2024', 1, 1, 'Skooly', 'CASHANDCHEQUEANDWALLET9789233824584244818', 71);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (201, 4, 268, 53, '20000', 'Cheque', '2024-06-14', '14', '06', '2024', 1, 1, 'Skooly', 'CASHANDCHEQUEANDWALLET9894868271061828327', 72);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (202, 4, 269, 53, '1000', 'Cheque', '2024-06-14', '14', '06', '2024', 1, 1, 'Skooly', 'CASHANDCHEQUEANDWALLET5177492966335566398', 72);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (203, 4, 270, 53, '1500', 'Cheque', '2024-06-14', '14', '06', '2024', 1, 1, 'Skooly', 'CASHANDCHEQUEANDWALLET2884077251725863833', 72);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (204, 4, 271, 53, '3000', 'Cheque', '2024-06-14', '14', '06', '2024', 1, 1, 'Skooly', 'CASHANDCHEQUEANDWALLET7216152376946467141', 72);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (205, 4, 92, 2, NULL, 'Cheque', '2024-06-14', '14', '06', '2024', 1, 1, 'Skooly', 'CASHANDCHEQUEANDWALLET7504168494101103472', 73);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (206, 4, 235, 11, NULL, 'Cheque', '2024-06-14', '14', '06', '2024', 1, 1, 'Skooly', 'CASHANDCHEQUEANDWALLET3833101598707395803', 74);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (207, 4, 76, 14, '35000', 'Cheque', '2024-06-14', '14', '06', '2024', 1, 1, 'Skooly', 'CASHANDCHEQUEANDWALLET2068036852969908150', 75);
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES (208, 4, 272, 54, '600', 'Wallet', '2024-06-16', '16', '06', '2024', 1, 1, 'Skooly', 'CASHANDCHEQUEANDWALLET5188362425592649505', 76);


#
# TABLE STRUCTURE FOR: permission_relationships
#

DROP TABLE IF EXISTS `permission_relationships`;

CREATE TABLE `permission_relationships` (
  `permission_id` int(11) NOT NULL,
  `usertype_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (501, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (502, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (506, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (512, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (516, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (531, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (535, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (544, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (548, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (550, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (561, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (571, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (573, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (579, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (580, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (693, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (700, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (709, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (722, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (731, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (748, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (752, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (765, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (769, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (770, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (774, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (775, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (779, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (599, 4);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (501, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (512, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (516, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (531, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (554, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (556, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (579, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (580, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (687, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (688, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (689, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (704, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (705, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (706, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (707, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (708, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (709, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (710, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (711, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (712, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (713, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (714, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (715, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (716, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (717, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (718, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (719, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (720, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (721, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (765, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (769, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (770, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (774, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (775, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (779, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (788, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (789, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (790, 6);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (898, 10);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (906, 10);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (571, 12);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (572, 12);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (573, 12);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (501, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (579, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (744, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (745, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (746, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (748, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (749, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (750, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (751, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (752, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (756, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (757, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (758, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (760, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (761, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (762, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (808, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (502, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (503, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (504, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (506, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (583, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (584, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (585, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (805, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (806, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (807, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (817, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (818, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (895, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (898, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (899, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (905, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (653, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (654, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (655, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (656, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (657, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (658, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (659, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (660, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (661, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (662, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (663, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (664, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (665, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (666, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (667, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (668, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (669, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (670, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (671, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (672, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (673, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (674, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (675, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (676, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (677, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (678, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (900, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (901, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (902, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (903, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (904, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (507, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (508, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (509, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (510, 5);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (501, 3);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (512, 3);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (531, 3);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (544, 3);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (579, 3);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (748, 3);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (765, 3);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (769, 3);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (770, 3);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (774, 3);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (775, 3);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (779, 3);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (501, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (502, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (503, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (504, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (506, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (512, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (513, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (514, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (522, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (524, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (526, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (528, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (531, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (532, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (533, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (534, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (544, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (545, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (546, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (547, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (579, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (894, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (895, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (896, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (897, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (898, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (557, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (565, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (566, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (567, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (568, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (569, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (570, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (571, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (572, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (573, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (574, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (575, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (576, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (577, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (765, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (766, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (767, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (769, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (770, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (771, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (772, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (774, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (775, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (776, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (777, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (779, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (784, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (785, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (786, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (787, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (791, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (792, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (793, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (795, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (919, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (920, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (921, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (923, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (917, 9);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (501, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (512, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (531, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (544, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (545, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (546, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (571, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (572, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (573, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (579, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (765, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (769, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (770, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (774, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (775, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (779, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (787, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (791, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (793, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (794, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (898, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (522, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (526, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (557, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (565, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (917, 2);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (501, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (502, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (503, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (504, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (512, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (513, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (514, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (579, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (765, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (766, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (767, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (770, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (771, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (772, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (775, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (779, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (791, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (898, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (583, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (584, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (585, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (895, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (896, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (897, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (915, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (916, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (704, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (705, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (706, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (707, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (708, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (709, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (710, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (711, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (712, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (713, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (714, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (715, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (716, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (788, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (790, 7);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (501, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (502, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (503, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (504, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (505, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (506, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (522, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (523, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (524, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (525, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (526, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (527, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (528, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (530, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (531, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (532, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (533, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (534, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (579, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (583, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (584, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (585, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (608, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (609, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (610, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (611, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (612, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (613, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (614, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (615, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (616, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (617, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (618, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (619, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (620, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (621, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (622, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (653, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (654, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (655, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (656, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (657, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (658, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (659, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (660, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (661, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (662, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (663, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (664, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (665, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (666, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (667, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (668, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (669, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (670, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (671, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (672, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (673, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (674, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (675, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (676, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (677, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (678, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (744, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (745, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (746, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (747, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (748, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (749, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (750, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (751, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (752, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (753, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (754, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (755, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (756, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (757, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (758, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (759, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (760, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (761, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (762, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (763, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (764, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (765, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (766, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (767, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (768, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (769, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (770, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (771, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (772, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (773, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (774, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (775, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (776, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (777, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (778, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (779, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (802, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (803, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (805, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (806, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (807, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (811, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (812, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (817, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (818, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (819, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (820, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (851, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (894, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (895, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (896, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (897, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (898, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (899, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (900, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (901, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (902, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (903, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (904, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (512, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (513, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (514, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (515, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (516, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (544, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (545, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (546, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (547, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (557, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (558, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (559, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (560, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (565, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (566, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (567, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (568, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (571, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (572, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (573, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (574, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (575, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (576, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (577, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (704, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (705, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (706, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (707, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (708, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (709, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (710, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (711, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (712, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (713, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (714, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (715, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (716, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (791, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (792, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (793, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (795, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (845, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (846, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (847, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (848, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (849, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (784, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (517, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (518, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (519, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (520, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (521, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (915, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (916, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (840, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (917, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (918, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (920, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (921, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (923, 1);
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES (922, 1);


#
# TABLE STRUCTURE FOR: permissions
#

DROP TABLE IF EXISTS `permissions`;

CREATE TABLE `permissions` (
  `permissionID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'In most cases, this should be the name of the module (e.g. news)',
  `active` enum('yes','no') CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`permissionID`)
) ENGINE=InnoDB AUTO_INCREMENT=927 DEFAULT CHARSET=utf8;

INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (501, 'Dashboard', 'dashboard', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (502, 'Student', 'student', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (503, 'Student Add', 'student_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (504, 'Student Edit', 'student_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (505, 'Student Delete', 'student_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (506, 'Student View', 'student_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (507, 'Parents', 'parents', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (508, 'Parents Add', 'parents_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (509, 'Parents Edit', 'parents_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (510, 'Parents Delete', 'parents_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (511, 'Parents View', 'parents_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (512, 'Teacher', 'teacher', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (513, 'Teacher Add', 'teacher_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (514, 'Teacher Edit', 'teacher_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (515, 'Teacher Delete', 'teacher_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (516, 'Teacher View', 'teacher_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (517, 'User', 'user', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (518, 'User Add', 'user_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (519, 'User Edit', 'user_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (520, 'User Delete', 'user_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (521, 'User View', 'user_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (522, 'Class', 'classes', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (523, 'Class Add', 'classes_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (524, 'Class Edit', 'classes_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (525, 'Class Delete', 'classes_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (526, 'Section', 'section', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (527, 'Section Add', 'section_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (528, 'Section Edit', 'section_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (529, 'Semester Delete', 'semester_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (530, 'Section Delete', 'section_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (531, 'Subject', 'subject', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (532, 'Subject Add', 'subject_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (533, 'Subject Edit', 'subject_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (534, 'Subject Delete', 'subject_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (535, 'Syllabus', 'syllabus', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (536, 'Syllabus Add', 'syllabus_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (537, 'Syllabus Edit', 'syllabus_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (538, 'Syllabus Delete', 'syllabus_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (539, 'Assignment', 'assignment', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (540, 'Assignment Add', 'assignment_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (541, 'Assignment Edit', 'assignment_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (542, 'Assignment Delete', 'assignment_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (543, 'Assignment View', 'assignment_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (544, 'Routine', 'routine', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (545, 'Routine Add', 'routine_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (546, 'Routine Edit', 'routine_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (547, 'Routine Delete', 'routine_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (548, 'Student Attendance', 'sattendance', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (549, 'Student Attendance Add', 'sattendance_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (550, 'Student Attendance View', 'sattendance_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (551, 'Teacher Attendance', 'tattendance', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (552, 'Teacher Attendance Add', 'tattendance_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (553, 'Teacher Attendance View', 'tattendance_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (554, 'User Attendance', 'uattendance', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (555, 'User Attendance Add', 'uattendance_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (556, 'User Attendance View', 'uattendance_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (557, 'Exam', 'exam', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (558, 'Exam Add', 'exam_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (559, 'Exam Edit', 'exam_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (560, 'Exam Delete', 'exam_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (561, 'Examschedule', 'examschedule', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (562, 'Examschedule Add', 'examschedule_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (563, 'Examschedule Edit', 'examschedule_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (564, 'Examschedule Delete', 'examschedule_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (565, 'Grade', 'grade', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (566, 'Grade Add', 'grade_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (567, 'Grade Edit', 'grade_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (568, 'Grade Delete', 'grade_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (569, 'Exam Attendance', 'eattendance', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (570, 'Exam Attendance Add', 'eattendance_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (571, 'Mark', 'mark', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (572, 'Mark Add', 'mark_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (573, 'Mark View', 'mark_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (574, 'Mark Distribution', 'markpercentage', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (575, 'Mark Distribution Add', 'markpercentage_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (576, 'Mark Distribution Edit', 'markpercentage_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (577, 'Mark Distribution Delete', 'markpercentage_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (578, 'Promotion', 'promotion', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (579, 'Message', 'conversation', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (580, 'Media', 'media', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (581, 'Media Add', 'media_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (582, 'Media Delete', 'media_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (583, 'Mail / SMS', 'mailandsms', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (584, 'Mail / SMS Add', 'mailandsms_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (585, 'Mail / SMS View', 'mailandsms_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (586, 'Question Group', 'question_group', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (587, 'Question Group Add', 'question_group_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (588, 'Question Group Edit', 'question_group_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (589, 'Question Group Delete', 'question_group_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (590, 'Question Level', 'question_level', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (591, 'Question Level Add', 'question_level_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (592, 'Question Level Edit', 'question_level_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (593, 'Question Level Delete', 'question_level_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (594, 'Question Bank', 'question_bank', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (595, 'Question Bank Add', 'question_bank_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (596, 'Question Bank Edit', 'question_bank_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (597, 'Question Bank Delete', 'question_bank_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (598, 'Question Bank View', 'question_bank_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (599, 'Online Exam', 'online_exam', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (600, 'Online Exam Add', 'online_exam_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (601, 'Online Exam Edit', 'online_exam_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (602, 'Online Exam Delete', 'online_exam_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (603, 'Instruction', 'instruction', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (604, 'Instruction Add', 'instruction_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (605, 'Instruction Edit', 'instruction_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (606, 'Instruction Delete', 'instruction_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (607, 'Instruction View', 'instruction_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (608, 'Salary Template', 'salary_template', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (609, 'Salary Template Add', 'salary_template_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (610, 'Salary Template Edit', 'salary_template_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (611, 'Salary Template Delete', 'salary_template_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (612, 'Salary Template View', 'salary_template_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (613, 'Hourly Template', 'hourly_template', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (614, 'Hourly Template Add', 'hourly_template_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (615, 'Hourly Template Edit', 'hourly_template_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (616, 'Hourly Template Delete', 'hourly_template_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (617, 'Manage Salary', 'manage_salary', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (618, 'Manage Salary Add', 'manage_salary_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (619, 'Manage Salary Edit', 'manage_salary_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (620, 'Manage Salary Delete', 'manage_salary_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (621, 'Manage Salary View', 'manage_salary_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (622, 'Make Payment', 'make_payment', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (623, 'Overtime', 'overtime', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (624, 'Overtime Add', 'overtime_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (625, 'Overtime Edit', 'overtime_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (626, 'Overtime Delete', 'overtime_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (627, 'Vendor', 'vendor', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (628, 'Vendor Add', 'vendor_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (629, 'Vendor Edit', 'vendor_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (630, 'Vendor Delete', 'vendor_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (631, 'Location', 'location', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (632, 'Location Add', 'location_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (633, 'Location Edit', 'location_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (634, 'Location Delete', 'location_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (635, 'Asset Category', 'asset_category', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (636, 'Asset Category Add', 'asset_category_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (637, 'Asset Category Edit', 'asset_category_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (638, 'Asset Category Delete', 'asset_category_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (639, 'Asset', 'asset', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (640, 'Asset Add', 'asset_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (641, 'Asset Edit', 'asset_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (642, 'Asset Delete', 'asset_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (643, 'Asset View', 'asset_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (644, 'Asset Assignment', 'asset_assignment', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (645, 'Asset Assignment Add', 'asset_assignment_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (646, 'Asset Assignment Edit', 'asset_assignment_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (647, 'Asset Assignment Delete', 'asset_assignment_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (648, 'Asset Assignment View', 'asset_assignment_view', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (649, 'Purchase', 'purchase', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (650, 'Purchase Add', 'purchase_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (651, 'Purchase Edit', 'purchase_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (652, 'Purchase Delete', 'purchase_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (653, 'Product Category', 'productcategory', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (654, 'Product Category Add', 'productcategory_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (655, 'Product Category Edit', 'productcategory_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (656, 'Product Category Delete', 'productcategory_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (657, 'Product', 'product', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (658, 'Product Add', 'product_add', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (659, 'Product Edit', 'product_edit', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (660, 'Product Delete', 'product_delete', 'yes');
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES (661, 'Warehouse', 'productwarehouse', 'yes');
INSERT INTO `permissions` (`permissionI